/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.pointsto.flow;

import com.oracle.graal.pointsto.BigBang;
import com.oracle.graal.pointsto.flow.MethodFlowsGraph;
import com.oracle.graal.pointsto.flow.TypeFlow;
import com.oracle.graal.pointsto.meta.AnalysisField;
import com.oracle.graal.pointsto.typestate.TypeState;
import jdk.vm.ci.code.BytecodePosition;
import org.graalvm.compiler.nodes.java.AccessFieldNode;

public abstract class AccessFieldTypeFlow
extends TypeFlow<BytecodePosition> {
    protected final AnalysisField field;

    protected AccessFieldTypeFlow(AccessFieldNode node) {
        super(node.getNodeSourcePosition(), ((AnalysisField)node.field()).getType());
        this.field = (AnalysisField)node.field();
    }

    protected AccessFieldTypeFlow(AccessFieldTypeFlow original, MethodFlowsGraph methodFlows) {
        super(original, methodFlows);
        this.field = original.field;
    }

    public AnalysisField field() {
        return this.field;
    }

    @Override
    public final boolean addState(BigBang bb, TypeState add) {
        assert (this.isClone());
        return super.addState(bb, add);
    }

    protected TypeState filterObjectState(BigBang bb, TypeState objectState) {
        if (bb.analysisPolicy().relaxTypeFlowConstraints()) {
            return TypeState.forIntersection(bb, objectState, this.field.getDeclaringClass().getTypeFlow(bb, true).getState());
        }
        return objectState;
    }
}

