/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.pointsto.phases;

import java.util.ArrayList;
import java.util.Arrays;
import org.graalvm.compiler.bytecode.Bytecode;
import org.graalvm.compiler.debug.DebugContext;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.nodes.FrameState;
import org.graalvm.compiler.nodes.StateSplit;
import org.graalvm.compiler.nodes.StructuredGraph;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.graphbuilderconf.GeneratedInvocationPlugin;
import org.graalvm.compiler.nodes.java.ExceptionObjectNode;
import org.graalvm.compiler.nodes.spi.CoreProviders;
import org.graalvm.compiler.options.OptionValues;
import org.graalvm.compiler.replacements.IntrinsicGraphBuilder;

public class SubstrateIntrinsicGraphBuilder
extends IntrinsicGraphBuilder {
    private int bci;

    public SubstrateIntrinsicGraphBuilder(OptionValues options, DebugContext debug, CoreProviders providers, Bytecode code) {
        super(options, debug, providers, code, -1, StructuredGraph.AllowAssumptions.NO);
        this.setStateAfter((StateSplit)this.getGraph().start());
    }

    public void setStateAfter(StateSplit sideEffect) {
        ArrayList<ValueNode> values = new ArrayList<ValueNode>(Arrays.asList(this.arguments));
        int stackSize = 0;
        if (this.returnValue != null) {
            values.add(this.returnValue);
            ++stackSize;
            if (this.method.getSignature().getReturnKind().needsTwoSlots()) {
                values.add(null);
                ++stackSize;
            }
        }
        FrameState stateAfter = (FrameState)this.getGraph().add((Node)new FrameState(null, this.code, this.bci, values, this.arguments.length, stackSize, false, false, null, null));
        sideEffect.setStateAfter(stateAfter);
        ++this.bci;
    }

    protected void setExceptionState(ExceptionObjectNode exceptionObject) {
        ArrayList<ValueNode> values = new ArrayList<ValueNode>(Arrays.asList(this.arguments));
        values.add((ValueNode)exceptionObject);
        int stackSize = 1;
        FrameState stateAfter = (FrameState)this.getGraph().add((Node)new FrameState(null, this.code, this.bci, values, this.arguments.length, stackSize, true, false, null, null));
        exceptionObject.setStateAfter(stateAfter);
        ++this.bci;
    }

    public int bci() {
        return this.bci;
    }

    public boolean canDeferPlugin(GeneratedInvocationPlugin plugin) {
        return plugin.isGeneratedFromFoldOrNodeIntrinsic();
    }
}

