/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.toolchain.launchers;

import com.oracle.truffle.llvm.toolchain.launchers.common.Driver;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import org.graalvm.nativeimage.ProcessProperties;

public final class BinUtil {
    public static void main(String[] args) {
        String processName = BinUtil.getProcessName();
        if (processName == null) {
            System.err.println("Error: Could not figure out process name");
            System.exit(1);
        }
        if (!processName.startsWith("llvm-")) {
            processName = "llvm-" + processName;
        }
        Driver driver = new Driver();
        String targetName = driver.getLLVMBinDir().resolve(processName).toString();
        ArrayList<String> utilArgs = new ArrayList<String>(args.length + 1);
        utilArgs.add(targetName);
        if (args.length > 0) {
            utilArgs.addAll(Arrays.asList(args));
        }
        ProcessBuilder pb = new ProcessBuilder(utilArgs).redirectError(ProcessBuilder.Redirect.INHERIT).redirectInput(ProcessBuilder.Redirect.INHERIT).redirectOutput(ProcessBuilder.Redirect.INHERIT);
        Process p = null;
        try {
            p = pb.start();
            p.waitFor();
            System.exit(p.exitValue());
        }
        catch (IOException e) {
            System.err.println("Error: " + e.getMessage());
            driver.printMissingToolMessage();
            System.exit(1);
        }
        catch (InterruptedException e) {
            if (p != null) {
                p.destroyForcibly();
            }
            System.err.println("Error: Subprocess interrupted: " + e.getMessage());
            System.exit(1);
        }
    }

    private static String getProcessName() {
        Path p;
        Path f;
        String binPathName = System.getProperty("org.graalvm.launcher.executablename");
        if (binPathName == null) {
            if (ProcessProperties.getArgumentVectorBlockSize() <= 0) {
                return null;
            }
            binPathName = ProcessProperties.getArgumentVectorProgramName();
            if (binPathName == null) {
                return null;
            }
        }
        if ((f = (p = Paths.get(binPathName, new String[0])).getFileName()) == null) {
            return null;
        }
        return f.toString();
    }
}

