/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.regex.runtime.nodes;

import com.oracle.truffle.api.CallTarget;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.nodes.DirectCallNode;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.IndirectCallNode;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.regex.runtime.nodes.DispatchNode;
import java.util.concurrent.locks.Lock;

@GeneratedBy(value=DispatchNode.class)
public final class DispatchNodeGen
extends DispatchNode {
    private static final Uncached UNCACHED = new Uncached();
    @CompilerDirectives.CompilationFinal
    private volatile int state_;
    @CompilerDirectives.CompilationFinal
    private volatile int exclude_;
    @Node.Child
    private ExecuteDirectData executeDirect_cache;
    @Node.Child
    private IndirectCallNode executeIndirect_callNode_;

    private DispatchNodeGen() {
    }

    @Override
    @ExplodeLoop
    public Object execute(CallTarget arg0Value, Object[] arg1Value) {
        int state = this.state_;
        if (state != 0) {
            if ((state & 1) != 0) {
                ExecuteDirectData s1_ = this.executeDirect_cache;
                while (s1_ != null) {
                    if (arg0Value == s1_.cachedTarget_) {
                        return DispatchNode.executeDirect(arg0Value, arg1Value, s1_.cachedTarget_, s1_.callNode_);
                    }
                    s1_ = s1_.next_;
                }
            }
            if ((state & 2) != 0) {
                return DispatchNode.executeIndirect(arg0Value, arg1Value, this.executeIndirect_callNode_);
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return this.executeAndSpecialize(arg0Value, arg1Value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object executeAndSpecialize(CallTarget arg0Value, Object[] arg1Value) {
        Lock lock = this.getLock();
        boolean hasLock = true;
        lock.lock();
        int state = this.state_;
        int exclude = this.exclude_;
        try {
            if (exclude == 0) {
                int count1_ = 0;
                ExecuteDirectData s1_ = this.executeDirect_cache;
                if ((state & 1) != 0) {
                    while (s1_ != null && arg0Value != s1_.cachedTarget_) {
                        s1_ = s1_.next_;
                        ++count1_;
                    }
                }
                if (s1_ == null && count1_ < 3) {
                    s1_ = (ExecuteDirectData)super.insert((Node)new ExecuteDirectData(this.executeDirect_cache));
                    s1_.cachedTarget_ = arg0Value;
                    s1_.callNode_ = s1_.insertAccessor(DirectCallNode.create((CallTarget)s1_.cachedTarget_));
                    this.executeDirect_cache = s1_;
                    this.state_ = state |= 1;
                }
                if (s1_ != null) {
                    lock.unlock();
                    hasLock = false;
                    Object object = DispatchNode.executeDirect(arg0Value, arg1Value, s1_.cachedTarget_, s1_.callNode_);
                    return object;
                }
            }
            this.executeIndirect_callNode_ = (IndirectCallNode)super.insert((Node)IndirectCallNode.create());
            this.exclude_ = exclude |= 1;
            this.executeDirect_cache = null;
            state &= 0xFFFFFFFE;
            this.state_ = state |= 2;
            lock.unlock();
            hasLock = false;
            Object object = DispatchNode.executeIndirect(arg0Value, arg1Value, this.executeIndirect_callNode_);
            return object;
        }
        finally {
            if (hasLock) {
                lock.unlock();
            }
        }
    }

    public NodeCost getCost() {
        ExecuteDirectData s1_;
        int state = this.state_;
        if (state == 0) {
            return NodeCost.UNINITIALIZED;
        }
        if ((state & state - 1) == 0 && ((s1_ = this.executeDirect_cache) == null || s1_.next_ == null)) {
            return NodeCost.MONOMORPHIC;
        }
        return NodeCost.POLYMORPHIC;
    }

    public static DispatchNode create() {
        return new DispatchNodeGen();
    }

    public static DispatchNode getUncached() {
        return UNCACHED;
    }

    @GeneratedBy(value=DispatchNode.class)
    private static final class Uncached
    extends DispatchNode {
        private Uncached() {
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public Object execute(CallTarget arg0Value, Object[] arg1Value) {
            return DispatchNode.executeIndirect(arg0Value, arg1Value, IndirectCallNode.getUncached());
        }

        public NodeCost getCost() {
            return NodeCost.MEGAMORPHIC;
        }

        public boolean isAdoptable() {
            return false;
        }
    }

    @GeneratedBy(value=DispatchNode.class)
    private static final class ExecuteDirectData
    extends Node {
        @Node.Child
        ExecuteDirectData next_;
        @CompilerDirectives.CompilationFinal
        CallTarget cachedTarget_;
        @Node.Child
        DirectCallNode callNode_;

        ExecuteDirectData(ExecuteDirectData next_) {
            this.next_ = next_;
        }

        public NodeCost getCost() {
            return NodeCost.NONE;
        }

        <T extends Node> T insertAccessor(T node) {
            return (T)super.insert(node);
        }
    }
}

