/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.tools.lsp.exceptions;

import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.graalvm.tools.lsp.server.types.Diagnostic;
import org.graalvm.tools.lsp.server.types.PublishDiagnosticsParams;

public final class DiagnosticsNotification
extends Exception {
    private static final long serialVersionUID = 8517876447166873194L;
    private final Collection<PublishDiagnosticsParams> paramsCollection;

    public static DiagnosticsNotification create(URI uri, Diagnostic diagnostic) {
        PublishDiagnosticsParams params = PublishDiagnosticsParams.create(uri.toString(), Arrays.asList(diagnostic));
        return new DiagnosticsNotification(params);
    }

    public DiagnosticsNotification(PublishDiagnosticsParams diagnosticParams) {
        this.paramsCollection = Arrays.asList(diagnosticParams);
    }

    public DiagnosticsNotification(Collection<PublishDiagnosticsParams> paramsCollection) {
        this.paramsCollection = paramsCollection;
    }

    public DiagnosticsNotification(Map<URI, List<Diagnostic>> paramsMap) {
        this.paramsCollection = new ArrayList<PublishDiagnosticsParams>(paramsMap.size());
        for (Map.Entry<URI, List<Diagnostic>> entry : paramsMap.entrySet()) {
            this.paramsCollection.add(PublishDiagnosticsParams.create(entry.getKey().toString(), entry.getValue()));
        }
    }

    public Collection<PublishDiagnosticsParams> getDiagnosticParamsCollection() {
        return this.paramsCollection;
    }
}

