/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.tools.lsp.server.request;

import com.oracle.truffle.api.Scope;
import com.oracle.truffle.api.TruffleException;
import com.oracle.truffle.api.TruffleLogger;
import com.oracle.truffle.api.frame.MaterializedFrame;
import com.oracle.truffle.api.instrumentation.InstrumentableNode;
import com.oracle.truffle.api.instrumentation.TruffleInstrument;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.source.Source;
import com.oracle.truffle.api.source.SourceSection;
import java.io.PrintWriter;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import org.graalvm.tools.lsp.server.ContextAwareExecutor;
import org.graalvm.tools.lsp.server.utils.CoverageData;
import org.graalvm.tools.lsp.server.utils.NearestSectionsFinder;
import org.graalvm.tools.lsp.server.utils.SourcePredicateBuilder;
import org.graalvm.tools.lsp.server.utils.SourceUtils;
import org.graalvm.tools.lsp.server.utils.SourceWrapper;
import org.graalvm.tools.lsp.server.utils.TextDocumentSurrogate;
import org.graalvm.tools.lsp.server.utils.TextDocumentSurrogateMap;

public abstract class AbstractRequestHandler {
    protected final TruffleInstrument.Env env;
    protected final TextDocumentSurrogateMap surrogateMap;
    protected final PrintWriter err;
    protected final ContextAwareExecutor contextAwareExecutor;
    protected final TruffleLogger logger;

    AbstractRequestHandler(TruffleInstrument.Env mainEnv, TruffleInstrument.Env env, TextDocumentSurrogateMap surrogateMap, ContextAwareExecutor contextAwareExecutor) {
        this.env = env;
        this.err = new PrintWriter(mainEnv.err(), true);
        this.surrogateMap = surrogateMap;
        this.contextAwareExecutor = contextAwareExecutor;
        this.logger = mainEnv.getLogger("");
    }

    public final InstrumentableNode findNodeAtCaret(TextDocumentSurrogate surrogate, int line, int character, Class<?> ... tag) {
        Source source;
        SourceWrapper sourceWrapper;
        if (surrogate != null && (sourceWrapper = surrogate.getSourceWrapper()).isParsingSuccessful() && SourceUtils.isLineValid(line, source = sourceWrapper.getSource())) {
            SourceSection nextNodeSection;
            int oneBasedColumn;
            int oneBasedLineNumber = SourceUtils.zeroBasedLineToOneBasedLine(line, source);
            NearestSectionsFinder.NearestSections nearestSections = NearestSectionsFinder.findNearestSections(source, this.env, oneBasedLineNumber, oneBasedColumn = SourceUtils.zeroBasedColumnToOneBasedColumn(line, oneBasedLineNumber, character, source), true, tag);
            if (nearestSections.getNextSourceSection() != null && (nextNodeSection = nearestSections.getNextSourceSection()).getStartLine() == oneBasedLineNumber && nextNodeSection.getStartColumn() == oneBasedColumn) {
                return nearestSections.getInstrumentableNextNode();
            }
            return nearestSections.getInstrumentableContainsNode();
        }
        return null;
    }

    protected final <T> T getFutureResultOrHandleExceptions(Future<T> future) {
        try {
            return future.get();
        }
        catch (ExecutionException e) {
            if (e.getCause() instanceof RuntimeException && e instanceof TruffleException) {
                throw (RuntimeException)e.getCause();
            }
            e.printStackTrace(this.err);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return null;
    }

    protected final LinkedList<Scope> getScopesOuterToInner(TextDocumentSurrogate surrogate, InstrumentableNode node) {
        CoverageData data;
        List<CoverageData> coverageData = surrogate.getCoverageData(((Node)node).getSourceSection());
        MaterializedFrame frame = null;
        if (coverageData != null && (data = (CoverageData)coverageData.stream().findFirst().orElse(null)) != null) {
            frame = data.getFrame();
        }
        Iterable scopesInnerToOuter = this.env.findLocalScopes((Node)node, frame);
        LinkedList<Scope> scopesOuterToInner = new LinkedList<Scope>();
        for (Scope scope : scopesInnerToOuter) {
            scopesOuterToInner.addFirst(scope);
        }
        return scopesOuterToInner;
    }

    protected final SourcePredicateBuilder newDefaultSourcePredicateBuilder() {
        return SourcePredicateBuilder.newBuilder().excludeInternal(this.env.getOptions()).newestSource(this.surrogateMap);
    }
}

