/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.tools.lsp.server.request;

import com.oracle.truffle.api.Scope;
import com.oracle.truffle.api.instrumentation.InstrumentableNode;
import com.oracle.truffle.api.instrumentation.StandardTags;
import com.oracle.truffle.api.instrumentation.TruffleInstrument;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeVisitor;
import com.oracle.truffle.api.source.SourceSection;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import org.graalvm.tools.lsp.server.ContextAwareExecutor;
import org.graalvm.tools.lsp.server.request.AbstractRequestHandler;
import org.graalvm.tools.lsp.server.types.DocumentHighlight;
import org.graalvm.tools.lsp.server.types.DocumentHighlightKind;
import org.graalvm.tools.lsp.server.types.Range;
import org.graalvm.tools.lsp.server.utils.InteropUtils;
import org.graalvm.tools.lsp.server.utils.SourceUtils;
import org.graalvm.tools.lsp.server.utils.TextDocumentSurrogate;
import org.graalvm.tools.lsp.server.utils.TextDocumentSurrogateMap;

public final class HighlightRequestHandler
extends AbstractRequestHandler {
    public HighlightRequestHandler(TruffleInstrument.Env envMain, TruffleInstrument.Env env, TextDocumentSurrogateMap surrogateMap, ContextAwareExecutor executor) {
        super(envMain, env, surrogateMap, executor);
    }

    public List<? extends DocumentHighlight> highlightWithEnteredContext(URI uri, int line, int character) {
        TextDocumentSurrogate surrogate = this.surrogateMap.get(uri);
        InstrumentableNode nodeAtCaret = this.findNodeAtCaret(surrogate, line, character, new Class[0]);
        if (nodeAtCaret != null && (nodeAtCaret.hasTag(StandardTags.ReadVariableTag.class) || nodeAtCaret.hasTag(StandardTags.WriteVariableTag.class))) {
            return this.findOtherReadOrWrites(surrogate, nodeAtCaret, line, character);
        }
        return Collections.emptyList();
    }

    List<? extends DocumentHighlight> findOtherReadOrWrites(TextDocumentSurrogate surrogate, InstrumentableNode nodeAtCaret, int line, int character) {
        InteropUtils.VariableInfo[] caretVariables = InteropUtils.getNodeObjectVariables(nodeAtCaret);
        if (caretVariables.length > 0) {
            final HashSet<String> variableNames = new HashSet<String>();
            for (InteropUtils.VariableInfo varInfo : caretVariables) {
                if (!HighlightRequestHandler.contains(varInfo.getSourceSection(), line, character)) continue;
                variableNames.add(varInfo.getName());
            }
            LinkedList<Scope> scopesOuterToInner = this.getScopesOuterToInner(surrogate, nodeAtCaret);
            final ArrayList highlights = new ArrayList();
            for (Scope scope : scopesOuterToInner) {
                Node scopeRoot = scope.getNode();
                if (scopeRoot == null) continue;
                scopeRoot.accept(new NodeVisitor(){

                    public boolean visit(Node node) {
                        InstrumentableNode instrumentableNode;
                        if (node instanceof InstrumentableNode && ((instrumentableNode = (InstrumentableNode)node).hasTag(StandardTags.WriteVariableTag.class) || instrumentableNode.hasTag(StandardTags.ReadVariableTag.class))) {
                            InteropUtils.VariableInfo[] variables = InteropUtils.getNodeObjectVariables(instrumentableNode);
                            assert (variables.length > 0) : instrumentableNode.getClass().getCanonicalName() + ": " + instrumentableNode.toString();
                            for (InteropUtils.VariableInfo varInfo : variables) {
                                SourceSection sourceSection;
                                if (!variableNames.contains(varInfo.getName()) || !SourceUtils.isValidSourceSection(sourceSection = varInfo.getSourceSection(), HighlightRequestHandler.this.env.getOptions())) continue;
                                Range range = SourceUtils.sourceSectionToRange(sourceSection);
                                DocumentHighlightKind kind = instrumentableNode.hasTag(StandardTags.WriteVariableTag.class) ? DocumentHighlightKind.Write : DocumentHighlightKind.Read;
                                DocumentHighlight highlight = DocumentHighlight.create(range, kind);
                                highlights.add(highlight);
                            }
                        }
                        return true;
                    }
                });
            }
            return highlights;
        }
        return Collections.emptyList();
    }

    private static boolean contains(SourceSection sourceSection, int zeroBasedLineNumber, int zeroBasedColumnNumber) {
        int line = SourceUtils.zeroBasedLineToOneBasedLine(zeroBasedLineNumber, sourceSection.getSource());
        int column = SourceUtils.zeroBasedColumnToOneBasedColumn(zeroBasedLineNumber, line, zeroBasedColumnNumber, sourceSection.getSource());
        int startLine = sourceSection.getStartLine();
        int endLine = sourceSection.getEndLine();
        return (startLine < line || startLine == line && sourceSection.getStartColumn() <= column) && (line < endLine || line == endLine && column <= sourceSection.getEndColumn());
    }
}

