/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.tools.lsp.server.request;

import com.oracle.truffle.api.instrumentation.InstrumentableNode;
import com.oracle.truffle.api.instrumentation.SourceSectionFilter;
import com.oracle.truffle.api.instrumentation.StandardTags;
import com.oracle.truffle.api.instrumentation.TruffleInstrument;
import com.oracle.truffle.api.interop.InteropException;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.InvalidArrayIndexException;
import com.oracle.truffle.api.interop.TruffleObject;
import com.oracle.truffle.api.interop.UnknownIdentifierException;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.nodes.LanguageInfo;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.source.Source;
import com.oracle.truffle.api.source.SourceSection;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import org.graalvm.tools.api.lsp.LSPLibrary;
import org.graalvm.tools.lsp.exceptions.DiagnosticsNotification;
import org.graalvm.tools.lsp.server.ContextAwareExecutor;
import org.graalvm.tools.lsp.server.LanguageTriggerCharacters;
import org.graalvm.tools.lsp.server.request.AbstractRequestHandler;
import org.graalvm.tools.lsp.server.request.CompletionRequestHandler;
import org.graalvm.tools.lsp.server.request.SourceCodeEvaluator;
import org.graalvm.tools.lsp.server.types.ParameterInformation;
import org.graalvm.tools.lsp.server.types.SignatureHelp;
import org.graalvm.tools.lsp.server.types.SignatureInformation;
import org.graalvm.tools.lsp.server.utils.EvaluationResult;
import org.graalvm.tools.lsp.server.utils.InteropUtils;
import org.graalvm.tools.lsp.server.utils.SourceUtils;
import org.graalvm.tools.lsp.server.utils.TextDocumentSurrogate;
import org.graalvm.tools.lsp.server.utils.TextDocumentSurrogateMap;

public final class SignatureHelpRequestHandler
extends AbstractRequestHandler {
    private static final String PROP_DOCUMENTATION = "documentation";
    private static final String PROP_PARAMETERS = "parameters";
    private static final String PROP_LABEL = "label";
    private static final InteropLibrary INTEROP = (InteropLibrary)InteropLibrary.getFactory().getUncached();
    private static final LSPLibrary LSP_INTEROP = (LSPLibrary)LSPLibrary.getFactory().getUncached();
    private final SourceCodeEvaluator sourceCodeEvaluator;
    private final CompletionRequestHandler completionHandler;
    private final LanguageTriggerCharacters signatureTriggerCharacters;

    public SignatureHelpRequestHandler(TruffleInstrument.Env envMain, TruffleInstrument.Env env, TextDocumentSurrogateMap surrogateMap, ContextAwareExecutor contextAwareExecutor, SourceCodeEvaluator sourceCodeEvaluator, CompletionRequestHandler completionHandler, LanguageTriggerCharacters signatureTriggerCharacters) {
        super(envMain, env, surrogateMap, contextAwareExecutor);
        this.sourceCodeEvaluator = sourceCodeEvaluator;
        this.completionHandler = completionHandler;
        this.signatureTriggerCharacters = signatureTriggerCharacters;
    }

    public SignatureHelp signatureHelpWithEnteredContext(URI uri, int line, int originalCharacter) throws DiagnosticsNotification {
        Object result;
        SourceSectionFilter inputFilter;
        SourceSectionFilter.Builder builder;
        SourceSectionFilter eventFilter;
        SourceSection signatureSection;
        EvaluationResult evalResult;
        InstrumentableNode nodeAtCaret;
        TextDocumentSurrogate surrogate = this.surrogateMap.get(uri);
        if (this.isSignatureHelpTriggerCharOfLanguage(surrogate, line, originalCharacter) && (nodeAtCaret = this.findNodeAtCaret(surrogate, line, originalCharacter, StandardTags.CallTag.class)) != null && (evalResult = this.sourceCodeEvaluator.runToSectionAndEval(surrogate, signatureSection = ((Node)nodeAtCaret).getSourceSection(), eventFilter = (builder = SourceCodeEvaluator.createSourceSectionFilter(surrogate.getUri(), signatureSection)).tagIs(new Class[]{StandardTags.CallTag.class}).build(), inputFilter = SourceSectionFilter.ANY)).isEvaluationDone() && !evalResult.isError() && INTEROP.accepts(result = evalResult.getResult()) && INTEROP.isExecutable(result)) {
            try {
                Object signature = LSP_INTEROP.getSignature(result);
                LanguageInfo langInfo = surrogate.getLanguageInfo();
                String label = INTEROP.asString(INTEROP.toDisplayString(this.env.getLanguageView(langInfo, signature)));
                SignatureInformation info = SignatureInformation.create(label, null, new ParameterInformation[0]);
                if (signature instanceof TruffleObject) {
                    Object paramsObject;
                    Object doc;
                    Object documentation;
                    if (INTEROP.isMemberReadable(signature, PROP_DOCUMENTATION) && (documentation = this.completionHandler.getDocumentation(doc = INTEROP.readMember(signature, PROP_DOCUMENTATION), langInfo)) != null) {
                        info.setDocumentation(documentation);
                    }
                    if (INTEROP.isMemberReadable(signature, PROP_PARAMETERS) && (paramsObject = INTEROP.readMember(signature, PROP_PARAMETERS)) instanceof TruffleObject && INTEROP.hasArrayElements(paramsObject)) {
                        long size = INTEROP.getArraySize(paramsObject);
                        ArrayList<ParameterInformation> paramInfos = new ArrayList<ParameterInformation>((int)size);
                        for (long i = 0L; i < size; ++i) {
                            ParameterInformation paramInfo;
                            Object param;
                            if (!INTEROP.isArrayElementReadable(paramsObject, i) || !((param = INTEROP.readArrayElement(paramsObject, i)) instanceof TruffleObject) || (paramInfo = this.getParameterInformation(param, label, langInfo)) == null) continue;
                            paramInfos.add(paramInfo);
                        }
                        info.setParameters(paramInfos);
                    }
                }
                Object nodeObject = nodeAtCaret.getNodeObject();
                Integer numberOfArguments = InteropUtils.getNumberOfArguments(nodeObject, this.logger);
                return SignatureHelp.create(Arrays.asList(info), 0, numberOfArguments != null ? numberOfArguments - 1 : 0);
            }
            catch (UnsupportedMessageException e) {
                this.logger.log(Level.FINEST, "GET_SIGNATURE message not supported for TruffleObject: {0}", result);
            }
            catch (InteropException e) {
                e.printStackTrace(this.err);
            }
        }
        return SignatureHelp.create(Collections.emptyList(), null, null);
    }

    private ParameterInformation getParameterInformation(Object param, String label, LanguageInfo langInfo) throws UnsupportedMessageException, UnknownIdentifierException, InvalidArrayIndexException {
        String paramLabel;
        Object paramLabelObject;
        Object object = paramLabelObject = INTEROP.isMemberReadable(param, PROP_LABEL) ? INTEROP.readMember(param, PROP_LABEL) : null;
        if (paramLabelObject instanceof String) {
            paramLabel = (String)paramLabelObject;
        } else if (paramLabelObject instanceof TruffleObject && INTEROP.hasArrayElements(paramLabelObject)) {
            long size = INTEROP.getArraySize(paramLabelObject);
            if (size < 2L) {
                this.logger.fine("ERROR: Insufficient number of label indexes: " + size + " from " + paramLabelObject);
                return null;
            }
            Object i1Obj = INTEROP.readArrayElement(paramLabelObject, 0L);
            Object i2Obj = INTEROP.readArrayElement(paramLabelObject, 1L);
            if (!INTEROP.fitsInInt(i1Obj) || !INTEROP.fitsInInt(i2Obj)) {
                this.logger.fine("ERROR: Label indexes of " + paramLabelObject + " are not numbers: " + i1Obj + ", " + i2Obj);
                return null;
            }
            paramLabel = label.substring(INTEROP.asInt(i1Obj), INTEROP.asInt(i2Obj));
        } else {
            this.logger.fine("ERROR: Unknown label object: " + paramLabelObject + " in " + param);
            return null;
        }
        ParameterInformation info = ParameterInformation.create(paramLabel, null);
        Object doc = INTEROP.isMemberReadable(param, PROP_DOCUMENTATION) ? INTEROP.readMember(param, PROP_DOCUMENTATION) : null;
        Object documentation = this.completionHandler.getDocumentation(doc, langInfo);
        if (documentation != null) {
            info.setDocumentation(documentation);
        }
        return info;
    }

    private boolean isSignatureHelpTriggerCharOfLanguage(TextDocumentSurrogate surrogate, int line, int charOffset) {
        Source source = surrogate.getSource();
        CharSequence characters = source.getCharacters(SourceUtils.zeroBasedLineToOneBasedLine(line, source));
        int triggerCharOffset = charOffset - 1;
        char signatureTirggerChar = characters.charAt(triggerCharOffset);
        List<String> signatureHelpTriggerCharacters = this.signatureTriggerCharacters.getTriggerCharacters(surrogate.getLanguageId());
        return signatureHelpTriggerCharacters.contains(String.valueOf(signatureTirggerChar));
    }
}

