/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.tools.lsp.server.request;

import com.oracle.truffle.api.CallTarget;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.Scope;
import com.oracle.truffle.api.TruffleException;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.instrumentation.EventBinding;
import com.oracle.truffle.api.instrumentation.EventContext;
import com.oracle.truffle.api.instrumentation.ExecutionEventNode;
import com.oracle.truffle.api.instrumentation.ExecutionEventNodeFactory;
import com.oracle.truffle.api.instrumentation.InstrumentableNode;
import com.oracle.truffle.api.instrumentation.SourceSectionFilter;
import com.oracle.truffle.api.instrumentation.StandardTags;
import com.oracle.truffle.api.instrumentation.TruffleInstrument;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.TruffleObject;
import com.oracle.truffle.api.interop.UnknownIdentifierException;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.nodes.ExecutableNode;
import com.oracle.truffle.api.nodes.LanguageInfo;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeVisitor;
import com.oracle.truffle.api.source.Source;
import com.oracle.truffle.api.source.SourceSection;
import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.regex.Matcher;
import org.graalvm.tools.lsp.exceptions.DiagnosticsNotification;
import org.graalvm.tools.lsp.exceptions.EvaluationResultException;
import org.graalvm.tools.lsp.exceptions.UnknownLanguageException;
import org.graalvm.tools.lsp.server.ContextAwareExecutor;
import org.graalvm.tools.lsp.server.request.AbstractRequestHandler;
import org.graalvm.tools.lsp.server.types.Diagnostic;
import org.graalvm.tools.lsp.server.types.DiagnosticSeverity;
import org.graalvm.tools.lsp.server.utils.CoverageData;
import org.graalvm.tools.lsp.server.utils.CoverageEventNode;
import org.graalvm.tools.lsp.server.utils.EvaluationResult;
import org.graalvm.tools.lsp.server.utils.InteropUtils;
import org.graalvm.tools.lsp.server.utils.SourcePredicateBuilder;
import org.graalvm.tools.lsp.server.utils.SourceUtils;
import org.graalvm.tools.lsp.server.utils.SourceWrapper;
import org.graalvm.tools.lsp.server.utils.TextDocumentSurrogate;
import org.graalvm.tools.lsp.server.utils.TextDocumentSurrogateMap;

public final class SourceCodeEvaluator
extends AbstractRequestHandler {
    private static final InteropLibrary INTEROP = (InteropLibrary)InteropLibrary.getFactory().getUncached();

    public SourceCodeEvaluator(TruffleInstrument.Env envMain, TruffleInstrument.Env env, TextDocumentSurrogateMap surrogateMap, ContextAwareExecutor executor) {
        super(envMain, env, surrogateMap, executor);
    }

    public CallTarget parse(TextDocumentSurrogate surrogate) throws DiagnosticsNotification {
        if (!this.env.getLanguages().containsKey(surrogate.getLanguageId())) {
            throw new UnknownLanguageException("Unknown language: " + surrogate.getLanguageId() + ". Known languages are: " + this.env.getLanguages().keySet());
        }
        SourceWrapper sourceWrapper = surrogate.prepareParsing();
        CallTarget callTarget = null;
        try {
            this.logger.log(Level.FINE, "Parsing {0} {1}", new Object[]{surrogate.getLanguageId(), surrogate.getUri()});
            callTarget = this.env.parse(sourceWrapper.getSource(), new String[0]);
            this.logger.log(Level.FINER, "Parsing done.");
            surrogate.notifyParsingDone(callTarget);
        }
        catch (Exception e) {
            try {
                if (e instanceof TruffleException) {
                    throw DiagnosticsNotification.create(surrogate.getUri(), Diagnostic.create(SourceUtils.getRangeFrom((TruffleException)e), e.getMessage(), DiagnosticSeverity.Error, null, "Graal", null));
                }
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                surrogate.notifyParsingDone(callTarget);
                throw throwable;
            }
        }
        return callTarget;
    }

    public EvaluationResult tryDifferentEvalStrategies(TextDocumentSurrogate surrogate, Node nearestNode) throws DiagnosticsNotification {
        this.logger.fine("Trying literal eval...");
        EvaluationResult literalResult = this.evalLiteral(nearestNode);
        if (literalResult.isEvaluationDone() && !literalResult.isError()) {
            return literalResult;
        }
        EvaluationResult coverageEvalResult = this.evalWithCoverageData(surrogate, nearestNode);
        if (coverageEvalResult.isEvaluationDone() && !coverageEvalResult.isError()) {
            return coverageEvalResult;
        }
        this.logger.fine("Trying run-to-section eval...");
        EvaluationResult runToSectionEvalResult = this.runToSectionAndEval(surrogate, nearestNode);
        if (runToSectionEvalResult.isEvaluationDone()) {
            return runToSectionEvalResult;
        }
        this.logger.fine("Trying global eval...");
        EvaluationResult globalScopeEvalResult = this.evalInGlobalScope(surrogate.getLanguageId(), nearestNode);
        if (globalScopeEvalResult.isError()) {
            return EvaluationResult.createEvaluationSectionNotReached();
        }
        return globalScopeEvalResult;
    }

    private EvaluationResult evalLiteral(Node nearestNode) {
        Object nodeObject = ((InstrumentableNode)nearestNode).getNodeObject();
        if (nodeObject instanceof TruffleObject) {
            try {
                if (INTEROP.isMemberReadable(nodeObject, "literal")) {
                    Object result = INTEROP.readMember(nodeObject, "literal");
                    assert (result instanceof TruffleObject || InteropUtils.isPrimitive(result));
                    return EvaluationResult.createResult(result);
                }
            }
            catch (UnknownIdentifierException | UnsupportedMessageException e) {
                this.logger.warning(e.getMessage());
                return EvaluationResult.createError(e);
            }
        }
        return EvaluationResult.createEvaluationSectionNotReached();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private EvaluationResult evalWithCoverageData(TextDocumentSurrogate textDocumentSurrogate, Node nearestNode) {
        InteropUtils.VariableInfo[] variables;
        if (!textDocumentSurrogate.hasCoverageData()) {
            return EvaluationResult.createEvaluationSectionNotReached();
        }
        List<CoverageData> dataBeforeNode = SourceCodeEvaluator.findCoverageDataBeforeNode(textDocumentSurrogate, nearestNode);
        if (dataBeforeNode == null || dataBeforeNode.isEmpty()) {
            return EvaluationResult.createEvaluationSectionNotReached();
        }
        CoverageData coverageData = dataBeforeNode.get(dataBeforeNode.size() - 1);
        if (((InstrumentableNode)nearestNode).hasTag(StandardTags.ReadVariableTag.class) && (variables = InteropUtils.getNodeObjectVariables((InstrumentableNode)nearestNode)).length == 1) {
            InteropUtils.VariableInfo var = variables[0];
            for (Scope scope : this.env.findLocalScopes(nearestNode, (Frame)coverageData.getFrame())) {
                if (!INTEROP.isMemberReadable(scope.getVariables(), var.getName())) continue;
                this.logger.fine("Coverage-based variable look-up");
                try {
                    Object value = INTEROP.readMember(scope.getVariables(), var.getName());
                    return EvaluationResult.createResult(value);
                }
                catch (UnknownIdentifierException | UnsupportedMessageException ex) {
                    throw new AssertionError("Unexpected interop exception", ex);
                }
            }
        }
        LanguageInfo info = nearestNode.getRootNode().getLanguageInfo();
        String code = nearestNode.getSourceSection().getCharacters().toString();
        Source inlineEvalSource = Source.newBuilder((String)info.getId(), (CharSequence)code, (String)"in-line eval (hover request)").cached(false).build();
        ExecutableNode executableNode = this.env.parseInline(inlineEvalSource, nearestNode, coverageData.getFrame());
        CoverageEventNode coverageEventNode = coverageData.getCoverageEventNode();
        coverageEventNode.insertOrReplaceChild((Node)executableNode);
        try {
            this.logger.fine("Trying coverage-based eval...");
            Object result = executableNode.execute((VirtualFrame)coverageData.getFrame());
            EvaluationResult evaluationResult = EvaluationResult.createResult(result);
            return evaluationResult;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            coverageEventNode.clearChild();
        }
        return EvaluationResult.createEvaluationSectionNotReached();
    }

    public EvaluationResult runToSectionAndEval(TextDocumentSurrogate surrogate, Node nearestNode) throws DiagnosticsNotification {
        if (!(nearestNode instanceof InstrumentableNode) || !((InstrumentableNode)nearestNode).isInstrumentable()) {
            return EvaluationResult.createEvaluationSectionNotReached();
        }
        SourceSectionFilter eventFilter = SourceCodeEvaluator.createSourceSectionFilter(surrogate.getUri(), nearestNode.getSourceSection()).build();
        return this.runToSectionAndEval(surrogate, nearestNode.getSourceSection(), eventFilter, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EvaluationResult runToSectionAndEval(TextDocumentSurrogate surrogate, SourceSection sourceSection, SourceSectionFilter eventFilter, SourceSectionFilter inputFilter) throws DiagnosticsNotification {
        Set<URI> coverageUris = surrogate.getCoverageUris(sourceSection);
        URI runScriptUriFallback = coverageUris == null ? null : coverageUris.stream().findFirst().orElseGet(() -> null);
        TextDocumentSurrogate surrogateOfTestFile = this.createSurrogateForTestFile(surrogate, runScriptUriFallback);
        CallTarget callTarget = this.parse(surrogateOfTestFile);
        final boolean isInputFilterDefined = inputFilter != null;
        EventBinding binding = this.env.getInstrumenter().attachExecutionEventFactory(eventFilter, inputFilter, new ExecutionEventNodeFactory(){
            StringBuilder indent = new StringBuilder("");

            public ExecutionEventNode create(final EventContext context) {
                return new ExecutionEventNode(){

                    private String sourceSectionFormat(SourceSection section) {
                        return "SourceSection(" + section.getCharacters().toString().replaceAll("\n", Matcher.quoteReplacement("\\n")) + ")";
                    }

                    public void onReturnValue(VirtualFrame frame, Object result) {
                        if (SourceCodeEvaluator.this.logger.isLoggable(Level.FINEST)) {
                            this.logOnReturnValue(result);
                        }
                        if (!isInputFilterDefined) {
                            CompilerDirectives.transferToInterpreter();
                            throw new EvaluationResultException(result);
                        }
                    }

                    @CompilerDirectives.TruffleBoundary
                    private void logOnReturnValue(Object result) {
                        if (indent.length() > 1) {
                            indent.setLength(indent.length() - 2);
                        }
                        SourceCodeEvaluator.this.logger.log(Level.FINEST, "{0}onReturnValue {1} {2} {3} {4}", new Object[]{indent, context.getInstrumentedNode().getClass().getSimpleName(), this.sourceSectionFormat(context.getInstrumentedSourceSection()), result});
                    }

                    public void onReturnExceptional(VirtualFrame frame, Throwable exception) {
                        if (SourceCodeEvaluator.this.logger.isLoggable(Level.FINEST)) {
                            this.logOnReturnExceptional();
                        }
                    }

                    @CompilerDirectives.TruffleBoundary
                    private void logOnReturnExceptional() {
                        indent.setLength(indent.length() - 2);
                        SourceCodeEvaluator.this.logger.log(Level.FINEST, "{0}onReturnExceptional {1}", new Object[]{indent, this.sourceSectionFormat(context.getInstrumentedSourceSection())});
                    }

                    public void onEnter(VirtualFrame frame) {
                        if (SourceCodeEvaluator.this.logger.isLoggable(Level.FINEST)) {
                            this.logOnEnter();
                        }
                    }

                    @CompilerDirectives.TruffleBoundary
                    private void logOnEnter() {
                        SourceCodeEvaluator.this.logger.log(Level.FINEST, "{0}onEnter {1} {2}", new Object[]{indent, context.getInstrumentedNode().getClass().getSimpleName(), this.sourceSectionFormat(context.getInstrumentedSourceSection())});
                        indent.append("  ");
                    }

                    public void onInputValue(VirtualFrame frame, EventContext inputContext, int inputIndex, Object inputValue) {
                        if (SourceCodeEvaluator.this.logger.isLoggable(Level.FINEST)) {
                            this.logOnInputValue(inputContext, inputIndex, inputValue);
                        }
                        CompilerDirectives.transferToInterpreter();
                        throw new EvaluationResultException(inputValue);
                    }

                    @CompilerDirectives.TruffleBoundary
                    private void logOnInputValue(EventContext inputContext, int inputIndex, Object inputValue) {
                        String metaObject;
                        indent.setLength(indent.length() - 2);
                        Object view = SourceCodeEvaluator.this.env.getLanguageView(inputContext.getInstrumentedNode().getRootNode().getLanguageInfo(), inputValue);
                        try {
                            metaObject = INTEROP.hasMetaObject(view) ? INTEROP.asString(INTEROP.toDisplayString(INTEROP.getMetaObject(view))) : null;
                        }
                        catch (UnsupportedMessageException e) {
                            CompilerDirectives.transferToInterpreter();
                            throw new AssertionError((Object)e);
                        }
                        SourceCodeEvaluator.this.logger.log(Level.FINEST, "{0}onInputValue idx:{1} {2} {3} {4} {5} {6}", new Object[]{indent, inputIndex, inputContext.getInstrumentedNode().getClass().getSimpleName(), this.sourceSectionFormat(context.getInstrumentedSourceSection()), this.sourceSectionFormat(inputContext.getInstrumentedSourceSection()), inputValue, metaObject});
                        indent.append("  ");
                    }
                };
            }
        });
        try {
            callTarget.call(new Object[0]);
        }
        catch (EvaluationResultException e) {
            EvaluationResult evaluationResult = e.isError() ? EvaluationResult.createError(e.getResult()) : EvaluationResult.createResult(e.getResult());
            return evaluationResult;
        }
        catch (RuntimeException e) {
            if (e instanceof TruffleException) {
                if (((TruffleException)e).isExit()) {
                    EvaluationResult evaluationResult = EvaluationResult.createEvaluationSectionNotReached();
                    return evaluationResult;
                }
                EvaluationResult evaluationResult = EvaluationResult.createError(e);
                return evaluationResult;
            }
        }
        finally {
            binding.dispose();
        }
        return EvaluationResult.createEvaluationSectionNotReached();
    }

    public TextDocumentSurrogate createSurrogateForTestFile(TextDocumentSurrogate surrogateOfOpenedFile, URI runScriptUriFallback) {
        URI runScriptUri = runScriptUriFallback != null ? runScriptUriFallback : surrogateOfOpenedFile.getUri();
        String langIdOfTestFile = SourceCodeEvaluator.findLanguageOfTestFile(runScriptUri, surrogateOfOpenedFile.getLanguageId());
        LanguageInfo languageInfo = (LanguageInfo)this.env.getLanguages().get(langIdOfTestFile);
        assert (languageInfo != null);
        TextDocumentSurrogate surrogateOfTestFile = this.surrogateMap.getOrCreateSurrogate(runScriptUri, languageInfo);
        return surrogateOfTestFile;
    }

    private static String findLanguageOfTestFile(URI runScriptUri, String fallbackLangId) {
        try {
            return Source.findLanguage((URL)runScriptUri.toURL());
        }
        catch (IOException e) {
            return fallbackLangId;
        }
    }

    private EvaluationResult evalInGlobalScope(String langId, Node nearestNode) {
        SourceSection section = nearestNode.getSourceSection();
        if (section == null || !section.isAvailable()) {
            return EvaluationResult.createUnknownExecutionTarget();
        }
        try {
            CallTarget callTarget = this.env.parse(Source.newBuilder((String)langId, (CharSequence)section.getCharacters(), (String)"eval in global scope").cached(false).build(), new String[0]);
            Object result = callTarget.call(new Object[0]);
            return EvaluationResult.createResult(result);
        }
        catch (Exception e) {
            return EvaluationResult.createError(e);
        }
    }

    static SourceSectionFilter.Builder createSourceSectionFilter(URI uri, SourceSection sourceSection) {
        return SourceSectionFilter.newBuilder().lineStartsIn(new SourceSectionFilter.IndexRange[]{SourceSectionFilter.IndexRange.between((int)sourceSection.getStartLine(), (int)(sourceSection.getStartLine() + 1))}).lineEndsIn(new SourceSectionFilter.IndexRange[]{SourceSectionFilter.IndexRange.between((int)sourceSection.getEndLine(), (int)(sourceSection.getEndLine() + 1))}).columnStartsIn(new SourceSectionFilter.IndexRange[]{SourceSectionFilter.IndexRange.between((int)sourceSection.getStartColumn(), (int)(sourceSection.getStartColumn() + 1))}).columnEndsIn(new SourceSectionFilter.IndexRange[]{SourceSectionFilter.IndexRange.between((int)sourceSection.getEndColumn(), (int)(sourceSection.getEndColumn() + 1))}).sourceIs(SourcePredicateBuilder.newBuilder().uriOrTruffleName(uri).build());
    }

    static List<CoverageData> findCoverageDataBeforeNode(final TextDocumentSurrogate surrogate, final Node targetNode) {
        final ArrayList<CoverageData> coveragesBeforeNode = new ArrayList<CoverageData>();
        targetNode.getRootNode().accept(new NodeVisitor(){
            boolean found = false;

            public boolean visit(Node node) {
                List<CoverageData> coverageData;
                if (this.found) {
                    return false;
                }
                if (node.equals(targetNode)) {
                    this.found = true;
                    return false;
                }
                SourceSection sourceSection = node.getSourceSection();
                if (sourceSection != null && sourceSection.isAvailable() && (coverageData = surrogate.getCoverageData(sourceSection)) != null) {
                    coveragesBeforeNode.addAll(coverageData);
                }
                return true;
            }
        });
        return coveragesBeforeNode;
    }
}

