/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.tools.lsp.server.types;

import com.oracle.truffle.tools.utils.json.JSONArray;
import com.oracle.truffle.tools.utils.json.JSONObject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.graalvm.tools.lsp.server.types.CodeActionKind;
import org.graalvm.tools.lsp.server.types.Diagnostic;
import org.graalvm.tools.lsp.server.types.JSONBase;

public class CodeActionContext
extends JSONBase {
    CodeActionContext(JSONObject jsonData) {
        super(jsonData);
    }

    public List<Diagnostic> getDiagnostics() {
        JSONArray json = this.jsonData.getJSONArray("diagnostics");
        ArrayList<Diagnostic> list = new ArrayList<Diagnostic>(json.length());
        for (int i = 0; i < json.length(); ++i) {
            list.add(new Diagnostic(json.getJSONObject(i)));
        }
        return Collections.unmodifiableList(list);
    }

    public CodeActionContext setDiagnostics(List<Diagnostic> diagnostics) {
        JSONArray json = new JSONArray();
        for (Diagnostic diagnostic : diagnostics) {
            json.put(diagnostic.jsonData);
        }
        this.jsonData.put("diagnostics", json);
        return this;
    }

    public List<CodeActionKind> getOnly() {
        JSONArray json = this.jsonData.optJSONArray("only");
        if (json == null) {
            return null;
        }
        ArrayList<CodeActionKind> list = new ArrayList<CodeActionKind>(json.length());
        for (int i = 0; i < json.length(); ++i) {
            list.add(CodeActionKind.get(json.getString(i)));
        }
        return Collections.unmodifiableList(list);
    }

    public CodeActionContext setOnly(List<CodeActionKind> only) {
        if (only != null) {
            JSONArray json = new JSONArray();
            for (CodeActionKind codeActionKind : only) {
                json.put(codeActionKind.getStringValue());
            }
            this.jsonData.put("only", json);
        }
        return this;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CodeActionContext other = (CodeActionContext)obj;
        if (!Objects.equals(this.getDiagnostics(), other.getDiagnostics())) {
            return false;
        }
        return Objects.equals(this.getOnly(), other.getOnly());
    }

    public int hashCode() {
        int hash = 7;
        hash = 97 * hash + Objects.hashCode(this.getDiagnostics());
        if (this.getOnly() != null) {
            hash = 97 * hash + Objects.hashCode(this.getOnly());
        }
        return hash;
    }

    public static CodeActionContext create(List<Diagnostic> diagnostics, List<CodeActionKind> only) {
        JSONObject json = new JSONObject();
        JSONArray diagnosticsJsonArr = new JSONArray();
        for (Diagnostic diagnostic : diagnostics) {
            diagnosticsJsonArr.put(diagnostic.jsonData);
        }
        json.put("diagnostics", diagnosticsJsonArr);
        if (only != null) {
            JSONArray onlyJsonArr = new JSONArray();
            for (CodeActionKind codeActionKind : only) {
                onlyJsonArr.put(codeActionKind.getStringValue());
            }
            json.put("only", onlyJsonArr);
        }
        return new CodeActionContext(json);
    }
}

