/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.tools.lsp.server.types;

import com.oracle.truffle.tools.utils.json.JSONObject;
import java.util.Objects;
import org.graalvm.tools.lsp.server.types.CompletionTriggerKind;
import org.graalvm.tools.lsp.server.types.JSONBase;

public class CompletionContext
extends JSONBase {
    CompletionContext(JSONObject jsonData) {
        super(jsonData);
    }

    public CompletionTriggerKind getTriggerKind() {
        return CompletionTriggerKind.get(this.jsonData.getInt("triggerKind"));
    }

    public CompletionContext setTriggerKind(CompletionTriggerKind triggerKind) {
        this.jsonData.put("triggerKind", triggerKind.getIntValue());
        return this;
    }

    public String getTriggerCharacter() {
        return this.jsonData.optString("triggerCharacter", null);
    }

    public CompletionContext setTriggerCharacter(String triggerCharacter) {
        this.jsonData.putOpt("triggerCharacter", triggerCharacter);
        return this;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CompletionContext other = (CompletionContext)obj;
        if (this.getTriggerKind() != other.getTriggerKind()) {
            return false;
        }
        return Objects.equals(this.getTriggerCharacter(), other.getTriggerCharacter());
    }

    public int hashCode() {
        int hash = 5;
        hash = 59 * hash + Objects.hashCode((Object)this.getTriggerKind());
        if (this.getTriggerCharacter() != null) {
            hash = 59 * hash + Objects.hashCode(this.getTriggerCharacter());
        }
        return hash;
    }

    public static CompletionContext create(CompletionTriggerKind triggerKind) {
        JSONObject json = new JSONObject();
        json.put("triggerKind", triggerKind.getIntValue());
        return new CompletionContext(json);
    }
}

