/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.tools.lsp.server.types;

import java.util.HashMap;
import java.util.Map;

public enum CompletionItemKind {
    Text(1),
    Method(2),
    Function(3),
    Constructor(4),
    Field(5),
    Variable(6),
    Class(7),
    Interface(8),
    Module(9),
    Property(10),
    Unit(11),
    Value(12),
    Enum(13),
    Keyword(14),
    Snippet(15),
    Color(16),
    File(17),
    Reference(18),
    Folder(19),
    EnumMember(20),
    Constant(21),
    Struct(22),
    Event(23),
    Operator(24),
    TypeParameter(25);

    private final int intValue;
    private static final Map<Integer, CompletionItemKind> lookup;

    private CompletionItemKind(int intValue) {
        this.intValue = intValue;
    }

    public int getIntValue() {
        return this.intValue;
    }

    public static CompletionItemKind get(Integer intValue) {
        return lookup.get(intValue);
    }

    static {
        lookup = new HashMap<Integer, CompletionItemKind>();
        for (CompletionItemKind value : CompletionItemKind.values()) {
            lookup.put(value.getIntValue(), value);
        }
    }
}

