/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.tools.lsp.server.types;

import com.oracle.truffle.tools.utils.json.JSONArray;
import com.oracle.truffle.tools.utils.json.JSONObject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.graalvm.tools.lsp.server.types.JSONBase;
import org.graalvm.tools.lsp.server.types.MarkedString;
import org.graalvm.tools.lsp.server.types.MarkupContent;
import org.graalvm.tools.lsp.server.types.Range;

public class Hover
extends JSONBase {
    Hover(JSONObject jsonData) {
        super(jsonData);
    }

    public Object getContents() {
        Object obj = this.jsonData.get("contents");
        if (obj instanceof JSONArray) {
            ArrayList<Object> list = new ArrayList<Object>(((JSONArray)obj).length());
            for (int i = 0; i < ((JSONArray)obj).length(); ++i) {
                Object o = ((JSONArray)obj).get(i);
                list.add(o instanceof JSONObject ? new MarkedString((JSONObject)o) : o);
            }
            return Collections.unmodifiableList(list);
        }
        if (obj instanceof JSONObject) {
            if (((JSONObject)obj).has("kind")) {
                return new MarkupContent((JSONObject)obj);
            }
            return new MarkedString((JSONObject)obj);
        }
        return obj;
    }

    public Hover setContents(Object contents) {
        if (contents instanceof List) {
            JSONArray json = new JSONArray();
            for (Object obj : (List)contents) {
                json.put(obj instanceof MarkedString ? ((MarkedString)obj).jsonData : obj);
            }
            this.jsonData.put("contents", json);
        } else if (contents instanceof MarkupContent) {
            this.jsonData.put("contents", ((MarkupContent)contents).jsonData);
        } else if (contents instanceof MarkedString) {
            this.jsonData.put("contents", ((MarkedString)contents).jsonData);
        } else {
            this.jsonData.put("contents", contents);
        }
        return this;
    }

    public Range getRange() {
        return this.jsonData.has("range") ? new Range(this.jsonData.optJSONObject("range")) : null;
    }

    public Hover setRange(Range range) {
        this.jsonData.putOpt("range", range != null ? range.jsonData : null);
        return this;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Hover other = (Hover)obj;
        if (!Objects.equals(this.getContents(), other.getContents())) {
            return false;
        }
        return Objects.equals(this.getRange(), other.getRange());
    }

    public int hashCode() {
        int hash = 7;
        hash = 47 * hash + Objects.hashCode(this.getContents());
        if (this.getRange() != null) {
            hash = 47 * hash + Objects.hashCode(this.getRange());
        }
        return hash;
    }

    public static Hover create(Object contents) {
        JSONObject json = new JSONObject();
        if (contents instanceof List) {
            JSONArray jsonArr = new JSONArray();
            for (Object obj : (List)contents) {
                jsonArr.put(obj instanceof MarkedString ? ((MarkedString)obj).jsonData : obj);
            }
            json.put("contents", jsonArr);
        } else if (contents instanceof MarkupContent) {
            json.put("contents", ((MarkupContent)contents).jsonData);
        } else if (contents instanceof MarkedString) {
            json.put("contents", ((MarkedString)contents).jsonData);
        } else {
            json.put("contents", contents);
        }
        return new Hover(json);
    }
}

