/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.tools.lsp.server.types;

import com.oracle.truffle.tools.utils.json.JSONArray;
import com.oracle.truffle.tools.utils.json.JSONObject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.graalvm.tools.lsp.server.types.JSONBase;
import org.graalvm.tools.lsp.server.types.MarkupKind;
import org.graalvm.tools.lsp.server.types.SuppressFBWarnings;

public class HoverClientCapabilities
extends JSONBase {
    HoverClientCapabilities(JSONObject jsonData) {
        super(jsonData);
    }

    @SuppressFBWarnings(value={"NP_BOOLEAN_RETURN_NULL"})
    public Boolean getDynamicRegistration() {
        return this.jsonData.has("dynamicRegistration") ? Boolean.valueOf(this.jsonData.getBoolean("dynamicRegistration")) : null;
    }

    public HoverClientCapabilities setDynamicRegistration(Boolean dynamicRegistration) {
        this.jsonData.putOpt("dynamicRegistration", dynamicRegistration);
        return this;
    }

    public List<MarkupKind> getContentFormat() {
        JSONArray json = this.jsonData.optJSONArray("contentFormat");
        if (json == null) {
            return null;
        }
        ArrayList<MarkupKind> list = new ArrayList<MarkupKind>(json.length());
        for (int i = 0; i < json.length(); ++i) {
            list.add(MarkupKind.get(json.getString(i)));
        }
        return Collections.unmodifiableList(list);
    }

    public HoverClientCapabilities setContentFormat(List<MarkupKind> contentFormat) {
        if (contentFormat != null) {
            JSONArray json = new JSONArray();
            for (MarkupKind markupKind : contentFormat) {
                json.put(markupKind.getStringValue());
            }
            this.jsonData.put("contentFormat", json);
        }
        return this;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        HoverClientCapabilities other = (HoverClientCapabilities)obj;
        if (!Objects.equals(this.getDynamicRegistration(), other.getDynamicRegistration())) {
            return false;
        }
        return Objects.equals(this.getContentFormat(), other.getContentFormat());
    }

    public int hashCode() {
        int hash = 7;
        if (this.getDynamicRegistration() != null) {
            hash = 53 * hash + Boolean.hashCode(this.getDynamicRegistration());
        }
        if (this.getContentFormat() != null) {
            hash = 53 * hash + Objects.hashCode(this.getContentFormat());
        }
        return hash;
    }

    public static HoverClientCapabilities create() {
        JSONObject json = new JSONObject();
        return new HoverClientCapabilities(json);
    }
}

