/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.tools.lsp.server.types;

import com.oracle.truffle.tools.utils.json.JSONObject;
import org.graalvm.tools.lsp.server.types.JSONBase;

public class ReferenceContext
extends JSONBase {
    ReferenceContext(JSONObject jsonData) {
        super(jsonData);
    }

    public boolean isIncludeDeclaration() {
        return this.jsonData.getBoolean("includeDeclaration");
    }

    public ReferenceContext setIncludeDeclaration(boolean includeDeclaration) {
        this.jsonData.put("includeDeclaration", includeDeclaration);
        return this;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ReferenceContext other = (ReferenceContext)obj;
        return this.isIncludeDeclaration() == other.isIncludeDeclaration();
    }

    public int hashCode() {
        int hash = 5;
        hash = 41 * hash + Boolean.hashCode(this.isIncludeDeclaration());
        return hash;
    }

    public static ReferenceContext create(Boolean includeDeclaration) {
        JSONObject json = new JSONObject();
        json.put("includeDeclaration", includeDeclaration);
        return new ReferenceContext(json);
    }
}

