/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.tools.lsp.server.types;

import com.oracle.truffle.tools.utils.json.JSONObject;
import java.util.Objects;
import org.graalvm.tools.lsp.server.types.Message;
import org.graalvm.tools.lsp.server.types.ResponseErrorLiteral;

public class ResponseMessage
extends Message {
    ResponseMessage(JSONObject jsonData) {
        super(jsonData);
    }

    public Object getId() {
        return this.jsonData.get("id");
    }

    public ResponseMessage setId(Object id) {
        this.jsonData.put("id", id);
        return this;
    }

    public Object getResult() {
        return this.jsonData.opt("result");
    }

    public ResponseMessage setResult(Object result) {
        this.jsonData.putOpt("result", result);
        return this;
    }

    public ResponseErrorLiteral getError() {
        return this.jsonData.has("error") ? new ResponseErrorLiteral(this.jsonData.optJSONObject("error")) : null;
    }

    public ResponseMessage setError(ResponseErrorLiteral error) {
        this.jsonData.putOpt("error", error != null ? error.jsonData : null);
        return this;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ResponseMessage other = (ResponseMessage)obj;
        if (!Objects.equals(this.getId(), other.getId())) {
            return false;
        }
        if (!Objects.equals(this.getResult(), other.getResult())) {
            return false;
        }
        if (!Objects.equals(this.getError(), other.getError())) {
            return false;
        }
        return Objects.equals(this.getJsonrpc(), other.getJsonrpc());
    }

    @Override
    public int hashCode() {
        int hash = 2;
        hash = 11 * hash + Objects.hashCode(this.getId());
        if (this.getResult() != null) {
            hash = 11 * hash + Objects.hashCode(this.getResult());
        }
        if (this.getError() != null) {
            hash = 11 * hash + Objects.hashCode(this.getError());
        }
        hash = 11 * hash + Objects.hashCode(this.getJsonrpc());
        return hash;
    }

    public static ResponseMessage create(Object id, String jsonrpc) {
        JSONObject json = new JSONObject();
        json.put("id", id);
        json.put("jsonrpc", jsonrpc);
        return new ResponseMessage(json);
    }
}

