/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.tools.lsp.server.types;

import com.oracle.truffle.tools.utils.json.JSONArray;
import com.oracle.truffle.tools.utils.json.JSONObject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.graalvm.tools.lsp.server.types.JSONBase;
import org.graalvm.tools.lsp.server.types.MessageActionItem;
import org.graalvm.tools.lsp.server.types.MessageType;

public class ShowMessageRequestParams
extends JSONBase {
    ShowMessageRequestParams(JSONObject jsonData) {
        super(jsonData);
    }

    public MessageType getType() {
        return MessageType.get(this.jsonData.getInt("type"));
    }

    public ShowMessageRequestParams setType(MessageType type) {
        this.jsonData.put("type", type.getIntValue());
        return this;
    }

    public String getMessage() {
        return this.jsonData.getString("message");
    }

    public ShowMessageRequestParams setMessage(String message) {
        this.jsonData.put("message", message);
        return this;
    }

    public List<MessageActionItem> getActions() {
        JSONArray json = this.jsonData.optJSONArray("actions");
        if (json == null) {
            return null;
        }
        ArrayList<MessageActionItem> list = new ArrayList<MessageActionItem>(json.length());
        for (int i = 0; i < json.length(); ++i) {
            list.add(new MessageActionItem(json.getJSONObject(i)));
        }
        return Collections.unmodifiableList(list);
    }

    public ShowMessageRequestParams setActions(List<MessageActionItem> actions) {
        if (actions != null) {
            JSONArray json = new JSONArray();
            for (MessageActionItem messageActionItem : actions) {
                json.put(messageActionItem.jsonData);
            }
            this.jsonData.put("actions", json);
        }
        return this;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ShowMessageRequestParams other = (ShowMessageRequestParams)obj;
        if (this.getType() != other.getType()) {
            return false;
        }
        if (!Objects.equals(this.getMessage(), other.getMessage())) {
            return false;
        }
        return Objects.equals(this.getActions(), other.getActions());
    }

    public int hashCode() {
        int hash = 5;
        hash = 89 * hash + Objects.hashCode((Object)this.getType());
        hash = 89 * hash + Objects.hashCode(this.getMessage());
        if (this.getActions() != null) {
            hash = 89 * hash + Objects.hashCode(this.getActions());
        }
        return hash;
    }

    public static ShowMessageRequestParams create(MessageType type, String message) {
        JSONObject json = new JSONObject();
        json.put("type", type.getIntValue());
        json.put("message", message);
        return new ShowMessageRequestParams(json);
    }
}

