/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.tools.lsp.server.types;

import com.oracle.truffle.tools.utils.json.JSONArray;
import com.oracle.truffle.tools.utils.json.JSONObject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.graalvm.tools.lsp.server.types.DocumentFilter;
import org.graalvm.tools.lsp.server.types.JSONBase;

public class TextDocumentRegistrationOptions
extends JSONBase {
    TextDocumentRegistrationOptions(JSONObject jsonData) {
        super(jsonData);
    }

    public List<Object> getDocumentSelector() {
        JSONArray json = this.jsonData.optJSONArray("documentSelector");
        if (json == null) {
            return null;
        }
        ArrayList<Object> list = new ArrayList<Object>(json.length());
        for (int i = 0; i < json.length(); ++i) {
            Object obj = json.get(i);
            if (obj instanceof JSONObject) {
                list.add(new DocumentFilter((JSONObject)obj));
            }
            list.add(obj);
        }
        return Collections.unmodifiableList(list);
    }

    public TextDocumentRegistrationOptions setDocumentSelector(List<Object> documentSelector) {
        if (documentSelector != null) {
            JSONArray json = new JSONArray();
            for (Object object : documentSelector) {
                if (object instanceof DocumentFilter) {
                    json.put(((DocumentFilter)object).jsonData);
                    continue;
                }
                json.put(object);
            }
            this.jsonData.put("documentSelector", json);
        } else {
            this.jsonData.put("documentSelector", JSONObject.NULL);
        }
        return this;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TextDocumentRegistrationOptions other = (TextDocumentRegistrationOptions)obj;
        return Objects.equals(this.getDocumentSelector(), other.getDocumentSelector());
    }

    public int hashCode() {
        int hash = 7;
        if (this.getDocumentSelector() != null) {
            hash = 29 * hash + Objects.hashCode(this.getDocumentSelector());
        }
        return hash;
    }

    public static TextDocumentRegistrationOptions create(List<Object> documentSelector) {
        JSONObject json = new JSONObject();
        if (documentSelector != null) {
            JSONArray documentSelectorJsonArr = new JSONArray();
            for (Object object : documentSelector) {
                if (object instanceof DocumentFilter) {
                    documentSelectorJsonArr.put(((DocumentFilter)object).jsonData);
                    continue;
                }
                documentSelectorJsonArr.put(object);
            }
            json.put("documentSelector", documentSelectorJsonArr);
        } else {
            json.put("documentSelector", JSONObject.NULL);
        }
        return new TextDocumentRegistrationOptions(json);
    }
}

