/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.tools.lsp.server.types;

import com.oracle.truffle.tools.utils.json.JSONArray;
import com.oracle.truffle.tools.utils.json.JSONObject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.graalvm.tools.lsp.server.types.JSONBase;
import org.graalvm.tools.lsp.server.types.TextEdit;

public class WorkspaceEdit
extends JSONBase {
    WorkspaceEdit(JSONObject jsonData) {
        super(jsonData);
    }

    public Map<String, List<TextEdit>> getChanges() {
        JSONObject json = this.jsonData.optJSONObject("changes");
        if (json == null) {
            return null;
        }
        HashMap<String, List<TextEdit>> map = new HashMap<String, List<TextEdit>>(json.length());
        for (String key : json.keySet()) {
            JSONArray jsonArr = json.getJSONArray(key);
            ArrayList<TextEdit> list = new ArrayList<TextEdit>(jsonArr.length());
            for (int i = 0; i < json.length(); ++i) {
                list.add(new TextEdit(jsonArr.getJSONObject(i)));
            }
            map.put(key, Collections.unmodifiableList(list));
        }
        return map;
    }

    public WorkspaceEdit setChanges(Map<String, List<TextEdit>> changes) {
        if (changes != null) {
            JSONObject json = new JSONObject();
            for (Map.Entry<String, List<TextEdit>> entry : changes.entrySet()) {
                JSONArray jsonArr = new JSONArray();
                for (TextEdit textEdit : entry.getValue()) {
                    jsonArr.put(textEdit.jsonData);
                }
                json.put(entry.getKey(), jsonArr);
            }
            this.jsonData.put("changes", json);
        }
        return this;
    }

    public List<Object> getDocumentChanges() {
        JSONArray json = this.jsonData.optJSONArray("documentChanges");
        if (json == null) {
            return null;
        }
        ArrayList<Object> list = new ArrayList<Object>(json.length());
        for (int i = 0; i < json.length(); ++i) {
            list.add(json.get(i));
        }
        return Collections.unmodifiableList(list);
    }

    public WorkspaceEdit setDocumentChanges(List<Object> documentChanges) {
        if (documentChanges != null) {
            JSONArray json = new JSONArray();
            for (Object object : documentChanges) {
                json.put(object);
            }
            this.jsonData.put("documentChanges", json);
        }
        return this;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        WorkspaceEdit other = (WorkspaceEdit)obj;
        if (!Objects.equals(this.getChanges(), other.getChanges())) {
            return false;
        }
        return Objects.equals(this.getDocumentChanges(), other.getDocumentChanges());
    }

    public int hashCode() {
        int hash = 7;
        if (this.getChanges() != null) {
            hash = 97 * hash + Objects.hashCode(this.getChanges());
        }
        if (this.getDocumentChanges() != null) {
            hash = 97 * hash + Objects.hashCode(this.getDocumentChanges());
        }
        return hash;
    }

    public static WorkspaceEdit create() {
        JSONObject json = new JSONObject();
        return new WorkspaceEdit(json);
    }
}

