/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.tools.lsp.server.types;

import com.oracle.truffle.tools.utils.json.JSONArray;
import com.oracle.truffle.tools.utils.json.JSONObject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.graalvm.tools.lsp.server.types.JSONBase;
import org.graalvm.tools.lsp.server.types.WorkspaceFolder;

public class WorkspaceFoldersChangeEvent
extends JSONBase {
    WorkspaceFoldersChangeEvent(JSONObject jsonData) {
        super(jsonData);
    }

    public List<WorkspaceFolder> getAdded() {
        JSONArray json = this.jsonData.getJSONArray("added");
        ArrayList<WorkspaceFolder> list = new ArrayList<WorkspaceFolder>(json.length());
        for (int i = 0; i < json.length(); ++i) {
            list.add(new WorkspaceFolder(json.getJSONObject(i)));
        }
        return Collections.unmodifiableList(list);
    }

    public WorkspaceFoldersChangeEvent setAdded(List<WorkspaceFolder> added) {
        JSONArray json = new JSONArray();
        for (WorkspaceFolder workspaceFolder : added) {
            json.put(workspaceFolder.jsonData);
        }
        this.jsonData.put("added", json);
        return this;
    }

    public List<WorkspaceFolder> getRemoved() {
        JSONArray json = this.jsonData.getJSONArray("removed");
        ArrayList<WorkspaceFolder> list = new ArrayList<WorkspaceFolder>(json.length());
        for (int i = 0; i < json.length(); ++i) {
            list.add(new WorkspaceFolder(json.getJSONObject(i)));
        }
        return Collections.unmodifiableList(list);
    }

    public WorkspaceFoldersChangeEvent setRemoved(List<WorkspaceFolder> removed) {
        JSONArray json = new JSONArray();
        for (WorkspaceFolder workspaceFolder : removed) {
            json.put(workspaceFolder.jsonData);
        }
        this.jsonData.put("removed", json);
        return this;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        WorkspaceFoldersChangeEvent other = (WorkspaceFoldersChangeEvent)obj;
        if (!Objects.equals(this.getAdded(), other.getAdded())) {
            return false;
        }
        return Objects.equals(this.getRemoved(), other.getRemoved());
    }

    public int hashCode() {
        int hash = 7;
        hash = 89 * hash + Objects.hashCode(this.getAdded());
        hash = 89 * hash + Objects.hashCode(this.getRemoved());
        return hash;
    }

    public static WorkspaceFoldersChangeEvent create(List<WorkspaceFolder> added, List<WorkspaceFolder> removed) {
        JSONObject json = new JSONObject();
        JSONArray addedJsonArr = new JSONArray();
        for (WorkspaceFolder workspaceFolder : added) {
            addedJsonArr.put(workspaceFolder.jsonData);
        }
        json.put("added", addedJsonArr);
        JSONArray removedJsonArr = new JSONArray();
        for (WorkspaceFolder workspaceFolder : removed) {
            removedJsonArr.put(workspaceFolder.jsonData);
        }
        json.put("removed", removedJsonArr);
        return new WorkspaceFoldersChangeEvent(json);
    }
}

