/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm;

import com.oracle.truffle.llvm.parser.LLVMParserResult;
import com.oracle.truffle.llvm.runtime.ExternalLibrary;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

final class ParseContext {
    private final List<LLVMParserResult> parserResults;
    private final ArrayDeque<ExternalLibrary> dependencyQueue;

    static ParseContext create() {
        ArrayDeque<ExternalLibrary> dependencyQueue = new ArrayDeque<ExternalLibrary>();
        ArrayList<LLVMParserResult> parserResults = new ArrayList<LLVMParserResult>();
        return new ParseContext(parserResults, dependencyQueue);
    }

    private ParseContext(List<LLVMParserResult> parserResults, ArrayDeque<ExternalLibrary> dependencyQueue) {
        this.parserResults = parserResults;
        this.dependencyQueue = dependencyQueue;
    }

    public List<LLVMParserResult> getParserResults() {
        return Collections.unmodifiableList(this.parserResults);
    }

    public int dependencyQueueSize() {
        return this.dependencyQueue.size();
    }

    public ExternalLibrary dependencyQueueRemoveFirst() {
        return this.dependencyQueue.removeFirst();
    }

    public boolean dependencyQueueIsEmpty() {
        return this.dependencyQueue.isEmpty();
    }

    public boolean parserResultsIsEmpty() {
        return this.parserResults.isEmpty();
    }

    public void dependencyQueueAddLast(ExternalLibrary dependency) {
        this.dependencyQueue.addLast(dependency);
    }

    public void parserResultsAdd(LLVMParserResult parserResult) {
        this.parserResults.add(parserResult);
    }

    public void parserResultsAddAll(List<LLVMParserResult> otherResults) {
        this.parserResults.addAll(otherResults);
    }
}

