/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.asm.amd64;

import com.oracle.truffle.api.frame.FrameDescriptor;
import com.oracle.truffle.api.frame.FrameSlot;
import com.oracle.truffle.api.frame.FrameSlotKind;
import com.oracle.truffle.llvm.asm.amd64.Argument;
import com.oracle.truffle.llvm.asm.amd64.AsmArgumentOperand;
import com.oracle.truffle.llvm.asm.amd64.AsmImmediateOperand;
import com.oracle.truffle.llvm.asm.amd64.AsmMemoryOperand;
import com.oracle.truffle.llvm.asm.amd64.AsmOperand;
import com.oracle.truffle.llvm.asm.amd64.AsmParseException;
import com.oracle.truffle.llvm.asm.amd64.AsmRegisterOperand;
import com.oracle.truffle.llvm.runtime.CommonNodeFactory;
import com.oracle.truffle.llvm.runtime.LLVMLanguage;
import com.oracle.truffle.llvm.runtime.LLVMUnsupportedException;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMExpressionNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMStatementNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMStoreNode;
import com.oracle.truffle.llvm.runtime.nodes.asm.LLVMAMD64AdcNodeFactory;
import com.oracle.truffle.llvm.runtime.nodes.asm.LLVMAMD64AddNodeFactory;
import com.oracle.truffle.llvm.runtime.nodes.asm.LLVMAMD64AndNodeFactory;
import com.oracle.truffle.llvm.runtime.nodes.asm.LLVMAMD64BsfNodeFactory;
import com.oracle.truffle.llvm.runtime.nodes.asm.LLVMAMD64BsrNodeFactory;
import com.oracle.truffle.llvm.runtime.nodes.asm.LLVMAMD64BswapNodeFactory;
import com.oracle.truffle.llvm.runtime.nodes.asm.LLVMAMD64CmpNodeFactory;
import com.oracle.truffle.llvm.runtime.nodes.asm.LLVMAMD64CmpXchgNode;
import com.oracle.truffle.llvm.runtime.nodes.asm.LLVMAMD64CmpXchgNodeFactory;
import com.oracle.truffle.llvm.runtime.nodes.asm.LLVMAMD64CpuidNodeGen;
import com.oracle.truffle.llvm.runtime.nodes.asm.LLVMAMD64DecNodeFactory;
import com.oracle.truffle.llvm.runtime.nodes.asm.LLVMAMD64DivNodeFactory;
import com.oracle.truffle.llvm.runtime.nodes.asm.LLVMAMD64GetFlagNodesFactory;
import com.oracle.truffle.llvm.runtime.nodes.asm.LLVMAMD64IdivNodeFactory;
import com.oracle.truffle.llvm.runtime.nodes.asm.LLVMAMD64ImmNode;
import com.oracle.truffle.llvm.runtime.nodes.asm.LLVMAMD64ImmNodeFactory;
import com.oracle.truffle.llvm.runtime.nodes.asm.LLVMAMD64ImulNodeFactory;
import com.oracle.truffle.llvm.runtime.nodes.asm.LLVMAMD64IncNodeFactory;
import com.oracle.truffle.llvm.runtime.nodes.asm.LLVMAMD64LoadFlags;
import com.oracle.truffle.llvm.runtime.nodes.asm.LLVMAMD64LoadFlagsFactory;
import com.oracle.truffle.llvm.runtime.nodes.asm.LLVMAMD64MulNodeFactory;
import com.oracle.truffle.llvm.runtime.nodes.asm.LLVMAMD64NegNodeFactory;
import com.oracle.truffle.llvm.runtime.nodes.asm.LLVMAMD64NotNodeFactory;
import com.oracle.truffle.llvm.runtime.nodes.asm.LLVMAMD64OrNodeFactory;
import com.oracle.truffle.llvm.runtime.nodes.asm.LLVMAMD64PopNode;
import com.oracle.truffle.llvm.runtime.nodes.asm.LLVMAMD64PopNodeFactory;
import com.oracle.truffle.llvm.runtime.nodes.asm.LLVMAMD64PushNodeFactory;
import com.oracle.truffle.llvm.runtime.nodes.asm.LLVMAMD64RdRandNodeFactory;
import com.oracle.truffle.llvm.runtime.nodes.asm.LLVMAMD64RdSeedNodeFactory;
import com.oracle.truffle.llvm.runtime.nodes.asm.LLVMAMD64RdtscNodeGen;
import com.oracle.truffle.llvm.runtime.nodes.asm.LLVMAMD64RepNodeGen;
import com.oracle.truffle.llvm.runtime.nodes.asm.LLVMAMD64RolNodeFactory;
import com.oracle.truffle.llvm.runtime.nodes.asm.LLVMAMD64RorNodeFactory;
import com.oracle.truffle.llvm.runtime.nodes.asm.LLVMAMD64SalNodeFactory;
import com.oracle.truffle.llvm.runtime.nodes.asm.LLVMAMD64SarNodeFactory;
import com.oracle.truffle.llvm.runtime.nodes.asm.LLVMAMD64SetFlagNodeGen;
import com.oracle.truffle.llvm.runtime.nodes.asm.LLVMAMD64ShlNodeFactory;
import com.oracle.truffle.llvm.runtime.nodes.asm.LLVMAMD64ShrNodeFactory;
import com.oracle.truffle.llvm.runtime.nodes.asm.LLVMAMD64StoreFlagsFactory;
import com.oracle.truffle.llvm.runtime.nodes.asm.LLVMAMD64StosNodeFactory;
import com.oracle.truffle.llvm.runtime.nodes.asm.LLVMAMD64SubNodeFactory;
import com.oracle.truffle.llvm.runtime.nodes.asm.LLVMAMD64Ud2NodeGen;
import com.oracle.truffle.llvm.runtime.nodes.asm.LLVMAMD64XaddNodeFactory;
import com.oracle.truffle.llvm.runtime.nodes.asm.LLVMAMD64XchgNode;
import com.oracle.truffle.llvm.runtime.nodes.asm.LLVMAMD64XchgNodeFactory;
import com.oracle.truffle.llvm.runtime.nodes.asm.LLVMAMD64XorNodeFactory;
import com.oracle.truffle.llvm.runtime.nodes.asm.support.LLVMAMD64AddressComputationNode;
import com.oracle.truffle.llvm.runtime.nodes.asm.support.LLVMAMD64AddressComputationNodeFactory;
import com.oracle.truffle.llvm.runtime.nodes.asm.support.LLVMAMD64GetTlsNode;
import com.oracle.truffle.llvm.runtime.nodes.asm.support.LLVMAMD64GetTlsNodeGen;
import com.oracle.truffle.llvm.runtime.nodes.asm.support.LLVMAMD64ReadAddressNodeGen;
import com.oracle.truffle.llvm.runtime.nodes.asm.support.LLVMAMD64ReadRegisterNode;
import com.oracle.truffle.llvm.runtime.nodes.asm.support.LLVMAMD64ReadRegisterNodeGen;
import com.oracle.truffle.llvm.runtime.nodes.asm.support.LLVMAMD64Target;
import com.oracle.truffle.llvm.runtime.nodes.asm.support.LLVMAMD64ToI8NodeFactory;
import com.oracle.truffle.llvm.runtime.nodes.asm.support.LLVMAMD64ToRegisterNodeFactory;
import com.oracle.truffle.llvm.runtime.nodes.asm.support.LLVMAMD64UpdateFlagsNode;
import com.oracle.truffle.llvm.runtime.nodes.asm.support.LLVMAMD64WriteAddressRegisterNodeGen;
import com.oracle.truffle.llvm.runtime.nodes.asm.support.LLVMAMD64WriteBooleanNode;
import com.oracle.truffle.llvm.runtime.nodes.asm.support.LLVMAMD64WriteTupelNode;
import com.oracle.truffle.llvm.runtime.nodes.asm.support.LLVMAMD64WriteTupelNodeGen;
import com.oracle.truffle.llvm.runtime.nodes.asm.support.LLVMAMD64WriteValueNode;
import com.oracle.truffle.llvm.runtime.nodes.asm.support.LLVMAMD64WriteValueNodeGen;
import com.oracle.truffle.llvm.runtime.nodes.asm.syscall.LLVMSyscallNode;
import com.oracle.truffle.llvm.runtime.nodes.asm.syscall.LLVMSyscallNodeGen;
import com.oracle.truffle.llvm.runtime.nodes.cast.LLVMToAddressNode;
import com.oracle.truffle.llvm.runtime.nodes.cast.LLVMToAddressNodeGen;
import com.oracle.truffle.llvm.runtime.nodes.func.LLVMArgNode;
import com.oracle.truffle.llvm.runtime.nodes.func.LLVMArgNodeGen;
import com.oracle.truffle.llvm.runtime.nodes.func.LLVMInlineAssemblyRootNode;
import com.oracle.truffle.llvm.runtime.nodes.intrinsics.llvm.debug.LLVMDebugTrapNodeGen;
import com.oracle.truffle.llvm.runtime.nodes.intrinsics.llvm.x86.LLVMX86_ConversionNode;
import com.oracle.truffle.llvm.runtime.nodes.intrinsics.llvm.x86.LLVMX86_ConversionNodeFactory;
import com.oracle.truffle.llvm.runtime.nodes.memory.LLVMFenceNodeGen;
import com.oracle.truffle.llvm.runtime.nodes.memory.load.LLVMDirectLoadNodeFactory;
import com.oracle.truffle.llvm.runtime.nodes.memory.load.LLVMI16LoadNodeGen;
import com.oracle.truffle.llvm.runtime.nodes.memory.load.LLVMI32LoadNodeGen;
import com.oracle.truffle.llvm.runtime.nodes.memory.load.LLVMI64LoadNodeGen;
import com.oracle.truffle.llvm.runtime.nodes.memory.load.LLVMI8LoadNodeGen;
import com.oracle.truffle.llvm.runtime.nodes.memory.store.LLVMI16StoreNodeGen;
import com.oracle.truffle.llvm.runtime.nodes.memory.store.LLVMI32StoreNodeGen;
import com.oracle.truffle.llvm.runtime.nodes.memory.store.LLVMI64StoreNodeGen;
import com.oracle.truffle.llvm.runtime.nodes.memory.store.LLVMI8StoreNodeGen;
import com.oracle.truffle.llvm.runtime.nodes.memory.store.LLVMPointerStoreNodeGen;
import com.oracle.truffle.llvm.runtime.nodes.others.LLVMUnsupportedInstructionNode;
import com.oracle.truffle.llvm.runtime.nodes.vars.LLVMReadNode;
import com.oracle.truffle.llvm.runtime.nodes.vars.LLVMReadNodeFactory;
import com.oracle.truffle.llvm.runtime.nodes.vars.LLVMWriteNode;
import com.oracle.truffle.llvm.runtime.nodes.vars.LLVMWriteNodeFactory;
import com.oracle.truffle.llvm.runtime.nodes.vars.StructLiteralNodeGen;
import com.oracle.truffle.llvm.runtime.types.PointerType;
import com.oracle.truffle.llvm.runtime.types.PrimitiveType;
import com.oracle.truffle.llvm.runtime.types.StructureType;
import com.oracle.truffle.llvm.runtime.types.Type;
import com.oracle.truffle.llvm.runtime.types.VectorType;
import com.oracle.truffle.llvm.runtime.types.VoidType;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;

class AsmFactory {
    private static final int REG_START_INDEX = 1;
    private static final String TEMP_REGISTER_PREFIX = "__$$tmp_r_";
    private static final String CONSTRAINT_REG = "r";
    private static final String CONSTRAINT_REG_L = "q";
    private static final String CONSTRAINT_REG_XMM = "x";
    private final FrameDescriptor frameDescriptor;
    private final List<LLVMStatementNode> statements;
    private final List<LLVMStatementNode> arguments;
    private final List<String> registers;
    private LLVMExpressionNode result;
    private List<Argument> argInfo;
    private final String asmFlags;
    private final Type.TypeArrayBuilder argTypes;
    private final Type retType;
    private final Type[] retTypes;
    private final long[] retOffsets;
    private String currentPrefix;
    private final LLVMLanguage language;

    AsmFactory(LLVMLanguage language, Type.TypeArrayBuilder argTypes, String asmFlags, Type retType, Type[] retTypes, long[] retOffsets) {
        this.language = language;
        this.argTypes = argTypes;
        this.asmFlags = asmFlags;
        this.frameDescriptor = new FrameDescriptor();
        this.statements = new ArrayList<LLVMStatementNode>();
        this.arguments = new ArrayList<LLVMStatementNode>();
        this.registers = new ArrayList<String>();
        this.retType = retType;
        this.retTypes = retTypes;
        this.retOffsets = retOffsets;
        this.parseArguments();
    }

    private static AsmParseException invalidOperandType(Type type) {
        return new AsmParseException("invalid operand type: " + type);
    }

    private static AsmParseException unsupportedOperandType(Type type) {
        return new AsmParseException("unsupported operand type: " + type);
    }

    private void parseArguments() {
        this.argInfo = new ArrayList<Argument>();
        String[] tokens = this.asmFlags.substring(1, this.asmFlags.length() - 1).split(",");
        int index = 1 + (this.retType instanceof StructureType ? 1 : 0);
        int outIndex = 0;
        for (String token : tokens) {
            Type type;
            if (token.isEmpty()) continue;
            boolean isTilde = false;
            boolean isInput = true;
            boolean isOutput = false;
            boolean isMemory = false;
            boolean isAnonymous = false;
            String source = null;
            String registerName = null;
            block8: for (int i = 0; i < token.length() && source == null; ++i) {
                switch (token.charAt(i)) {
                    case '~': {
                        isTilde = true;
                        isInput = false;
                        continue block8;
                    }
                    case '+': {
                        isInput = true;
                        isOutput = true;
                        continue block8;
                    }
                    case '=': {
                        isInput = false;
                        isOutput = true;
                        continue block8;
                    }
                    case '*': {
                        isMemory = true;
                        continue block8;
                    }
                    case '&': {
                        continue block8;
                    }
                    default: {
                        source = token.substring(i);
                    }
                }
            }
            if (isTilde) continue;
            if (source == null) {
                throw new AsmParseException("invalid token: " + token);
            }
            int start = source.indexOf(123);
            int end = source.lastIndexOf(125);
            if (start != -1 && end != -1) {
                registerName = source.substring(start + 1, end);
            } else if (CONSTRAINT_REG.equals(source) || CONSTRAINT_REG_L.equals(source) || CONSTRAINT_REG_XMM.equals(source)) {
                registerName = TEMP_REGISTER_PREFIX + this.argInfo.size();
                isAnonymous = true;
            } else if (source.length() == 1 && Character.isDigit(source.charAt(0))) {
                int id = Character.digit(source.charAt(0), 10);
                Argument arg = this.argInfo.get(id);
                assert (isInput && !isOutput);
                isInput = true;
                isOutput = false;
                if (arg.isRegister()) {
                    registerName = arg.getRegister();
                }
                isAnonymous = arg.isAnonymous();
            }
            assert (registerName == null || AsmRegisterOperand.isRegister(registerName) || registerName.startsWith(TEMP_REGISTER_PREFIX));
            int idIn = index;
            int idOut = outIndex;
            if (isInput) {
                type = this.argTypes.get(index++);
            } else if (this.retType instanceof StructureType) {
                if (isMemory) {
                    type = this.argTypes.get(index);
                    idOut = index++;
                } else {
                    type = this.retTypes[outIndex++];
                }
            } else if (isOutput) {
                type = this.retType;
                if (isMemory) {
                    if (type instanceof VoidType) {
                        type = this.argTypes.get(index);
                    }
                    idOut = index++;
                }
            } else {
                throw new AssertionError((Object)"neither input nor output");
            }
            if (isAnonymous && type instanceof PointerType) {
                assert (registerName != null);
                this.addFrameSlot(registerName, type);
            }
            this.argInfo.add(new Argument(isInput, isOutput, isMemory, isAnonymous, type, this.argInfo.size(), idIn, idOut, source, registerName));
        }
        assert (index == this.argTypes.size());
        assert (!(this.retType instanceof StructureType) ? outIndex == 0 : outIndex == this.retOffsets.length);
    }

    LLVMInlineAssemblyRootNode finishInline() {
        this.getArguments();
        return new LLVMInlineAssemblyRootNode(this.language, this.frameDescriptor, this.statements, this.arguments, this.result);
    }

    void setPrefix(String prefix) {
        this.currentPrefix = prefix;
    }

    void createInt(AsmImmediateOperand nr) {
        long id = nr.getValue();
        if (id == 3L) {
            this.statements.add(LLVMDebugTrapNodeGen.create());
        } else {
            this.statements.add(LLVMUnsupportedInstructionNode.create(LLVMUnsupportedException.UnsupportedReason.INLINE_ASSEMBLER, "interrupt " + nr));
        }
    }

    private void createRep(LLVMStatementNode body) {
        if ("rep".equals(this.currentPrefix)) {
            LLVMExpressionNode rcx = this.getOperandLoad(PrimitiveType.I64, new AsmRegisterOperand("rcx"));
            LLVMAMD64WriteValueNode writeRCX = this.getStore(PrimitiveType.I64, new AsmRegisterOperand("rcx"));
            this.statements.add(LLVMAMD64RepNodeGen.create(writeRCX, rcx, body));
        } else {
            this.statements.add(body);
        }
    }

    void createOperation(String operation) {
        switch (operation) {
            case "cld": {
                this.statements.add(LLVMAMD64SetFlagNodeGen.create(this.getFlagWrite(10L), false));
                break;
            }
            case "clc": 
            case "cli": 
            case "cmc": {
                this.statements.add(LLVMUnsupportedInstructionNode.create(LLVMUnsupportedException.UnsupportedReason.INLINE_ASSEMBLER, operation));
                break;
            }
            case "lahf": {
                LLVMAMD64LoadFlags.LLVMAMD64LahfNode lahf = LLVMAMD64LoadFlagsFactory.LLVMAMD64LahfNodeGen.create(this.getFlag(0L), this.getFlag(2L), this.getFlag(4L), this.getFlag(6L), this.getFlag(7L));
                this.statements.add(this.getOperandStore(PrimitiveType.I8, new AsmRegisterOperand("ah"), lahf));
                break;
            }
            case "sahf": {
                LLVMExpressionNode ah = this.getOperandLoad(PrimitiveType.I8, new AsmRegisterOperand("ah"));
                this.statements.add(LLVMAMD64StoreFlagsFactory.LLVMAMD64SahfNodeGen.create(this.getFlagWrite(0L), this.getFlagWrite(2L), this.getFlagWrite(4L), this.getFlagWrite(6L), this.getFlagWrite(7L), ah));
                break;
            }
            case "popf": 
            case "popfw": {
                LLVMAMD64PopNode.LLVMAMD64PopwNode read = LLVMAMD64PopNodeFactory.LLVMAMD64PopwNodeGen.create();
                this.statements.add(LLVMAMD64StoreFlagsFactory.LLVMAMD64WriteFlagswNodeGen.create(this.getFlagWrite(0L), this.getFlagWrite(2L), this.getFlagWrite(4L), this.getFlagWrite(6L), this.getFlagWrite(7L), this.getFlagWrite(11L), read));
                break;
            }
            case "pushf": 
            case "pushfw": {
                LLVMAMD64LoadFlags.LLVMAMD64ReadFlagswNode flags = LLVMAMD64LoadFlagsFactory.LLVMAMD64ReadFlagswNodeGen.create(this.getFlag(0L), this.getFlag(2L), this.getFlag(4L), this.getFlag(6L), this.getFlag(7L), this.getFlag(11L));
                this.statements.add(LLVMAMD64PushNodeFactory.LLVMAMD64PushwNodeGen.create(flags));
                break;
            }
            case "std": {
                this.statements.add(LLVMAMD64SetFlagNodeGen.create(this.getFlagWrite(10L), true));
                break;
            }
            case "stc": 
            case "sti": {
                this.statements.add(LLVMUnsupportedInstructionNode.create(LLVMUnsupportedException.UnsupportedReason.INLINE_ASSEMBLER, operation));
                break;
            }
            case "nop": 
            case "pause": {
                break;
            }
            case "hlt": {
                break;
            }
            case "mfence": 
            case "lfence": 
            case "sfence": {
                this.statements.add(LLVMFenceNodeGen.create());
                break;
            }
            case "rdtsc": {
                LLVMAMD64WriteValueNode high = this.getRegisterStore("rdx");
                LLVMAMD64WriteValueNode low = this.getRegisterStore("rax");
                LLVMAMD64WriteTupelNode out = LLVMAMD64WriteTupelNodeGen.create(low, high);
                this.statements.add(LLVMAMD64RdtscNodeGen.create(out));
                break;
            }
            case "cpuid": {
                LLVMExpressionNode level = this.getOperandLoad(PrimitiveType.I32, new AsmRegisterOperand("eax"));
                LLVMAMD64WriteValueNode eax = this.getRegisterStore("eax");
                LLVMAMD64WriteValueNode ebx = this.getRegisterStore("ebx");
                LLVMAMD64WriteValueNode ecx = this.getRegisterStore("ecx");
                LLVMAMD64WriteValueNode edx = this.getRegisterStore("edx");
                this.statements.add(LLVMAMD64CpuidNodeGen.create(eax, ebx, ecx, edx, level));
                break;
            }
            case "ud2": {
                this.statements.add(LLVMAMD64Ud2NodeGen.create());
                break;
            }
            case "syscall": {
                LLVMExpressionNode rax = this.getOperandLoad(PrimitiveType.I64, new AsmRegisterOperand("rax"));
                LLVMExpressionNode rdi = this.getOperandLoad(PrimitiveType.I64, new AsmRegisterOperand("rdi"));
                LLVMExpressionNode rsi = this.getOperandLoad(PrimitiveType.I64, new AsmRegisterOperand("rsi"));
                LLVMExpressionNode rdx = this.getOperandLoad(PrimitiveType.I64, new AsmRegisterOperand("rdx"));
                LLVMExpressionNode r10 = this.getOperandLoad(PrimitiveType.I64, new AsmRegisterOperand("r10"));
                LLVMExpressionNode r8 = this.getOperandLoad(PrimitiveType.I64, new AsmRegisterOperand("r8"));
                LLVMExpressionNode r9 = this.getOperandLoad(PrimitiveType.I64, new AsmRegisterOperand("r9"));
                LLVMSyscallNode syscall = LLVMSyscallNodeGen.create(rax, rdi, rsi, rdx, r10, r8, r9);
                this.statements.add(this.getOperandStore(PrimitiveType.I64, new AsmRegisterOperand("rax"), syscall));
                break;
            }
            case "stosb": {
                LLVMExpressionNode al = this.getOperandLoad(PrimitiveType.I8, new AsmRegisterOperand("al"));
                LLVMExpressionNode rdi = this.getOperandLoad(PrimitiveType.I64, new AsmRegisterOperand("rdi"));
                LLVMExpressionNode df = this.getFlag(10L);
                LLVMAMD64WriteValueNode writeRDI = this.getStore(PrimitiveType.I64, new AsmRegisterOperand("rdi"));
                this.createRep(LLVMAMD64StosNodeFactory.LLVMAMD64StosbNodeGen.create(writeRDI, al, rdi, df));
                break;
            }
            case "stosw": {
                LLVMExpressionNode ax = this.getOperandLoad(PrimitiveType.I16, new AsmRegisterOperand("ax"));
                LLVMExpressionNode rdi = this.getOperandLoad(PrimitiveType.I64, new AsmRegisterOperand("rdi"));
                LLVMExpressionNode df = this.getFlag(10L);
                LLVMAMD64WriteValueNode writeRDI = this.getStore(PrimitiveType.I64, new AsmRegisterOperand("rdi"));
                this.createRep(LLVMAMD64StosNodeFactory.LLVMAMD64StoswNodeGen.create(writeRDI, ax, rdi, df));
                break;
            }
            case "stosd": {
                LLVMExpressionNode eax = this.getOperandLoad(PrimitiveType.I32, new AsmRegisterOperand("eax"));
                LLVMExpressionNode rdi = this.getOperandLoad(PrimitiveType.I64, new AsmRegisterOperand("rdi"));
                LLVMExpressionNode df = this.getFlag(10L);
                LLVMAMD64WriteValueNode writeRDI = this.getStore(PrimitiveType.I64, new AsmRegisterOperand("rdi"));
                this.createRep(LLVMAMD64StosNodeFactory.LLVMAMD64StosdNodeGen.create(writeRDI, eax, rdi, df));
                break;
            }
            case "stosq": {
                LLVMExpressionNode rax = this.getOperandLoad(PrimitiveType.I64, new AsmRegisterOperand("rax"));
                LLVMExpressionNode rdi = this.getOperandLoad(PrimitiveType.I64, new AsmRegisterOperand("rdi"));
                LLVMExpressionNode df = this.getFlag(10L);
                LLVMAMD64WriteValueNode writeRDI = this.getStore(PrimitiveType.I64, new AsmRegisterOperand("rdi"));
                this.createRep(LLVMAMD64StosNodeFactory.LLVMAMD64StosqNodeGen.create(writeRDI, rax, rdi, df));
                break;
            }
            default: {
                this.statements.add(LLVMUnsupportedInstructionNode.create(LLVMUnsupportedException.UnsupportedReason.INLINE_ASSEMBLER, operation));
                return;
            }
        }
    }

    void createUnaryOperationImplicitSize(String operation, AsmOperand operand) {
        LLVMExpressionNode out;
        AsmOperand dst = operand;
        assert (operand != null);
        assert (operation.length() > 0);
        Type dstType = this.getType(operand);
        block37 : switch (operation) {
            case "seta": 
            case "setnbe": {
                out = LLVMAMD64GetFlagNodesFactory.LLVMAMD64GetFlagNorNodeGen.create(this.getFlag(0L), this.getFlag(6L));
                dstType = PrimitiveType.I8;
                break;
            }
            case "setae": 
            case "setnb": 
            case "setnc": {
                out = LLVMAMD64GetFlagNodesFactory.LLVMAMD64GetFlagNegNodeGen.create(this.getFlag(0L));
                dstType = PrimitiveType.I8;
                break;
            }
            case "setb": 
            case "setc": 
            case "setnae": {
                out = LLVMAMD64GetFlagNodesFactory.LLVMAMD64GetFlagNodeGen.create(this.getFlag(0L));
                dstType = PrimitiveType.I8;
                break;
            }
            case "sete": 
            case "setz": {
                out = LLVMAMD64GetFlagNodesFactory.LLVMAMD64GetFlagNodeGen.create(this.getFlag(6L));
                dstType = PrimitiveType.I8;
                break;
            }
            case "setg": 
            case "setnle": {
                out = LLVMAMD64GetFlagNodesFactory.LLVMAMD64GetFlagGNodeGen.create(this.getFlag(6L), this.getFlag(7L), this.getFlag(11L));
                dstType = PrimitiveType.I8;
                break;
            }
            case "setge": 
            case "setnl": {
                out = LLVMAMD64GetFlagNodesFactory.LLVMAMD64GetFlagEqualNodeGen.create(this.getFlag(7L), this.getFlag(11L));
                dstType = PrimitiveType.I8;
                break;
            }
            case "setl": 
            case "setnge": {
                out = LLVMAMD64GetFlagNodesFactory.LLVMAMD64GetFlagXorNodeGen.create(this.getFlag(7L), this.getFlag(11L));
                dstType = PrimitiveType.I8;
                break;
            }
            case "setle": 
            case "setng": {
                out = LLVMAMD64GetFlagNodesFactory.LLVMAMD64GetFlagLENodeGen.create(this.getFlag(6L), this.getFlag(7L), this.getFlag(11L));
                dstType = PrimitiveType.I8;
                break;
            }
            case "setbe": 
            case "setna": {
                out = LLVMAMD64GetFlagNodesFactory.LLVMAMD64GetFlagOrNodeGen.create(this.getFlag(0L), this.getFlag(6L));
                dstType = PrimitiveType.I8;
                break;
            }
            case "setne": 
            case "setnz": {
                out = LLVMAMD64GetFlagNodesFactory.LLVMAMD64GetFlagNegNodeGen.create(this.getFlag(6L));
                dstType = PrimitiveType.I8;
                break;
            }
            case "setno": {
                out = LLVMAMD64GetFlagNodesFactory.LLVMAMD64GetFlagNegNodeGen.create(this.getFlag(11L));
                dstType = PrimitiveType.I8;
                break;
            }
            case "setnp": 
            case "setpo": {
                out = LLVMAMD64GetFlagNodesFactory.LLVMAMD64GetFlagNegNodeGen.create(this.getFlag(2L));
                dstType = PrimitiveType.I8;
                break;
            }
            case "setns": {
                out = LLVMAMD64GetFlagNodesFactory.LLVMAMD64GetFlagNegNodeGen.create(this.getFlag(7L));
                dstType = PrimitiveType.I8;
                break;
            }
            case "seto": {
                out = LLVMAMD64GetFlagNodesFactory.LLVMAMD64GetFlagNodeGen.create(this.getFlag(11L));
                dstType = PrimitiveType.I8;
                break;
            }
            case "setp": 
            case "setpe": {
                out = LLVMAMD64GetFlagNodesFactory.LLVMAMD64GetFlagNodeGen.create(this.getFlag(2L));
                dstType = PrimitiveType.I8;
                break;
            }
            case "sets": {
                out = LLVMAMD64GetFlagNodesFactory.LLVMAMD64GetFlagNodeGen.create(this.getFlag(7L));
                dstType = PrimitiveType.I8;
                break;
            }
            case "rdrand": {
                switch (AsmFactory.getPrimitiveType(dstType)) {
                    case I16: {
                        out = LLVMAMD64RdRandNodeFactory.LLVMAMD64RdRandwNodeGen.create(this.getFlagWrite(0L));
                        break block37;
                    }
                    case I32: {
                        out = LLVMAMD64RdRandNodeFactory.LLVMAMD64RdRandlNodeGen.create(this.getFlagWrite(0L));
                        break block37;
                    }
                    case I64: {
                        out = LLVMAMD64RdRandNodeFactory.LLVMAMD64RdRandqNodeGen.create(this.getFlagWrite(0L));
                        break block37;
                    }
                }
                throw AsmFactory.invalidOperandType(dstType);
            }
            case "rdseed": {
                switch (AsmFactory.getPrimitiveType(dstType)) {
                    case I16: {
                        out = LLVMAMD64RdSeedNodeFactory.LLVMAMD64RdSeedwNodeGen.create(this.getFlagWrite(0L));
                        break block37;
                    }
                    case I32: {
                        out = LLVMAMD64RdSeedNodeFactory.LLVMAMD64RdSeedlNodeGen.create(this.getFlagWrite(0L));
                        break block37;
                    }
                    case I64: {
                        out = LLVMAMD64RdSeedNodeFactory.LLVMAMD64RdSeedqNodeGen.create(this.getFlagWrite(0L));
                        break block37;
                    }
                }
                throw AsmFactory.invalidOperandType(dstType);
            }
            case "pop": {
                if (dstType == null) {
                    dstType = PrimitiveType.I64;
                }
                if (dstType instanceof PointerType) {
                    dstType = ((PointerType)dstType).getPointeeType();
                    switch (AsmFactory.getPrimitiveType(dstType)) {
                        case I16: {
                            out = LLVMAMD64PopNodeFactory.LLVMAMD64PopwNodeGen.create();
                            break block37;
                        }
                        case I32: {
                            out = LLVMAMD64PopNodeFactory.LLVMAMD64PoplNodeGen.create();
                            break block37;
                        }
                        case I64: {
                            out = LLVMAMD64PopNodeFactory.LLVMAMD64PopqNodeGen.create();
                            break block37;
                        }
                    }
                    throw AsmFactory.invalidOperandType(dstType);
                }
                switch (AsmFactory.getPrimitiveType(dstType)) {
                    case I16: {
                        out = LLVMAMD64PopNodeFactory.LLVMAMD64PopwNodeGen.create();
                        break block37;
                    }
                    case I32: {
                        out = LLVMAMD64PopNodeFactory.LLVMAMD64PoplNodeGen.create();
                        break block37;
                    }
                    case I64: {
                        out = LLVMAMD64PopNodeFactory.LLVMAMD64PopqNodeGen.create();
                        break block37;
                    }
                }
                throw AsmFactory.invalidOperandType(dstType);
            }
            case "push": {
                if (dstType == null) {
                    dstType = PrimitiveType.I64;
                }
                if (dstType instanceof PointerType) {
                    dstType = ((PointerType)dstType).getPointeeType();
                    LLVMExpressionNode src = this.getOperandLoad(dstType, operand);
                    switch (AsmFactory.getPrimitiveType(dstType)) {
                        case I16: {
                            this.statements.add(LLVMAMD64PushNodeFactory.LLVMAMD64PushwNodeGen.create(src));
                            return;
                        }
                        case I32: {
                            this.statements.add(LLVMAMD64PushNodeFactory.LLVMAMD64PushlNodeGen.create(src));
                            return;
                        }
                        case I64: {
                            this.statements.add(LLVMAMD64PushNodeFactory.LLVMAMD64PushqNodeGen.create(src));
                            return;
                        }
                    }
                    throw AsmFactory.invalidOperandType(dstType);
                }
                LLVMExpressionNode src = this.getOperandLoad(dstType, operand);
                switch (AsmFactory.getPrimitiveType(dstType)) {
                    case I16: {
                        this.statements.add(LLVMAMD64PushNodeFactory.LLVMAMD64PushwNodeGen.create(src));
                        return;
                    }
                    case I32: {
                        this.statements.add(LLVMAMD64PushNodeFactory.LLVMAMD64PushlNodeGen.create(src));
                        return;
                    }
                    case I64: {
                        this.statements.add(LLVMAMD64PushNodeFactory.LLVMAMD64PushqNodeGen.create(src));
                        return;
                    }
                }
                throw AsmFactory.invalidOperandType(dstType);
            }
            case "bswap": {
                LLVMExpressionNode src = this.getOperandLoad(dstType, operand);
                switch (AsmFactory.getPrimitiveType(dstType)) {
                    case I32: {
                        out = LLVMAMD64BswapNodeFactory.LLVMAMD64BswaplNodeGen.create(src);
                        break block37;
                    }
                    case I64: {
                        out = LLVMAMD64BswapNodeFactory.LLVMAMD64BswapqNodeGen.create(src);
                        break block37;
                    }
                }
                throw AsmFactory.invalidOperandType(dstType);
            }
            default: {
                this.statements.add(LLVMUnsupportedInstructionNode.create(LLVMUnsupportedException.UnsupportedReason.INLINE_ASSEMBLER, operation));
                return;
            }
        }
        if (dstType == null) {
            throw new IllegalArgumentException("unknown operand width");
        }
        this.statements.add(this.getOperandStore(dstType, dst, out));
    }

    void createUnaryOperation(String operation, AsmOperand operand) {
        LLVMExpressionNode out;
        AsmOperand dst = operand;
        assert (operation.length() > 0);
        char suffix = operation.charAt(operation.length() - 1);
        PrimitiveType dstType = AsmFactory.getPrimitiveTypeFromSuffix(suffix);
        LLVMExpressionNode src = this.getOperandLoad(dstType, operand);
        switch (operation) {
            case "incb": {
                out = LLVMAMD64IncNodeFactory.LLVMAMD64IncbNodeGen.create(this.getUpdatePZSOFlagsNode(), src);
                break;
            }
            case "incw": {
                out = LLVMAMD64IncNodeFactory.LLVMAMD64IncwNodeGen.create(this.getUpdatePZSOFlagsNode(), src);
                break;
            }
            case "incl": {
                out = LLVMAMD64IncNodeFactory.LLVMAMD64InclNodeGen.create(this.getUpdatePZSOFlagsNode(), src);
                break;
            }
            case "incq": {
                out = LLVMAMD64IncNodeFactory.LLVMAMD64IncqNodeGen.create(this.getUpdatePZSOFlagsNode(), src);
                break;
            }
            case "decb": {
                out = LLVMAMD64DecNodeFactory.LLVMAMD64DecbNodeGen.create(this.getUpdatePZSOFlagsNode(), src);
                break;
            }
            case "decw": {
                out = LLVMAMD64DecNodeFactory.LLVMAMD64DecwNodeGen.create(this.getUpdatePZSOFlagsNode(), src);
                break;
            }
            case "decl": {
                out = LLVMAMD64DecNodeFactory.LLVMAMD64DeclNodeGen.create(this.getUpdatePZSOFlagsNode(), src);
                break;
            }
            case "decq": {
                out = LLVMAMD64DecNodeFactory.LLVMAMD64DecqNodeGen.create(this.getUpdatePZSOFlagsNode(), src);
                break;
            }
            case "negb": {
                out = LLVMAMD64NegNodeFactory.LLVMAMD64NegbNodeGen.create(this.getUpdateCPZSOFlagsNode(), src);
                break;
            }
            case "negw": {
                out = LLVMAMD64NegNodeFactory.LLVMAMD64NegwNodeGen.create(this.getUpdateCPZSOFlagsNode(), src);
                break;
            }
            case "negl": {
                out = LLVMAMD64NegNodeFactory.LLVMAMD64NeglNodeGen.create(this.getUpdateCPZSOFlagsNode(), src);
                break;
            }
            case "negq": {
                out = LLVMAMD64NegNodeFactory.LLVMAMD64NegqNodeGen.create(this.getUpdateCPZSOFlagsNode(), src);
                break;
            }
            case "notb": {
                out = LLVMAMD64NotNodeFactory.LLVMAMD64NotbNodeGen.create(src);
                break;
            }
            case "notw": {
                out = LLVMAMD64NotNodeFactory.LLVMAMD64NotwNodeGen.create(src);
                break;
            }
            case "notl": {
                out = LLVMAMD64NotNodeFactory.LLVMAMD64NotlNodeGen.create(src);
                break;
            }
            case "notq": {
                out = LLVMAMD64NotNodeFactory.LLVMAMD64NotqNodeGen.create(src);
                break;
            }
            case "idivb": {
                out = LLVMAMD64IdivNodeFactory.LLVMAMD64IdivbNodeGen.create(this.getOperandLoad(PrimitiveType.I16, new AsmRegisterOperand("ax")), src);
                dst = new AsmRegisterOperand("ax");
                dstType = PrimitiveType.I16;
                break;
            }
            case "idivw": {
                LLVMAMD64WriteTupelNode res = LLVMAMD64WriteTupelNodeGen.create(this.getRegisterStore("ax"), this.getRegisterStore("dx"));
                LLVMExpressionNode high = this.getOperandLoad(PrimitiveType.I16, new AsmRegisterOperand("dx"));
                this.statements.add(LLVMAMD64IdivNodeFactory.LLVMAMD64IdivwNodeGen.create(res, high, this.getOperandLoad(PrimitiveType.I16, new AsmRegisterOperand("ax")), src));
                return;
            }
            case "idivl": {
                LLVMAMD64WriteTupelNode res = LLVMAMD64WriteTupelNodeGen.create(this.getRegisterStore("eax"), this.getRegisterStore("edx"));
                LLVMExpressionNode high = this.getOperandLoad(PrimitiveType.I32, new AsmRegisterOperand("edx"));
                this.statements.add(LLVMAMD64IdivNodeFactory.LLVMAMD64IdivlNodeGen.create(res, high, this.getOperandLoad(PrimitiveType.I32, new AsmRegisterOperand("eax")), src));
                return;
            }
            case "idivq": {
                LLVMAMD64WriteTupelNode res = LLVMAMD64WriteTupelNodeGen.create(this.getRegisterStore("rax"), this.getRegisterStore("rdx"));
                LLVMExpressionNode high = this.getOperandLoad(PrimitiveType.I64, new AsmRegisterOperand("rdx"));
                this.statements.add(LLVMAMD64IdivNodeFactory.LLVMAMD64IdivqNodeGen.create(res, high, this.getOperandLoad(PrimitiveType.I64, new AsmRegisterOperand("rax")), src));
                return;
            }
            case "imulb": {
                LLVMAMD64WriteValueNode res = this.getRegisterStore("ax");
                this.statements.add(LLVMAMD64ImulNodeFactory.LLVMAMD64ImulbNodeGen.create(this.getFlagWrite(0L), this.getFlagWrite(2L), this.getFlagWrite(4L), this.getFlagWrite(6L), this.getFlagWrite(7L), this.getFlagWrite(11L), res, this.getOperandLoad(PrimitiveType.I8, new AsmRegisterOperand("al")), src));
                return;
            }
            case "imulw": {
                LLVMAMD64WriteTupelNode res = LLVMAMD64WriteTupelNodeGen.create(this.getRegisterStore("ax"), this.getRegisterStore("dx"));
                this.statements.add(LLVMAMD64ImulNodeFactory.LLVMAMD64ImulwNodeGen.create(this.getFlagWrite(0L), this.getFlagWrite(2L), this.getFlagWrite(4L), this.getFlagWrite(6L), this.getFlagWrite(7L), this.getFlagWrite(11L), res, this.getOperandLoad(PrimitiveType.I16, new AsmRegisterOperand("ax")), src));
                return;
            }
            case "imull": {
                LLVMAMD64WriteTupelNode res = LLVMAMD64WriteTupelNodeGen.create(this.getRegisterStore("eax"), this.getRegisterStore("edx"));
                this.statements.add(LLVMAMD64ImulNodeFactory.LLVMAMD64ImullNodeGen.create(this.getFlagWrite(0L), this.getFlagWrite(2L), this.getFlagWrite(4L), this.getFlagWrite(6L), this.getFlagWrite(7L), this.getFlagWrite(11L), res, this.getOperandLoad(PrimitiveType.I32, new AsmRegisterOperand("eax")), src));
                return;
            }
            case "imulq": {
                LLVMAMD64WriteTupelNode res = LLVMAMD64WriteTupelNodeGen.create(this.getRegisterStore("rax"), this.getRegisterStore("rdx"));
                this.statements.add(LLVMAMD64ImulNodeFactory.LLVMAMD64ImulqNodeGen.create(this.getFlagWrite(0L), this.getFlagWrite(2L), this.getFlagWrite(4L), this.getFlagWrite(6L), this.getFlagWrite(7L), this.getFlagWrite(11L), res, this.getOperandLoad(PrimitiveType.I64, new AsmRegisterOperand("rax")), src));
                return;
            }
            case "divb": {
                LLVMAMD64WriteValueNode res = this.getRegisterStore("ax");
                this.statements.add(LLVMAMD64DivNodeFactory.LLVMAMD64DivbNodeGen.create(res, this.getOperandLoad(PrimitiveType.I16, new AsmRegisterOperand("ax")), src));
                return;
            }
            case "divw": {
                LLVMAMD64WriteTupelNode res = LLVMAMD64WriteTupelNodeGen.create(this.getRegisterStore("ax"), this.getRegisterStore("dx"));
                LLVMExpressionNode high = this.getOperandLoad(PrimitiveType.I16, new AsmRegisterOperand("dx"));
                this.statements.add(LLVMAMD64DivNodeFactory.LLVMAMD64DivwNodeGen.create(res, high, this.getOperandLoad(PrimitiveType.I16, new AsmRegisterOperand("ax")), src));
                return;
            }
            case "divl": {
                LLVMAMD64WriteTupelNode res = LLVMAMD64WriteTupelNodeGen.create(this.getRegisterStore("eax"), this.getRegisterStore("edx"));
                LLVMExpressionNode high = this.getOperandLoad(PrimitiveType.I32, new AsmRegisterOperand("edx"));
                this.statements.add(LLVMAMD64DivNodeFactory.LLVMAMD64DivlNodeGen.create(res, high, this.getOperandLoad(PrimitiveType.I32, new AsmRegisterOperand("eax")), src));
                return;
            }
            case "divq": {
                LLVMAMD64WriteTupelNode res = LLVMAMD64WriteTupelNodeGen.create(this.getRegisterStore("rax"), this.getRegisterStore("rdx"));
                LLVMExpressionNode high = this.getOperandLoad(PrimitiveType.I64, new AsmRegisterOperand("rdx"));
                this.statements.add(LLVMAMD64DivNodeFactory.LLVMAMD64DivqNodeGen.create(res, high, this.getOperandLoad(PrimitiveType.I64, new AsmRegisterOperand("rax")), src));
                return;
            }
            case "mulb": {
                LLVMAMD64WriteValueNode res = this.getRegisterStore("ax");
                this.statements.add(LLVMAMD64MulNodeFactory.LLVMAMD64MulbNodeGen.create(this.getFlagWrite(0L), this.getFlagWrite(2L), this.getFlagWrite(4L), this.getFlagWrite(6L), this.getFlagWrite(7L), this.getFlagWrite(11L), res, this.getOperandLoad(PrimitiveType.I8, new AsmRegisterOperand("al")), src));
                return;
            }
            case "mulw": {
                LLVMAMD64WriteTupelNode res = LLVMAMD64WriteTupelNodeGen.create(this.getRegisterStore("ax"), this.getRegisterStore("dx"));
                this.statements.add(LLVMAMD64MulNodeFactory.LLVMAMD64MulwNodeGen.create(this.getFlagWrite(0L), this.getFlagWrite(2L), this.getFlagWrite(4L), this.getFlagWrite(6L), this.getFlagWrite(7L), this.getFlagWrite(11L), res, this.getOperandLoad(PrimitiveType.I16, new AsmRegisterOperand("ax")), src));
                return;
            }
            case "mull": {
                LLVMAMD64WriteTupelNode res = LLVMAMD64WriteTupelNodeGen.create(this.getRegisterStore("eax"), this.getRegisterStore("edx"));
                this.statements.add(LLVMAMD64MulNodeFactory.LLVMAMD64MullNodeGen.create(this.getFlagWrite(0L), this.getFlagWrite(2L), this.getFlagWrite(4L), this.getFlagWrite(6L), this.getFlagWrite(7L), this.getFlagWrite(11L), res, this.getOperandLoad(PrimitiveType.I32, new AsmRegisterOperand("eax")), src));
                return;
            }
            case "mulq": {
                LLVMAMD64WriteTupelNode res = LLVMAMD64WriteTupelNodeGen.create(this.getRegisterStore("rax"), this.getRegisterStore("rdx"));
                this.statements.add(LLVMAMD64MulNodeFactory.LLVMAMD64MulqNodeGen.create(this.getFlagWrite(0L), this.getFlagWrite(2L), this.getFlagWrite(4L), this.getFlagWrite(6L), this.getFlagWrite(7L), this.getFlagWrite(11L), res, this.getOperandLoad(PrimitiveType.I64, new AsmRegisterOperand("rax")), src));
                return;
            }
            case "bswapl": {
                out = LLVMAMD64BswapNodeFactory.LLVMAMD64BswaplNodeGen.create(src);
                break;
            }
            case "bswapq": {
                out = LLVMAMD64BswapNodeFactory.LLVMAMD64BswapqNodeGen.create(src);
                break;
            }
            case "popw": {
                out = LLVMAMD64PopNodeFactory.LLVMAMD64PopwNodeGen.create();
                break;
            }
            case "popl": {
                out = LLVMAMD64PopNodeFactory.LLVMAMD64PoplNodeGen.create();
                break;
            }
            case "popq": {
                out = LLVMAMD64PopNodeFactory.LLVMAMD64PopqNodeGen.create();
                break;
            }
            case "pushw": {
                this.statements.add(LLVMAMD64PushNodeFactory.LLVMAMD64PushwNodeGen.create(src));
                return;
            }
            case "pushl": {
                this.statements.add(LLVMAMD64PushNodeFactory.LLVMAMD64PushlNodeGen.create(src));
                return;
            }
            case "pushq": {
                this.statements.add(LLVMAMD64PushNodeFactory.LLVMAMD64PushqNodeGen.create(src));
                return;
            }
            default: {
                this.statements.add(LLVMUnsupportedInstructionNode.create(LLVMUnsupportedException.UnsupportedReason.INLINE_ASSEMBLER, operation));
                return;
            }
        }
        this.statements.add(this.getOperandStore(dstType, dst, out));
    }

    private static boolean isShiftOperation(String operation) {
        return operation.startsWith("shl") || operation.startsWith("shr") || operation.startsWith("rol") || operation.startsWith("ror") || operation.startsWith("sal") || operation.startsWith("sar");
    }

    private static PrimitiveType getPrimitiveTypeFromSuffix(char suffix) {
        switch (suffix) {
            case 'b': {
                return PrimitiveType.I8;
            }
            case 'w': {
                return PrimitiveType.I16;
            }
            case 'l': {
                return PrimitiveType.I32;
            }
            case 'q': {
                return PrimitiveType.I64;
            }
        }
        throw new AsmParseException("invalid size");
    }

    private Type getType(AsmOperand operand) {
        Type type = operand.getType();
        if (type != null) {
            return type;
        }
        if (operand instanceof AsmArgumentOperand) {
            AsmArgumentOperand op = (AsmArgumentOperand)operand;
            Argument info = this.argInfo.get(op.getIndex());
            return info.getType();
        }
        return null;
    }

    private Type getType(AsmOperand dst, AsmOperand src) {
        Type type = this.getType(dst);
        if (type == null || type instanceof VoidType) {
            type = this.getType(src);
        }
        if (type == null) {
            throw new AsmParseException("cannot infer type");
        }
        return type;
    }

    void createBinaryOperationImplicitSize(String operation, AsmOperand a, AsmOperand b) {
        LLVMExpressionNode out;
        AsmOperand dst = b;
        AsmOperand src = a;
        assert (a != null && b != null);
        Type dstType = this.getType(b, a);
        block12 : switch (operation) {
            case "lea": {
                out = this.getOperandAddress(dstType, src);
                if (!this.isLeaPointer(src)) break;
                dstType = new PointerType(dstType);
                break;
            }
            case "xor": {
                LLVMExpressionNode srcA = this.getOperandLoad(dstType, a);
                LLVMExpressionNode srcB = this.getOperandLoad(dstType, b);
                switch (AsmFactory.getPrimitiveType(dstType)) {
                    case I8: {
                        out = LLVMAMD64XorNodeFactory.LLVMAMD64XorbNodeGen.create(srcA, srcB);
                        break block12;
                    }
                    case I16: {
                        out = LLVMAMD64XorNodeFactory.LLVMAMD64XorwNodeGen.create(srcA, srcB);
                        break block12;
                    }
                    case I32: {
                        out = LLVMAMD64XorNodeFactory.LLVMAMD64XorlNodeGen.create(srcA, srcB);
                        break block12;
                    }
                    case I64: {
                        out = LLVMAMD64XorNodeFactory.LLVMAMD64XorqNodeGen.create(srcA, srcB);
                        break block12;
                    }
                }
                throw AsmFactory.invalidOperandType(dstType);
            }
            case "mov": {
                if (dstType instanceof PrimitiveType || dstType instanceof PointerType) {
                    out = this.getOperandLoad(dstType, a);
                    break;
                }
                throw AsmFactory.invalidOperandType(dstType);
            }
            case "bsr": {
                LLVMExpressionNode srcA = this.getOperandLoad(dstType, a);
                LLVMExpressionNode srcB = this.getOperandLoad(dstType, b);
                switch (AsmFactory.getPrimitiveType(dstType)) {
                    case I16: {
                        out = LLVMAMD64BsrNodeFactory.LLVMAMD64BsrwNodeGen.create(this.getFlagWrite(6L), srcA, srcB);
                        break block12;
                    }
                    case I32: {
                        out = LLVMAMD64BsrNodeFactory.LLVMAMD64BsrlNodeGen.create(this.getFlagWrite(6L), srcA, srcB);
                        break block12;
                    }
                    case I64: {
                        out = LLVMAMD64BsrNodeFactory.LLVMAMD64BsrqNodeGen.create(this.getFlagWrite(6L), srcA, srcB);
                        break block12;
                    }
                }
                throw AsmFactory.invalidOperandType(dstType);
            }
            case "bsf": {
                LLVMExpressionNode srcA = this.getOperandLoad(dstType, a);
                LLVMExpressionNode srcB = this.getOperandLoad(dstType, b);
                switch (AsmFactory.getPrimitiveType(dstType)) {
                    case I16: {
                        out = LLVMAMD64BsfNodeFactory.LLVMAMD64BsfwNodeGen.create(this.getFlagWrite(6L), srcA, srcB);
                        break block12;
                    }
                    case I32: {
                        out = LLVMAMD64BsfNodeFactory.LLVMAMD64BsflNodeGen.create(this.getFlagWrite(6L), srcA, srcB);
                        break block12;
                    }
                    case I64: {
                        out = LLVMAMD64BsfNodeFactory.LLVMAMD64BsfqNodeGen.create(this.getFlagWrite(6L), srcA, srcB);
                        break block12;
                    }
                }
                throw AsmFactory.invalidOperandType(dstType);
            }
            case "xchg": {
                LLVMAMD64XchgNode res;
                XchgOperands operands = new XchgOperands(a, b, dstType);
                switch (AsmFactory.getPrimitiveType(dstType)) {
                    case I8: {
                        res = LLVMAMD64XchgNodeFactory.LLVMAMD64XchgbNodeGen.create(operands.dst, operands.srcA, operands.srcB);
                        break;
                    }
                    case I16: {
                        res = LLVMAMD64XchgNodeFactory.LLVMAMD64XchgwNodeGen.create(operands.dst, operands.srcA, operands.srcB);
                        break;
                    }
                    case I32: {
                        res = LLVMAMD64XchgNodeFactory.LLVMAMD64XchglNodeGen.create(operands.dst, operands.srcA, operands.srcB);
                        break;
                    }
                    case I64: {
                        res = LLVMAMD64XchgNodeFactory.LLVMAMD64XchgqNodeGen.create(operands.dst, operands.srcA, operands.srcB);
                        break;
                    }
                    default: {
                        throw AsmFactory.invalidOperandType(dstType);
                    }
                }
                this.statements.add(res);
                return;
            }
            case "cmpxchg": {
                LLVMAMD64CmpXchgNode res;
                LLVMExpressionNode srcA = this.getOperandLoad(dstType, a);
                LLVMExpressionNode srcB = this.getOperandLoad(dstType, b);
                LLVMAMD64WriteValueNode dst1 = this.getStore(dstType, b);
                if (dstType instanceof PointerType) {
                    LLVMAMD64WriteValueNode dst2 = this.getRegisterStore("rax");
                    LLVMExpressionNode accumulator = this.getOperandLoad(new PointerType(PrimitiveType.I8), new AsmRegisterOperand("rax"));
                    res = LLVMAMD64CmpXchgNodeFactory.LLVMAMD64CmpXchgqNodeGen.create(this.getUpdateCPAZSOFlagsNode(), dst1, dst2, accumulator, srcA, srcB);
                } else {
                    switch (AsmFactory.getPrimitiveType(dstType)) {
                        case I8: {
                            LLVMAMD64WriteValueNode dst2 = this.getRegisterStore("al");
                            LLVMExpressionNode accumulator = this.getOperandLoad(PrimitiveType.I8, new AsmRegisterOperand("al"));
                            res = LLVMAMD64CmpXchgNodeFactory.LLVMAMD64CmpXchgbNodeGen.create(this.getUpdateCPAZSOFlagsNode(), dst1, dst2, accumulator, srcA, srcB);
                            break;
                        }
                        case I16: {
                            LLVMAMD64WriteValueNode dst2 = this.getRegisterStore("ax");
                            LLVMExpressionNode accumulator = this.getOperandLoad(PrimitiveType.I16, new AsmRegisterOperand("ax"));
                            res = LLVMAMD64CmpXchgNodeFactory.LLVMAMD64CmpXchgwNodeGen.create(this.getUpdateCPAZSOFlagsNode(), dst1, dst2, accumulator, srcA, srcB);
                            break;
                        }
                        case I32: {
                            LLVMAMD64WriteValueNode dst2 = this.getRegisterStore("eax");
                            LLVMExpressionNode accumulator = this.getOperandLoad(PrimitiveType.I32, new AsmRegisterOperand("eax"));
                            res = LLVMAMD64CmpXchgNodeFactory.LLVMAMD64CmpXchglNodeGen.create(this.getUpdateCPAZSOFlagsNode(), dst1, dst2, accumulator, srcA, srcB);
                            break;
                        }
                        case I64: {
                            LLVMAMD64WriteValueNode dst2 = this.getRegisterStore("rax");
                            LLVMExpressionNode accumulator = this.getOperandLoad(PrimitiveType.I64, new AsmRegisterOperand("rax"));
                            res = LLVMAMD64CmpXchgNodeFactory.LLVMAMD64CmpXchgqNodeGen.create(this.getUpdateCPAZSOFlagsNode(), dst1, dst2, accumulator, srcA, srcB);
                            break;
                        }
                        default: {
                            throw AsmFactory.invalidOperandType(dstType);
                        }
                    }
                }
                this.statements.add(res);
                return;
            }
            case "and": {
                LLVMExpressionNode srcA = this.getOperandLoad(dstType, a);
                LLVMExpressionNode srcB = this.getOperandLoad(dstType, b);
                switch (AsmFactory.getPrimitiveType(dstType)) {
                    case I8: {
                        out = LLVMAMD64AndNodeFactory.LLVMAMD64AndbNodeGen.create(this.getUpdatePZSFlagsNode(), srcA, srcB);
                        break block12;
                    }
                    case I16: {
                        out = LLVMAMD64AndNodeFactory.LLVMAMD64AndwNodeGen.create(this.getUpdatePZSFlagsNode(), srcA, srcB);
                        break block12;
                    }
                    case I32: {
                        out = LLVMAMD64AndNodeFactory.LLVMAMD64AndlNodeGen.create(this.getUpdatePZSFlagsNode(), srcA, srcB);
                        break block12;
                    }
                    case I64: {
                        out = LLVMAMD64AndNodeFactory.LLVMAMD64AndqNodeGen.create(this.getUpdatePZSFlagsNode(), srcA, srcB);
                        break block12;
                    }
                }
                throw AsmFactory.invalidOperandType(dstType);
            }
            case "or": {
                LLVMExpressionNode srcA = this.getOperandLoad(dstType, a);
                LLVMExpressionNode srcB = this.getOperandLoad(dstType, b);
                switch (AsmFactory.getPrimitiveType(dstType)) {
                    case I8: {
                        out = LLVMAMD64OrNodeFactory.LLVMAMD64OrbNodeGen.create(srcA, srcB);
                        break block12;
                    }
                    case I16: {
                        out = LLVMAMD64OrNodeFactory.LLVMAMD64OrwNodeGen.create(srcA, srcB);
                        break block12;
                    }
                    case I32: {
                        out = LLVMAMD64OrNodeFactory.LLVMAMD64OrlNodeGen.create(srcA, srcB);
                        break block12;
                    }
                    case I64: {
                        out = LLVMAMD64OrNodeFactory.LLVMAMD64OrqNodeGen.create(srcA, srcB);
                        break block12;
                    }
                }
                throw AsmFactory.invalidOperandType(dstType);
            }
            case "pmovmskb": {
                LLVMExpressionNode srcA = this.getOperandLoad(this.getType(a), a);
                LLVMX86_ConversionNode.LLVMX86_Pmovmskb128 pmovmskb128 = LLVMX86_ConversionNodeFactory.LLVMX86_Pmovmskb128NodeGen.create(srcA);
                out = pmovmskb128;
                break;
            }
            default: {
                this.statements.add(LLVMUnsupportedInstructionNode.create(LLVMUnsupportedException.UnsupportedReason.INLINE_ASSEMBLER, operation));
                return;
            }
        }
        this.statements.add(this.getOperandStore(dstType, dst, out));
    }

    private static PrimitiveType.PrimitiveKind getPrimitiveType(Type dstType) {
        if (dstType instanceof PrimitiveType) {
            return ((PrimitiveType)dstType).getPrimitiveKind();
        }
        throw AsmFactory.invalidOperandType(dstType);
    }

    void createBinaryOperation(String operation, AsmOperand a, AsmOperand b) {
        LLVMExpressionNode out;
        assert (a != null && b != null);
        AsmOperand dst = b;
        char suffix = operation.charAt(operation.length() - 1);
        PrimitiveType dstType = AsmFactory.getPrimitiveTypeFromSuffix(suffix);
        LLVMExpressionNode srcB = this.getOperandLoad(dstType, b);
        LLVMExpressionNode srcA = AsmFactory.isShiftOperation(operation) ? this.getOperandLoad(PrimitiveType.I8, a) : this.getOperandLoad(dstType, a);
        switch (operation) {
            case "addb": {
                out = LLVMAMD64AddNodeFactory.LLVMAMD64AddbNodeGen.create(this.getUpdateCPZSOFlagsNode(), srcA, srcB);
                break;
            }
            case "addw": {
                out = LLVMAMD64AddNodeFactory.LLVMAMD64AddwNodeGen.create(this.getUpdateCPZSOFlagsNode(), srcA, srcB);
                break;
            }
            case "addl": {
                out = LLVMAMD64AddNodeFactory.LLVMAMD64AddlNodeGen.create(this.getUpdateCPZSOFlagsNode(), srcA, srcB);
                break;
            }
            case "addq": {
                out = LLVMAMD64AddNodeFactory.LLVMAMD64AddqNodeGen.create(this.getUpdateCPZSOFlagsNode(), srcA, srcB);
                break;
            }
            case "adcb": {
                out = LLVMAMD64AdcNodeFactory.LLVMAMD64AdcbNodeGen.create(this.getUpdateCPZSOFlagsNode(), srcA, srcB, this.getFlag(0L));
                break;
            }
            case "adcw": {
                out = LLVMAMD64AdcNodeFactory.LLVMAMD64AdcwNodeGen.create(this.getUpdateCPZSOFlagsNode(), srcA, srcB, this.getFlag(0L));
                break;
            }
            case "adcl": {
                out = LLVMAMD64AdcNodeFactory.LLVMAMD64AdclNodeGen.create(this.getUpdateCPZSOFlagsNode(), srcA, srcB, this.getFlag(0L));
                break;
            }
            case "adcq": {
                out = LLVMAMD64AdcNodeFactory.LLVMAMD64AdcqNodeGen.create(this.getUpdateCPZSOFlagsNode(), srcA, srcB, this.getFlag(0L));
                break;
            }
            case "subb": {
                out = LLVMAMD64SubNodeFactory.LLVMAMD64SubbNodeGen.create(srcB, srcA);
                break;
            }
            case "subw": {
                out = LLVMAMD64SubNodeFactory.LLVMAMD64SubwNodeGen.create(srcB, srcA);
                break;
            }
            case "subl": {
                out = LLVMAMD64SubNodeFactory.LLVMAMD64SublNodeGen.create(srcB, srcA);
                break;
            }
            case "subq": {
                out = LLVMAMD64SubNodeFactory.LLVMAMD64SubqNodeGen.create(srcB, srcA);
                break;
            }
            case "idivb": {
                srcA = this.getOperandLoad(PrimitiveType.I8, a);
                srcB = this.getOperandLoad(PrimitiveType.I16, b);
                out = LLVMAMD64IdivNodeFactory.LLVMAMD64IdivbNodeGen.create(srcB, srcA);
                dst = new AsmRegisterOperand("ax");
                dstType = PrimitiveType.I16;
                break;
            }
            case "idivw": {
                LLVMAMD64WriteTupelNode res = LLVMAMD64WriteTupelNodeGen.create(this.getRegisterStore("ax"), this.getRegisterStore("dx"));
                LLVMExpressionNode high = this.getOperandLoad(PrimitiveType.I16, new AsmRegisterOperand("dx"));
                this.statements.add(LLVMAMD64IdivNodeFactory.LLVMAMD64IdivwNodeGen.create(res, high, srcB, srcA));
                return;
            }
            case "idivl": {
                LLVMAMD64WriteTupelNode res = LLVMAMD64WriteTupelNodeGen.create(this.getRegisterStore("eax"), this.getRegisterStore("edx"));
                LLVMExpressionNode high = this.getOperandLoad(PrimitiveType.I32, new AsmRegisterOperand("edx"));
                this.statements.add(LLVMAMD64IdivNodeFactory.LLVMAMD64IdivlNodeGen.create(res, high, srcB, srcA));
                return;
            }
            case "idivq": {
                LLVMAMD64WriteTupelNode res = LLVMAMD64WriteTupelNodeGen.create(this.getRegisterStore("rax"), this.getRegisterStore("rdx"));
                LLVMExpressionNode high = this.getOperandLoad(PrimitiveType.I32, new AsmRegisterOperand("rdx"));
                this.statements.add(LLVMAMD64IdivNodeFactory.LLVMAMD64IdivqNodeGen.create(res, high, srcB, srcA));
                return;
            }
            case "imulw": {
                LLVMAMD64WriteValueNode res = this.getRegisterStore((Type)dstType, dst);
                this.statements.add(LLVMAMD64ImulNodeFactory.LLVMAMD64Imulw3NodeGen.create(this.getFlagWrite(0L), this.getFlagWrite(2L), this.getFlagWrite(4L), this.getFlagWrite(6L), this.getFlagWrite(7L), this.getFlagWrite(11L), res, srcA, srcB));
                return;
            }
            case "imull": {
                LLVMAMD64WriteValueNode res = this.getRegisterStore((Type)dstType, dst);
                this.statements.add(LLVMAMD64ImulNodeFactory.LLVMAMD64Imull3NodeGen.create(this.getFlagWrite(0L), this.getFlagWrite(2L), this.getFlagWrite(4L), this.getFlagWrite(6L), this.getFlagWrite(7L), this.getFlagWrite(11L), res, srcA, srcB));
                return;
            }
            case "imulq": {
                LLVMAMD64WriteValueNode res = this.getRegisterStore((Type)dstType, dst);
                this.statements.add(LLVMAMD64ImulNodeFactory.LLVMAMD64Imulq3NodeGen.create(this.getFlagWrite(0L), this.getFlagWrite(2L), this.getFlagWrite(4L), this.getFlagWrite(6L), this.getFlagWrite(7L), this.getFlagWrite(11L), res, srcA, srcB));
                return;
            }
            case "movb": 
            case "movw": 
            case "movl": 
            case "movq": {
                out = srcA;
                break;
            }
            case "movsbw": {
                srcA = this.getOperandLoad(PrimitiveType.I8, a);
                out = CommonNodeFactory.createSignedCast(srcA, PrimitiveType.I16);
                break;
            }
            case "movsbl": {
                srcA = this.getOperandLoad(PrimitiveType.I8, a);
                out = CommonNodeFactory.createSignedCast(srcA, PrimitiveType.I32);
                break;
            }
            case "movsbq": {
                srcA = this.getOperandLoad(PrimitiveType.I8, a);
                out = CommonNodeFactory.createSignedCast(srcA, PrimitiveType.I64);
                break;
            }
            case "movswl": {
                srcA = this.getOperandLoad(PrimitiveType.I16, a);
                out = CommonNodeFactory.createSignedCast(srcA, PrimitiveType.I32);
                break;
            }
            case "movswq": {
                srcA = this.getOperandLoad(PrimitiveType.I16, a);
                out = CommonNodeFactory.createSignedCast(srcA, PrimitiveType.I64);
                break;
            }
            case "movslq": {
                srcA = this.getOperandLoad(PrimitiveType.I32, a);
                out = CommonNodeFactory.createSignedCast(srcA, PrimitiveType.I64);
                break;
            }
            case "movzbw": {
                srcA = this.getOperandLoad(PrimitiveType.I8, a);
                out = CommonNodeFactory.createUnsignedCast(srcA, PrimitiveType.I16);
                break;
            }
            case "movzbl": {
                srcA = this.getOperandLoad(PrimitiveType.I8, a);
                out = CommonNodeFactory.createUnsignedCast(srcA, PrimitiveType.I32);
                break;
            }
            case "movzbq": {
                srcA = this.getOperandLoad(PrimitiveType.I8, a);
                out = CommonNodeFactory.createUnsignedCast(srcA, PrimitiveType.I64);
                break;
            }
            case "movzwl": {
                srcA = this.getOperandLoad(PrimitiveType.I16, a);
                out = CommonNodeFactory.createUnsignedCast(srcA, PrimitiveType.I32);
                break;
            }
            case "movzwq": {
                srcA = this.getOperandLoad(PrimitiveType.I16, a);
                out = CommonNodeFactory.createUnsignedCast(srcA, PrimitiveType.I64);
                break;
            }
            case "salb": {
                out = LLVMAMD64SalNodeFactory.LLVMAMD64SalbNodeGen.create(srcB, srcA);
                break;
            }
            case "salw": {
                out = LLVMAMD64SalNodeFactory.LLVMAMD64SalwNodeGen.create(srcB, srcA);
                break;
            }
            case "sall": {
                out = LLVMAMD64SalNodeFactory.LLVMAMD64SallNodeGen.create(srcB, srcA);
                break;
            }
            case "salq": {
                out = LLVMAMD64SalNodeFactory.LLVMAMD64SalqNodeGen.create(srcB, srcA);
                break;
            }
            case "sarb": {
                out = LLVMAMD64SarNodeFactory.LLVMAMD64SarbNodeGen.create(srcB, srcA);
                break;
            }
            case "sarw": {
                out = LLVMAMD64SarNodeFactory.LLVMAMD64SarwNodeGen.create(srcB, srcA);
                break;
            }
            case "sarl": {
                out = LLVMAMD64SarNodeFactory.LLVMAMD64SarlNodeGen.create(srcB, srcA);
                break;
            }
            case "sarq": {
                out = LLVMAMD64SarNodeFactory.LLVMAMD64SarqNodeGen.create(srcB, srcA);
                break;
            }
            case "shlb": {
                out = LLVMAMD64ShlNodeFactory.LLVMAMD64ShlbNodeGen.create(srcB, srcA);
                break;
            }
            case "shlw": {
                out = LLVMAMD64ShlNodeFactory.LLVMAMD64ShlwNodeGen.create(srcB, srcA);
                break;
            }
            case "shll": {
                out = LLVMAMD64ShlNodeFactory.LLVMAMD64ShllNodeGen.create(srcB, srcA);
                break;
            }
            case "shlq": {
                out = LLVMAMD64ShlNodeFactory.LLVMAMD64ShlqNodeGen.create(srcB, srcA);
                break;
            }
            case "shrb": {
                out = LLVMAMD64ShrNodeFactory.LLVMAMD64ShrbNodeGen.create(srcB, srcA);
                break;
            }
            case "shrw": {
                out = LLVMAMD64ShrNodeFactory.LLVMAMD64ShrwNodeGen.create(srcB, srcA);
                break;
            }
            case "shrl": {
                out = LLVMAMD64ShrNodeFactory.LLVMAMD64ShrlNodeGen.create(srcB, srcA);
                break;
            }
            case "shrq": {
                out = LLVMAMD64ShrNodeFactory.LLVMAMD64ShrqNodeGen.create(srcB, srcA);
                break;
            }
            case "rolb": {
                out = LLVMAMD64RolNodeFactory.LLVMAMD64RolbNodeGen.create(srcB, srcA);
                break;
            }
            case "rolw": {
                out = LLVMAMD64RolNodeFactory.LLVMAMD64RolwNodeGen.create(srcB, srcA);
                break;
            }
            case "roll": {
                out = LLVMAMD64RolNodeFactory.LLVMAMD64RollNodeGen.create(srcB, srcA);
                break;
            }
            case "rolq": {
                out = LLVMAMD64RolNodeFactory.LLVMAMD64RolqNodeGen.create(srcB, srcA);
                break;
            }
            case "rorb": {
                out = LLVMAMD64RorNodeFactory.LLVMAMD64RorbNodeGen.create(srcB, srcA);
                break;
            }
            case "rorw": {
                out = LLVMAMD64RorNodeFactory.LLVMAMD64RorwNodeGen.create(srcB, srcA);
                break;
            }
            case "rorl": {
                out = LLVMAMD64RorNodeFactory.LLVMAMD64RorlNodeGen.create(srcB, srcA);
                break;
            }
            case "rorq": {
                out = LLVMAMD64RorNodeFactory.LLVMAMD64RorqNodeGen.create(srcB, srcA);
                break;
            }
            case "andb": {
                out = LLVMAMD64AndNodeFactory.LLVMAMD64AndbNodeGen.create(this.getUpdatePZSFlagsNode(), srcA, srcB);
                break;
            }
            case "andw": {
                out = LLVMAMD64AndNodeFactory.LLVMAMD64AndwNodeGen.create(this.getUpdatePZSFlagsNode(), srcA, srcB);
                break;
            }
            case "andl": {
                out = LLVMAMD64AndNodeFactory.LLVMAMD64AndlNodeGen.create(this.getUpdatePZSFlagsNode(), srcA, srcB);
                break;
            }
            case "andq": {
                out = LLVMAMD64AndNodeFactory.LLVMAMD64AndqNodeGen.create(this.getUpdatePZSFlagsNode(), srcA, srcB);
                break;
            }
            case "orb": {
                out = LLVMAMD64OrNodeFactory.LLVMAMD64OrbNodeGen.create(srcA, srcB);
                break;
            }
            case "orw": {
                out = LLVMAMD64OrNodeFactory.LLVMAMD64OrwNodeGen.create(srcA, srcB);
                break;
            }
            case "orl": {
                out = LLVMAMD64OrNodeFactory.LLVMAMD64OrlNodeGen.create(srcA, srcB);
                break;
            }
            case "orq": {
                out = LLVMAMD64OrNodeFactory.LLVMAMD64OrqNodeGen.create(srcA, srcB);
                break;
            }
            case "xchgb": {
                XchgOperands operands = new XchgOperands(a, b, dstType);
                this.statements.add(LLVMAMD64XchgNodeFactory.LLVMAMD64XchgbNodeGen.create(operands.dst, operands.srcA, operands.srcB));
                return;
            }
            case "xchgw": {
                XchgOperands operands = new XchgOperands(a, b, dstType);
                this.statements.add(LLVMAMD64XchgNodeFactory.LLVMAMD64XchgwNodeGen.create(operands.dst, operands.srcA, operands.srcB));
                return;
            }
            case "xchgl": {
                XchgOperands operands = new XchgOperands(a, b, dstType);
                this.statements.add(LLVMAMD64XchgNodeFactory.LLVMAMD64XchglNodeGen.create(operands.dst, operands.srcA, operands.srcB));
                return;
            }
            case "xchgq": {
                XchgOperands operands = new XchgOperands(a, b, dstType);
                this.statements.add(LLVMAMD64XchgNodeFactory.LLVMAMD64XchgqNodeGen.create(operands.dst, operands.srcA, operands.srcB));
                return;
            }
            case "cmpb": {
                this.statements.add(LLVMAMD64CmpNodeFactory.LLVMAMD64CmpbNodeGen.create(this.getUpdateCPAZSOFlagsNode(), srcB, srcA));
                return;
            }
            case "cmpw": {
                this.statements.add(LLVMAMD64CmpNodeFactory.LLVMAMD64CmpwNodeGen.create(this.getUpdateCPAZSOFlagsNode(), srcB, srcA));
                return;
            }
            case "cmpl": {
                this.statements.add(LLVMAMD64CmpNodeFactory.LLVMAMD64CmplNodeGen.create(this.getUpdateCPAZSOFlagsNode(), srcB, srcA));
                return;
            }
            case "cmpq": {
                this.statements.add(LLVMAMD64CmpNodeFactory.LLVMAMD64CmpqNodeGen.create(this.getUpdateCPAZSOFlagsNode(), srcB, srcA));
                return;
            }
            case "cmpxchgb": {
                LLVMAMD64WriteValueNode dst1 = this.getStore(dstType, b);
                LLVMAMD64WriteValueNode dst2 = this.getRegisterStore("al");
                LLVMExpressionNode accumulator = this.getOperandLoad(PrimitiveType.I8, new AsmRegisterOperand("al"));
                this.statements.add(LLVMAMD64CmpXchgNodeFactory.LLVMAMD64CmpXchgbNodeGen.create(this.getUpdateCPAZSOFlagsNode(), dst1, dst2, accumulator, srcA, srcB));
                return;
            }
            case "cmpxchgw": {
                LLVMAMD64WriteValueNode dst1 = this.getStore(dstType, b);
                LLVMAMD64WriteValueNode dst2 = this.getRegisterStore("ax");
                LLVMExpressionNode accumulator = this.getOperandLoad(PrimitiveType.I16, new AsmRegisterOperand("ax"));
                this.statements.add(LLVMAMD64CmpXchgNodeFactory.LLVMAMD64CmpXchgwNodeGen.create(this.getUpdateCPAZSOFlagsNode(), dst1, dst2, accumulator, srcA, srcB));
                return;
            }
            case "cmpxchgl": {
                LLVMAMD64WriteValueNode dst1 = this.getStore(dstType, b);
                LLVMAMD64WriteValueNode dst2 = this.getRegisterStore("eax");
                LLVMExpressionNode accumulator = this.getOperandLoad(PrimitiveType.I32, new AsmRegisterOperand("eax"));
                this.statements.add(LLVMAMD64CmpXchgNodeFactory.LLVMAMD64CmpXchglNodeGen.create(this.getUpdateCPAZSOFlagsNode(), dst1, dst2, accumulator, srcA, srcB));
                return;
            }
            case "cmpxchgq": {
                LLVMAMD64WriteValueNode dst1 = this.getStore(dstType, b);
                LLVMAMD64WriteValueNode dst2 = this.getRegisterStore("rax");
                LLVMExpressionNode accumulator = this.getOperandLoad(PrimitiveType.I64, new AsmRegisterOperand("rax"));
                this.statements.add(LLVMAMD64CmpXchgNodeFactory.LLVMAMD64CmpXchgqNodeGen.create(this.getUpdateCPAZSOFlagsNode(), dst1, dst2, accumulator, srcA, srcB));
                return;
            }
            case "xaddb": {
                LLVMAMD64WriteValueNode dst1 = this.getRegisterStore((Type)PrimitiveType.I8, a);
                LLVMAMD64WriteValueNode dst2 = this.getStore(dstType, dst);
                LLVMAMD64WriteTupelNode res = LLVMAMD64WriteTupelNodeGen.create(dst1, dst2);
                this.statements.add(LLVMAMD64XaddNodeFactory.LLVMAMD64XaddbNodeGen.create(this.getUpdateCPZSOFlagsNode(), res, srcA, srcB));
                return;
            }
            case "xaddw": {
                LLVMAMD64WriteValueNode dst1 = this.getRegisterStore((Type)PrimitiveType.I16, a);
                LLVMAMD64WriteValueNode dst2 = this.getStore(dstType, dst);
                LLVMAMD64WriteTupelNode res = LLVMAMD64WriteTupelNodeGen.create(dst1, dst2);
                this.statements.add(LLVMAMD64XaddNodeFactory.LLVMAMD64XaddwNodeGen.create(this.getUpdateCPZSOFlagsNode(), res, srcA, srcB));
                return;
            }
            case "xaddl": {
                LLVMAMD64WriteValueNode dst1 = this.getRegisterStore((Type)PrimitiveType.I32, a);
                LLVMAMD64WriteValueNode dst2 = this.getStore(dstType, dst);
                LLVMAMD64WriteTupelNode res = LLVMAMD64WriteTupelNodeGen.create(dst1, dst2);
                this.statements.add(LLVMAMD64XaddNodeFactory.LLVMAMD64XaddlNodeGen.create(this.getUpdateCPZSOFlagsNode(), res, srcA, srcB));
                return;
            }
            case "xaddq": {
                LLVMAMD64WriteValueNode dst1 = this.getRegisterStore((Type)PrimitiveType.I64, a);
                LLVMAMD64WriteValueNode dst2 = this.getStore(dstType, dst);
                LLVMAMD64WriteTupelNode res = LLVMAMD64WriteTupelNodeGen.create(dst1, dst2);
                this.statements.add(LLVMAMD64XaddNodeFactory.LLVMAMD64XaddqNodeGen.create(this.getUpdateCPZSOFlagsNode(), res, srcA, srcB));
                return;
            }
            case "xorb": {
                out = LLVMAMD64XorNodeFactory.LLVMAMD64XorbNodeGen.create(srcA, srcB);
                break;
            }
            case "xorw": {
                out = LLVMAMD64XorNodeFactory.LLVMAMD64XorwNodeGen.create(srcA, srcB);
                break;
            }
            case "xorl": {
                out = LLVMAMD64XorNodeFactory.LLVMAMD64XorlNodeGen.create(srcA, srcB);
                break;
            }
            case "xorq": {
                out = LLVMAMD64XorNodeFactory.LLVMAMD64XorqNodeGen.create(srcA, srcB);
                break;
            }
            case "bsrw": {
                out = LLVMAMD64BsrNodeFactory.LLVMAMD64BsrwNodeGen.create(this.getFlagWrite(6L), srcA, srcB);
                break;
            }
            case "bsrl": {
                out = LLVMAMD64BsrNodeFactory.LLVMAMD64BsrlNodeGen.create(this.getFlagWrite(6L), srcA, srcB);
                break;
            }
            case "bsrq": {
                out = LLVMAMD64BsrNodeFactory.LLVMAMD64BsrqNodeGen.create(this.getFlagWrite(6L), srcA, srcB);
                break;
            }
            case "bsfw": {
                out = LLVMAMD64BsfNodeFactory.LLVMAMD64BsfwNodeGen.create(this.getFlagWrite(6L), srcA, srcB);
                break;
            }
            case "bsfl": {
                out = LLVMAMD64BsfNodeFactory.LLVMAMD64BsflNodeGen.create(this.getFlagWrite(6L), srcA, srcB);
                break;
            }
            case "bsfq": {
                out = LLVMAMD64BsfNodeFactory.LLVMAMD64BsfqNodeGen.create(this.getFlagWrite(6L), srcA, srcB);
                break;
            }
            default: {
                this.statements.add(LLVMUnsupportedInstructionNode.create(LLVMUnsupportedException.UnsupportedReason.INLINE_ASSEMBLER, operation));
                return;
            }
        }
        this.statements.add(this.getOperandStore(dstType, dst, out));
    }

    void createTernaryOperation(String operation, AsmOperand a, AsmOperand b, AsmOperand c) {
        AsmOperand dst = c;
        assert (a != null && b != null && c != null);
        char suffix = operation.charAt(operation.length() - 1);
        PrimitiveType dstType = AsmFactory.getPrimitiveTypeFromSuffix(suffix);
        LLVMExpressionNode srcB = this.getOperandLoad(dstType, b);
        LLVMExpressionNode srcA = this.getOperandLoad(dstType, a);
        LLVMAMD64WriteValueNode res = this.getRegisterStore((Type)dstType, dst);
        switch (operation) {
            case "imulw": {
                this.statements.add(LLVMAMD64ImulNodeFactory.LLVMAMD64Imulw3NodeGen.create(this.getFlagWrite(0L), this.getFlagWrite(2L), this.getFlagWrite(4L), this.getFlagWrite(6L), this.getFlagWrite(7L), this.getFlagWrite(11L), res, srcA, srcB));
                return;
            }
            case "imull": {
                this.statements.add(LLVMAMD64ImulNodeFactory.LLVMAMD64Imull3NodeGen.create(this.getFlagWrite(0L), this.getFlagWrite(2L), this.getFlagWrite(4L), this.getFlagWrite(6L), this.getFlagWrite(7L), this.getFlagWrite(11L), res, srcA, srcB));
                return;
            }
            case "imulq": {
                this.statements.add(LLVMAMD64ImulNodeFactory.LLVMAMD64Imulq3NodeGen.create(this.getFlagWrite(0L), this.getFlagWrite(2L), this.getFlagWrite(4L), this.getFlagWrite(6L), this.getFlagWrite(7L), this.getFlagWrite(11L), res, srcA, srcB));
                return;
            }
        }
        this.statements.add(LLVMUnsupportedInstructionNode.create(LLVMUnsupportedException.UnsupportedReason.INLINE_ASSEMBLER, operation));
    }

    void addFrameSlot(String reg, Type type) {
        if (!this.registers.contains(reg)) {
            this.registers.add(reg);
            FrameSlotKind kind = AsmFactory.computeFrameSlotKind(type);
            this.frameDescriptor.addFrameSlot((Object)reg, (Object)type, kind);
        }
    }

    private static FrameSlotKind computeFrameSlotKind(Type type) {
        if (type instanceof PrimitiveType) {
            PrimitiveType.PrimitiveKind primitiveKind = ((PrimitiveType)type).getPrimitiveKind();
            switch (primitiveKind) {
                case I8: 
                case I1: {
                    return FrameSlotKind.Byte;
                }
                case I32: {
                    return FrameSlotKind.Int;
                }
                case I64: {
                    return FrameSlotKind.Long;
                }
            }
        } else if (type instanceof PointerType) {
            return FrameSlotKind.Object;
        }
        throw new AsmParseException("unexpected type: " + type);
    }

    private static PrimitiveType.PrimitiveKind getPrimitiveKind(Argument arg) {
        if (!(arg.getType() instanceof PrimitiveType)) {
            throw new AsmParseException("cannot handle return type " + arg.getType());
        }
        PrimitiveType.PrimitiveKind primitiveKind = ((PrimitiveType)arg.getType()).getPrimitiveKind();
        return primitiveKind;
    }

    private void getArguments() {
        LLVMStoreNode[] writeNodes = LLVMStoreNode.NO_STORES;
        LLVMExpressionNode[] valueNodes = LLVMExpressionNode.NO_EXPRESSIONS;
        if (this.retType instanceof StructureType) {
            writeNodes = new LLVMStoreNode[this.retTypes.length];
            valueNodes = new LLVMExpressionNode[this.retTypes.length];
        }
        HashSet<String> todoRegisters = new HashSet<String>(this.registers);
        for (Argument arg : this.argInfo) {
            LLVMArgNode argnode;
            FrameSlot slot;
            if (arg.isOutput()) {
                slot = null;
                if (arg.isRegister()) {
                    slot = this.getRegisterSlot(arg.getRegister());
                    LLVMAMD64ReadRegisterNode register = LLVMAMD64ReadRegisterNodeGen.create(slot);
                    if (this.retType instanceof StructureType) {
                        assert (this.retTypes[arg.getOutIndex()] == arg.getType());
                        if (arg.getType() instanceof PointerType) {
                            valueNodes[arg.getOutIndex()] = LLVMToAddressNodeGen.create(register);
                            writeNodes[arg.getOutIndex()] = LLVMPointerStoreNodeGen.create(null, null);
                        } else {
                            PrimitiveType.PrimitiveKind primitiveKind = AsmFactory.getPrimitiveKind(arg);
                            switch (primitiveKind) {
                                case I8: {
                                    valueNodes[arg.getOutIndex()] = CommonNodeFactory.createSignedCast((LLVMExpressionNode)register, PrimitiveType.I8);
                                    writeNodes[arg.getOutIndex()] = LLVMI8StoreNodeGen.create(null, null);
                                    break;
                                }
                                case I16: {
                                    valueNodes[arg.getOutIndex()] = CommonNodeFactory.createSignedCast((LLVMExpressionNode)register, PrimitiveType.I16);
                                    writeNodes[arg.getOutIndex()] = LLVMI16StoreNodeGen.create(null, null);
                                    break;
                                }
                                case I32: {
                                    valueNodes[arg.getOutIndex()] = CommonNodeFactory.createSignedCast((LLVMExpressionNode)register, PrimitiveType.I32);
                                    writeNodes[arg.getOutIndex()] = LLVMI32StoreNodeGen.create(null, null);
                                    break;
                                }
                                case I64: {
                                    valueNodes[arg.getOutIndex()] = register;
                                    writeNodes[arg.getOutIndex()] = LLVMI64StoreNodeGen.create(null, null);
                                    break;
                                }
                                default: {
                                    throw AsmFactory.invalidOperandType(arg.getType());
                                }
                            }
                        }
                    } else {
                        this.result = this.castResult(register);
                    }
                } else {
                    assert (arg.isMemory());
                    slot = this.getArgumentSlot(arg.getIndex(), this.argTypes.get(arg.getOutIndex()));
                    argnode = LLVMArgNodeGen.create(arg.getOutIndex());
                    this.arguments.add(LLVMWriteNodeFactory.LLVMWritePointerNodeGen.create(slot, argnode));
                }
            }
            if (!arg.isInput()) continue;
            slot = null;
            if (arg.isRegister()) {
                String reg = arg.isAnonymous() ? arg.getRegister() : AsmRegisterOperand.getBaseRegister(arg.getRegister());
                slot = this.getRegisterSlot(reg);
                todoRegisters.remove(reg);
                LLVMArgNode argnode2 = LLVMArgNodeGen.create(arg.getInIndex());
                if (this.argTypes.get(arg.getInIndex()) instanceof PointerType) {
                    this.arguments.add(LLVMWriteNodeFactory.LLVMWritePointerNodeGen.create(slot, argnode2));
                } else if (this.argTypes.get(arg.getInIndex()) instanceof VectorType) {
                    this.arguments.add(LLVMWriteNodeFactory.LLVMWriteVectorNodeGen.create(slot, argnode2));
                } else {
                    LLVMExpressionNode node = CommonNodeFactory.createSignedCast((LLVMExpressionNode)argnode2, PrimitiveType.I64);
                    this.arguments.add(LLVMWriteNodeFactory.LLVMWriteI64NodeGen.create(slot, node));
                }
            }
            slot = this.getArgumentSlot(arg.getIndex(), this.argTypes.get(arg.getInIndex()));
            argnode = LLVMArgNodeGen.create(arg.getInIndex());
            if (arg.getType() instanceof PrimitiveType) {
                LLVMExpressionNode node = CommonNodeFactory.createSignedCast((LLVMExpressionNode)argnode, PrimitiveType.I64);
                this.arguments.add(LLVMWriteNodeFactory.LLVMWriteI64NodeGen.create(slot, node));
                continue;
            }
            if (arg.getType() instanceof VectorType) {
                this.arguments.add(LLVMWriteNodeFactory.LLVMWriteVectorNodeGen.create(slot, argnode));
                continue;
            }
            if (arg.getType() instanceof PointerType) {
                this.arguments.add(LLVMWriteNodeFactory.LLVMWritePointerNodeGen.create(slot, argnode));
                continue;
            }
            throw AsmFactory.invalidOperandType(arg.getType());
        }
        if (this.retType instanceof StructureType) {
            LLVMArgNode addrArg = LLVMArgNodeGen.create(1);
            FrameSlot slot = this.frameDescriptor.addFrameSlot((Object)"returnValue", null, FrameSlotKind.Object);
            LLVMWriteNode.LLVMWritePointerNode writeAddr = LLVMWriteNodeFactory.LLVMWritePointerNodeGen.create(slot, addrArg);
            this.statements.add(writeAddr);
            LLVMReadNode.LLVMAddressReadNode addr = LLVMReadNodeFactory.LLVMAddressReadNodeGen.create(slot);
            this.result = StructLiteralNodeGen.create(this.retOffsets, writeNodes, valueNodes, addr);
        }
        todoRegisters.remove("rsp");
        for (String register : todoRegisters) {
            if (register.startsWith("$")) continue;
            LLVMAMD64ImmNode.LLVMAMD64I64Node node = LLVMAMD64ImmNodeFactory.LLVMAMD64I64NodeGen.create(0L);
            FrameSlot slot = this.getRegisterSlot(register);
            this.arguments.add(LLVMWriteNodeFactory.LLVMWriteI64NodeGen.create(slot, node));
        }
        LLVMAMD64ImmNode.LLVMAMD64I1Node zero = LLVMAMD64ImmNodeFactory.LLVMAMD64I1NodeGen.create(false);
        this.arguments.add(LLVMWriteNodeFactory.LLVMWriteI1NodeGen.create(this.getFlagSlot(0L), zero));
        this.arguments.add(LLVMWriteNodeFactory.LLVMWriteI1NodeGen.create(this.getFlagSlot(2L), zero));
        this.arguments.add(LLVMWriteNodeFactory.LLVMWriteI1NodeGen.create(this.getFlagSlot(4L), zero));
        this.arguments.add(LLVMWriteNodeFactory.LLVMWriteI1NodeGen.create(this.getFlagSlot(6L), zero));
        this.arguments.add(LLVMWriteNodeFactory.LLVMWriteI1NodeGen.create(this.getFlagSlot(7L), zero));
        this.arguments.add(LLVMWriteNodeFactory.LLVMWriteI1NodeGen.create(this.getFlagSlot(11L), zero));
        LLVMArgNode stackPointer = LLVMArgNodeGen.create(0);
        FrameSlot stackSlot = this.frameDescriptor.addFrameSlot((Object)"<stackpointer>");
        this.frameDescriptor.setFrameSlotKind(stackSlot, FrameSlotKind.Object);
        this.arguments.add(LLVMWriteNodeFactory.LLVMWritePointerNodeGen.create(this.frameDescriptor.findFrameSlot((Object)"<stackpointer>"), stackPointer));
        this.arguments.add(LLVMWriteNodeFactory.LLVMWritePointerNodeGen.create(this.getRegisterSlot("rsp"), stackPointer));
        assert (this.retType instanceof VoidType || this.retType != null);
    }

    private LLVMExpressionNode castResult(LLVMExpressionNode register) {
        if (this.retType instanceof PointerType) {
            return LLVMToAddressNodeGen.create(register);
        }
        return CommonNodeFactory.createSignedCast(register, this.retType);
    }

    private boolean isLeaPointer(AsmOperand operand) {
        if (operand instanceof AsmArgumentOperand) {
            AsmArgumentOperand op = (AsmArgumentOperand)operand;
            Argument info = this.argInfo.get(op.getIndex());
            if (info.isMemory()) {
                return true;
            }
            throw new AsmParseException("not a pointer");
        }
        if (operand instanceof AsmMemoryOperand) {
            AsmMemoryOperand op = (AsmMemoryOperand)operand;
            AsmOperand base = op.getBase();
            AsmOperand offset = op.getOffset();
            return base != null || offset != null;
        }
        throw new AsmParseException("unsupported operand: " + operand);
    }

    private LLVMExpressionNode getOperandAddress(AsmOperand operand) {
        return this.getOperandAddress(operand.getType(), operand);
    }

    private LLVMExpressionNode getOperandAddress(Type type, AsmOperand operand) {
        if (operand instanceof AsmRegisterOperand) {
            AsmRegisterOperand op = (AsmRegisterOperand)operand;
            FrameSlot frame = this.getRegisterSlot(op.getBaseRegister());
            if (type instanceof PointerType) {
                return LLVMReadNodeFactory.LLVMAddressReadNodeGen.create(frame);
            }
            throw new AsmParseException("not a pointer");
        }
        if (operand instanceof AsmArgumentOperand) {
            AsmArgumentOperand op = (AsmArgumentOperand)operand;
            Argument info = this.argInfo.get(op.getIndex());
            FrameSlot frame = this.getArgumentSlot(op.getIndex(), type);
            if (info.isMemory()) {
                return LLVMReadNodeFactory.LLVMAddressReadNodeGen.create(frame);
            }
            throw new AsmParseException("not a pointer");
        }
        if (operand instanceof AsmMemoryOperand) {
            LLVMAMD64AddressComputationNode address;
            AsmMemoryOperand op = (AsmMemoryOperand)operand;
            int displacement = op.getDisplacement();
            AsmOperand base = op.getBase();
            AsmOperand offset = op.getOffset();
            int shift = op.getShift();
            assert (op.getSegment() == null || "%fs".equals(op.getSegment()));
            LLVMAMD64GetTlsNode segment = null;
            if (op.getSegment() != null) {
                segment = LLVMAMD64GetTlsNodeGen.create();
            }
            if (base == null) {
                if (offset != null) {
                    LLVMExpressionNode offsetNode = this.getOperandLoad(null, offset);
                    if (op.getSegment() != null) {
                        return LLVMAMD64AddressComputationNodeFactory.LLVMAMD64AddressOffsetComputationNodeGen.create(displacement, shift, segment, offsetNode);
                    }
                    return LLVMAMD64AddressComputationNodeFactory.LLVMAMD64AddressNoBaseOffsetComputationNodeGen.create(displacement, shift, offsetNode);
                }
                if (op.getSegment() != null) {
                    return LLVMAMD64AddressComputationNodeFactory.LLVMAMD64AddressDisplacementComputationNodeGen.create(displacement, segment);
                }
                if (type instanceof PrimitiveType) {
                    switch (((PrimitiveType)type).getPrimitiveKind()) {
                        case I16: {
                            return LLVMAMD64ImmNodeFactory.LLVMAMD64I16NodeGen.create((short)displacement);
                        }
                        case I32: {
                            return LLVMAMD64ImmNodeFactory.LLVMAMD64I32NodeGen.create(displacement);
                        }
                        case I64: {
                            return LLVMAMD64ImmNodeFactory.LLVMAMD64I64NodeGen.create(displacement);
                        }
                    }
                    throw new AsmParseException("unknown type: " + type);
                }
                if (type instanceof PointerType) {
                    return LLVMAMD64ImmNodeFactory.LLVMAMD64I64NodeGen.create(displacement);
                }
                throw new AsmParseException("invalid type: " + type);
            }
            LLVMExpressionNode baseAddress = this.getOperandLoad(new PointerType(type), base);
            if (offset == null) {
                address = LLVMAMD64AddressComputationNodeFactory.LLVMAMD64AddressDisplacementComputationNodeGen.create(displacement, baseAddress);
            } else {
                LLVMExpressionNode offsetNode = this.getOperandLoad(null, offset);
                address = LLVMAMD64AddressComputationNodeFactory.LLVMAMD64AddressOffsetComputationNodeGen.create(displacement, shift, baseAddress, offsetNode);
            }
            if (op.getSegment() != null) {
                address = LLVMAMD64AddressComputationNodeFactory.LLVMAMD64AddressSegmentComputationNodeGen.create(address, segment);
            }
            return address;
        }
        throw new AsmParseException("unsupported operand: " + operand);
    }

    private LLVMExpressionNode getOperandLoad(Type typeHint, AsmOperand operand) {
        Type type;
        Type type2 = type = typeHint == null ? operand.getType() : typeHint;
        if (operand instanceof AsmRegisterOperand) {
            AsmRegisterOperand op = (AsmRegisterOperand)operand;
            FrameSlot frame = this.getRegisterSlot(op.getBaseRegister());
            LLVMAMD64ReadRegisterNode register = LLVMAMD64ReadRegisterNodeGen.create(frame);
            int shift = op.getShift();
            assert (type instanceof PointerType || type == op.getType());
            if (type instanceof PointerType) {
                switch (((PrimitiveType)op.getType()).getPrimitiveKind()) {
                    case I8: {
                        return CommonNodeFactory.createSignedCast((LLVMExpressionNode)register, PrimitiveType.I8);
                    }
                    case I16: {
                        return CommonNodeFactory.createSignedCast((LLVMExpressionNode)register, PrimitiveType.I16);
                    }
                    case I32: {
                        return CommonNodeFactory.createSignedCast((LLVMExpressionNode)register, PrimitiveType.I32);
                    }
                    case I64: {
                        return LLVMAMD64ReadAddressNodeGen.create(frame);
                    }
                }
                throw AsmFactory.unsupportedOperandType(type);
            }
            switch (((PrimitiveType)op.getType()).getPrimitiveKind()) {
                case I8: {
                    return LLVMAMD64ToI8NodeFactory.LLVMAMD64I64ToI8NodeGen.create(shift, register);
                }
                case I16: {
                    return CommonNodeFactory.createSignedCast((LLVMExpressionNode)register, PrimitiveType.I16);
                }
                case I32: {
                    return CommonNodeFactory.createSignedCast((LLVMExpressionNode)register, PrimitiveType.I32);
                }
                case I64: {
                    return register;
                }
            }
            throw AsmFactory.unsupportedOperandType(type);
        }
        if (operand instanceof AsmImmediateOperand) {
            AsmImmediateOperand op = (AsmImmediateOperand)operand;
            if (op.isLabel()) {
                throw new AsmParseException("labels not supported");
            }
            switch (((PrimitiveType)type).getPrimitiveKind()) {
                case I8: {
                    return LLVMAMD64ImmNodeFactory.LLVMAMD64I8NodeGen.create((byte)op.getValue());
                }
                case I16: {
                    return LLVMAMD64ImmNodeFactory.LLVMAMD64I16NodeGen.create((short)op.getValue());
                }
                case I32: {
                    return LLVMAMD64ImmNodeFactory.LLVMAMD64I32NodeGen.create((int)op.getValue());
                }
                case I64: {
                    return LLVMAMD64ImmNodeFactory.LLVMAMD64I64NodeGen.create(op.getValue());
                }
            }
            throw AsmFactory.unsupportedOperandType(type);
        }
        if (operand instanceof AsmArgumentOperand) {
            AsmArgumentOperand op = (AsmArgumentOperand)operand;
            Argument info = this.argInfo.get(op.getIndex());
            FrameSlot frame = this.getArgumentSlot(op.getIndex(), type);
            if (info.isMemory()) {
                if (type instanceof PointerType) {
                    return LLVMDirectLoadNodeFactory.LLVMPointerDirectLoadNodeGen.create(LLVMReadNodeFactory.LLVMAddressReadNodeGen.create(frame));
                }
                switch (((PrimitiveType)type).getPrimitiveKind()) {
                    case I8: {
                        return LLVMI8LoadNodeGen.create(LLVMReadNodeFactory.LLVMAddressReadNodeGen.create(frame));
                    }
                    case I16: {
                        return LLVMI16LoadNodeGen.create(LLVMReadNodeFactory.LLVMAddressReadNodeGen.create(frame));
                    }
                    case I32: {
                        return LLVMI32LoadNodeGen.create(LLVMReadNodeFactory.LLVMAddressReadNodeGen.create(frame));
                    }
                    case I64: {
                        return LLVMI64LoadNodeGen.create(LLVMReadNodeFactory.LLVMAddressReadNodeGen.create(frame));
                    }
                }
                throw AsmFactory.unsupportedOperandType(type);
            }
            if (info.isRegister()) {
                frame = this.getRegisterSlot(info.getRegister());
                if (type instanceof PointerType) {
                    return LLVMAMD64ReadAddressNodeGen.create(frame);
                }
                LLVMAMD64ReadRegisterNode register = LLVMAMD64ReadRegisterNodeGen.create(frame);
                return CommonNodeFactory.createSignedCast((LLVMExpressionNode)register, type);
            }
            if (type instanceof PointerType) {
                return LLVMAMD64ReadAddressNodeGen.create(frame);
            }
            LLVMAMD64ReadRegisterNode register = LLVMAMD64ReadRegisterNodeGen.create(frame);
            PrimitiveType primitiveType = (PrimitiveType)type;
            return CommonNodeFactory.createSignedCast((LLVMExpressionNode)register, primitiveType);
        }
        if (operand instanceof AsmMemoryOperand) {
            LLVMExpressionNode address = this.getOperandAddress(operand);
            LLVMToAddressNode addr = LLVMToAddressNodeGen.create(address);
            if (type instanceof PrimitiveType) {
                switch (((PrimitiveType)type).getPrimitiveKind()) {
                    case I8: {
                        return LLVMI8LoadNodeGen.create(addr);
                    }
                    case I16: {
                        return LLVMI16LoadNodeGen.create(addr);
                    }
                    case I32: {
                        return LLVMI32LoadNodeGen.create(addr);
                    }
                    case I64: {
                        return LLVMI64LoadNodeGen.create(addr);
                    }
                }
                throw AsmFactory.unsupportedOperandType(type);
            }
            if (type instanceof PointerType) {
                return LLVMDirectLoadNodeFactory.LLVMPointerDirectLoadNodeGen.create(addr);
            }
            throw AsmFactory.unsupportedOperandType(type);
        }
        throw new AsmParseException("unsupported operand: " + operand);
    }

    private LLVMStatementNode getOperandStore(Type type, AsmOperand operand, LLVMExpressionNode from) {
        if (operand instanceof AsmRegisterOperand) {
            AsmRegisterOperand op = (AsmRegisterOperand)operand;
            FrameSlot frame = this.getRegisterSlot(op.getBaseRegister());
            LLVMAMD64ReadRegisterNode register = LLVMAMD64ReadRegisterNodeGen.create(frame);
            int shift = op.getShift();
            LLVMExpressionNode out = null;
            assert (type instanceof PointerType && op.getType() == PrimitiveType.I64 || op.getType() instanceof PointerType && type == PrimitiveType.I64 || type == op.getType());
            switch (((PrimitiveType)op.getType()).getPrimitiveKind()) {
                case I8: {
                    out = LLVMAMD64ToRegisterNodeFactory.LLVMI8ToR64NodeGen.create(shift, register, from);
                    break;
                }
                case I16: {
                    out = LLVMAMD64ToRegisterNodeFactory.LLVMI16ToR64NodeGen.create(register, from);
                    break;
                }
                case I32: {
                    out = LLVMAMD64ToRegisterNodeFactory.LLVMI32ToR64NodeGen.create(from);
                    break;
                }
                case I64: {
                    out = from;
                    break;
                }
                default: {
                    throw new AsmParseException("unsupported operand type: " + op.getType());
                }
            }
            return LLVMWriteNodeFactory.LLVMWriteI64NodeGen.create(frame, out);
        }
        if (operand instanceof AsmArgumentOperand) {
            AsmArgumentOperand op = (AsmArgumentOperand)operand;
            Argument info = this.argInfo.get(op.getIndex());
            if (info.isMemory()) {
                LLVMExpressionNode address = info.getAddress();
                if (type instanceof PrimitiveType) {
                    switch (((PrimitiveType)type).getPrimitiveKind()) {
                        case I8: {
                            return LLVMI8StoreNodeGen.create(address, from);
                        }
                        case I16: {
                            return LLVMI16StoreNodeGen.create(address, from);
                        }
                        case I32: {
                            return LLVMI32StoreNodeGen.create(address, from);
                        }
                        case I64: {
                            return LLVMI64StoreNodeGen.create(address, from);
                        }
                    }
                    throw AsmFactory.unsupportedOperandType(type);
                }
                throw AsmFactory.unsupportedOperandType(type);
            }
            if (info.isRegister()) {
                FrameSlot frame = this.getRegisterSlot(info.getRegister());
                LLVMAMD64ReadRegisterNode register = LLVMAMD64ReadRegisterNodeGen.create(frame);
                LLVMExpressionNode out = null;
                if (type instanceof PointerType || info.getType() instanceof PointerType) {
                    return LLVMAMD64WriteAddressRegisterNodeGen.create(from, frame);
                }
                switch (((PrimitiveType)type).getPrimitiveKind()) {
                    case I8: {
                        out = LLVMAMD64ToRegisterNodeFactory.LLVMI8ToR64NodeGen.create(0, register, from);
                        break;
                    }
                    case I16: {
                        out = LLVMAMD64ToRegisterNodeFactory.LLVMI16ToR64NodeGen.create(register, from);
                        break;
                    }
                    case I32: {
                        out = LLVMAMD64ToRegisterNodeFactory.LLVMI32ToR64NodeGen.create(from);
                        break;
                    }
                    case I64: {
                        out = from;
                        break;
                    }
                    default: {
                        throw AsmFactory.unsupportedOperandType(type);
                    }
                }
                return LLVMWriteNodeFactory.LLVMWriteI64NodeGen.create(frame, out);
            }
            throw new AssertionError((Object)("this should not happen; " + info));
        }
        if (operand instanceof AsmMemoryOperand) {
            LLVMExpressionNode address = this.getOperandAddress(operand);
            switch (((PrimitiveType)type).getPrimitiveKind()) {
                case I8: {
                    return LLVMI8StoreNodeGen.create(address, from);
                }
                case I16: {
                    return LLVMI16StoreNodeGen.create(address, from);
                }
                case I32: {
                    return LLVMI32StoreNodeGen.create(address, from);
                }
                case I64: {
                    return LLVMI64StoreNodeGen.create(address, from);
                }
            }
            throw AsmFactory.unsupportedOperandType(type);
        }
        throw AsmFactory.unsupportedOperandType(operand.getType());
    }

    private LLVMAMD64Target getTarget(Type type, AsmOperand operand) {
        if (operand instanceof AsmRegisterOperand) {
            AsmRegisterOperand op = (AsmRegisterOperand)operand;
            FrameSlot frame = this.getRegisterSlot(op.getBaseRegister());
            int shift = op.getShift();
            assert (type == op.getType());
            switch (((PrimitiveType)op.getType()).getPrimitiveKind()) {
                case I8: {
                    return new LLVMAMD64Target(frame, shift);
                }
                case I16: 
                case I32: 
                case I64: {
                    return new LLVMAMD64Target(frame);
                }
            }
            throw AsmFactory.unsupportedOperandType(op.getType());
        }
        if (operand instanceof AsmArgumentOperand) {
            AsmArgumentOperand op = (AsmArgumentOperand)operand;
            Argument info = this.argInfo.get(op.getIndex());
            if (info.isMemory()) {
                LLVMExpressionNode address = info.getAddress();
                if (type instanceof PointerType) {
                    return new LLVMAMD64Target(address);
                }
                switch (((PrimitiveType)type).getPrimitiveKind()) {
                    case I16: 
                    case I32: 
                    case I64: 
                    case I8: {
                        return new LLVMAMD64Target(address);
                    }
                }
                throw AsmFactory.unsupportedOperandType(type);
            }
            if (info.isRegister()) {
                FrameSlot frame = this.getRegisterSlot(info.getRegister());
                if (type instanceof PointerType || info.getType() instanceof PointerType) {
                    return new LLVMAMD64Target(frame);
                }
                switch (((PrimitiveType)type).getPrimitiveKind()) {
                    case I16: 
                    case I32: 
                    case I64: 
                    case I8: {
                        return new LLVMAMD64Target(frame);
                    }
                }
                throw AsmFactory.unsupportedOperandType(type);
            }
            throw new AssertionError((Object)("this should not happen; " + info));
        }
        throw AsmFactory.unsupportedOperandType(operand.getType());
    }

    private LLVMAMD64Target getRegisterTarget(Type type, AsmOperand operand) {
        if (operand instanceof AsmRegisterOperand) {
            AsmRegisterOperand op = (AsmRegisterOperand)operand;
            return this.getRegisterTarget(type, op.getRegister());
        }
        if (operand instanceof AsmArgumentOperand) {
            AsmArgumentOperand op = (AsmArgumentOperand)operand;
            Argument info = this.argInfo.get(op.getIndex());
            if (info.isRegister()) {
                return this.getRegisterTarget(type, info.getRegister());
            }
            throw new AsmParseException("unsupported operand: " + info);
        }
        throw AsmFactory.unsupportedOperandType(operand.getType());
    }

    private LLVMAMD64Target getRegisterTarget(String name) {
        AsmRegisterOperand op = new AsmRegisterOperand(name);
        Type type = name.startsWith(TEMP_REGISTER_PREFIX) ? PrimitiveType.I64 : op.getType();
        return this.getRegisterTarget(type, name);
    }

    private LLVMAMD64Target getRegisterTarget(Type type, String name) {
        AsmRegisterOperand op = new AsmRegisterOperand(name);
        FrameSlot frame = this.getRegisterSlot(name);
        switch (((PrimitiveType)type).getPrimitiveKind()) {
            case I8: {
                return new LLVMAMD64Target(frame, op.getShift());
            }
            case I16: 
            case I32: 
            case I64: {
                return new LLVMAMD64Target(frame);
            }
        }
        throw AsmFactory.unsupportedOperandType(type);
    }

    private LLVMAMD64WriteValueNode getStore(Type type, AsmOperand operand) {
        return LLVMAMD64WriteValueNodeGen.create(this.getTarget(type, operand));
    }

    private LLVMAMD64WriteValueNode getRegisterStore(Type type, AsmOperand operand) {
        return LLVMAMD64WriteValueNodeGen.create(this.getRegisterTarget(type, operand));
    }

    private LLVMAMD64WriteValueNode getRegisterStore(Type type, String name) {
        return LLVMAMD64WriteValueNodeGen.create(this.getRegisterTarget(type, name));
    }

    private LLVMAMD64WriteValueNode getRegisterStore(String name) {
        return LLVMAMD64WriteValueNodeGen.create(this.getRegisterTarget(name));
    }

    private FrameSlot getRegisterSlot(String name) {
        if (name.startsWith(TEMP_REGISTER_PREFIX)) {
            this.addFrameSlot(name, PrimitiveType.I64);
            return this.frameDescriptor.findFrameSlot((Object)name);
        }
        AsmRegisterOperand op = new AsmRegisterOperand(name);
        String baseRegister = op.getBaseRegister();
        this.addFrameSlot(baseRegister, PrimitiveType.I64);
        FrameSlot frame = this.frameDescriptor.findFrameSlot((Object)baseRegister);
        return frame;
    }

    private static String getArgumentName(int index) {
        return "$" + index;
    }

    private FrameSlot getArgumentSlot(int index, Type type) {
        Argument info = this.argInfo.get(index);
        String name = AsmFactory.getArgumentName(index);
        if (type instanceof StructureType || type instanceof PointerType) {
            this.addFrameSlot(name, info.getType());
        } else {
            this.addFrameSlot(name, PrimitiveType.I64);
        }
        return this.frameDescriptor.findFrameSlot((Object)name);
    }

    private static String getFlagName(long flag) {
        return "$flag_" + flag;
    }

    private FrameSlot getFlagSlot(long flag) {
        String name = AsmFactory.getFlagName(flag);
        this.addFrameSlot(name, PrimitiveType.I1);
        return this.frameDescriptor.findFrameSlot((Object)name);
    }

    private LLVMExpressionNode getFlag(long flag) {
        return LLVMReadNodeFactory.LLVMI1ReadNodeGen.create(this.getFlagSlot(flag));
    }

    private LLVMAMD64WriteBooleanNode getFlagWrite(long flag) {
        return new LLVMAMD64WriteBooleanNode(this.getFlagSlot(flag));
    }

    private LLVMAMD64UpdateFlagsNode.LLVMAMD64UpdatePZSFlagsNode getUpdatePZSFlagsNode() {
        return new LLVMAMD64UpdateFlagsNode.LLVMAMD64UpdatePZSFlagsNode(this.getFlagSlot(2L), this.getFlagSlot(6L), this.getFlagSlot(7L));
    }

    private LLVMAMD64UpdateFlagsNode.LLVMAMD64UpdatePZSOFlagsNode getUpdatePZSOFlagsNode() {
        return new LLVMAMD64UpdateFlagsNode.LLVMAMD64UpdatePZSOFlagsNode(this.getFlagSlot(2L), this.getFlagSlot(6L), this.getFlagSlot(7L), this.getFlagSlot(11L));
    }

    private LLVMAMD64UpdateFlagsNode.LLVMAMD64UpdateCPZSOFlagsNode getUpdateCPZSOFlagsNode() {
        return new LLVMAMD64UpdateFlagsNode.LLVMAMD64UpdateCPZSOFlagsNode(this.getFlagSlot(0L), this.getFlagSlot(2L), this.getFlagSlot(6L), this.getFlagSlot(7L), this.getFlagSlot(11L));
    }

    private LLVMAMD64UpdateFlagsNode.LLVMAMD64UpdateCPAZSOFlagsNode getUpdateCPAZSOFlagsNode() {
        return new LLVMAMD64UpdateFlagsNode.LLVMAMD64UpdateCPAZSOFlagsNode(this.getFlagSlot(0L), this.getFlagSlot(2L), this.getFlagSlot(4L), this.getFlagSlot(6L), this.getFlagSlot(7L), this.getFlagSlot(11L));
    }

    private class XchgOperands {
        public final LLVMExpressionNode srcA;
        public final LLVMExpressionNode srcB;
        public final LLVMAMD64WriteValueNode dst1;
        public final LLVMAMD64WriteValueNode dst2;
        public final LLVMAMD64WriteTupelNode dst;

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        XchgOperands(AsmOperand a, AsmOperand b, Type type) {
            if (b instanceof AsmRegisterOperand) {
                AsmRegisterOperand rb = (AsmRegisterOperand)b;
                this.srcA = AsmFactory.this.getOperandLoad(type, a);
                this.srcB = AsmFactory.this.getOperandLoad(type, b);
                this.dst1 = AsmFactory.this.getStore(type, a);
                this.dst2 = AsmFactory.this.getRegisterStore(rb.getRegister());
            } else if (a instanceof AsmRegisterOperand) {
                AsmRegisterOperand ra = (AsmRegisterOperand)a;
                this.srcA = AsmFactory.this.getOperandLoad(type, b);
                this.srcB = AsmFactory.this.getOperandLoad(type, a);
                this.dst1 = AsmFactory.this.getStore(type, b);
                this.dst2 = AsmFactory.this.getRegisterStore(ra.getRegister());
            } else {
                if (!(a instanceof AsmArgumentOperand)) throw new AsmParseException("not implemented");
                AsmArgumentOperand arg = (AsmArgumentOperand)a;
                Argument info = (Argument)AsmFactory.this.argInfo.get(arg.getIndex());
                if (!info.isRegister()) throw new AsmParseException("not implemented");
                this.srcA = AsmFactory.this.getOperandLoad(type, b);
                this.srcB = AsmFactory.this.getOperandLoad(type, a);
                this.dst1 = AsmFactory.this.getStore(type, b);
                this.dst2 = AsmFactory.this.getRegisterStore(type, info.getRegister());
            }
            this.dst = LLVMAMD64WriteTupelNodeGen.create(this.dst1, this.dst2);
        }
    }
}

