/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.parser;

import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.RootCallTarget;
import com.oracle.truffle.api.Truffle;
import com.oracle.truffle.api.frame.FrameDescriptor;
import com.oracle.truffle.api.frame.FrameSlot;
import com.oracle.truffle.api.frame.FrameSlotKind;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeInterface;
import com.oracle.truffle.api.nodes.RepeatingNode;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.api.source.Source;
import com.oracle.truffle.llvm.parser.LLVMLivenessAnalysis;
import com.oracle.truffle.llvm.parser.LLVMParserRuntime;
import com.oracle.truffle.llvm.parser.LLVMPhiManager;
import com.oracle.truffle.llvm.parser.metadata.debuginfo.DebugInfoFunctionProcessor;
import com.oracle.truffle.llvm.parser.metadata.debuginfo.SourceVariable;
import com.oracle.truffle.llvm.parser.model.SymbolImpl;
import com.oracle.truffle.llvm.parser.model.attributes.Attribute;
import com.oracle.truffle.llvm.parser.model.blocks.InstructionBlock;
import com.oracle.truffle.llvm.parser.model.functions.FunctionDefinition;
import com.oracle.truffle.llvm.parser.model.functions.FunctionParameter;
import com.oracle.truffle.llvm.parser.model.functions.LazyFunctionParser;
import com.oracle.truffle.llvm.parser.model.symbols.instructions.DbgDeclareInstruction;
import com.oracle.truffle.llvm.parser.model.symbols.instructions.DbgValueInstruction;
import com.oracle.truffle.llvm.parser.model.symbols.instructions.Instruction;
import com.oracle.truffle.llvm.parser.nodes.LLVMBitcodeInstructionVisitor;
import com.oracle.truffle.llvm.parser.nodes.LLVMRuntimeDebugInformation;
import com.oracle.truffle.llvm.parser.nodes.LLVMSymbolReadResolver;
import com.oracle.truffle.llvm.parser.util.LLVMControlFlowGraph;
import com.oracle.truffle.llvm.runtime.CommonNodeFactory;
import com.oracle.truffle.llvm.runtime.GetStackSpaceFactory;
import com.oracle.truffle.llvm.runtime.LLVMContext;
import com.oracle.truffle.llvm.runtime.LLVMFunctionCode;
import com.oracle.truffle.llvm.runtime.NodeFactory;
import com.oracle.truffle.llvm.runtime.datalayout.DataLayout;
import com.oracle.truffle.llvm.runtime.debug.scope.LLVMSourceLocation;
import com.oracle.truffle.llvm.runtime.debug.type.LLVMSourceFunctionType;
import com.oracle.truffle.llvm.runtime.memory.LLVMStack;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMControlFlowNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMExpressionNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMLoadNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMStatementNode;
import com.oracle.truffle.llvm.runtime.nodes.base.LLVMBasicBlockNode;
import com.oracle.truffle.llvm.runtime.nodes.memory.LLVMUnpackVarargsNode;
import com.oracle.truffle.llvm.runtime.nodes.memory.LLVMUnpackVarargsNodeGen;
import com.oracle.truffle.llvm.runtime.options.SulongEngineOption;
import com.oracle.truffle.llvm.runtime.types.AggregateType;
import com.oracle.truffle.llvm.runtime.types.ArrayType;
import com.oracle.truffle.llvm.runtime.types.PointerType;
import com.oracle.truffle.llvm.runtime.types.PrimitiveType;
import com.oracle.truffle.llvm.runtime.types.StructureType;
import com.oracle.truffle.llvm.runtime.types.Type;
import com.oracle.truffle.llvm.runtime.types.symbols.SSAValue;
import java.io.PrintWriter;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.graalvm.options.OptionValues;

public class LazyToTruffleConverterImpl
implements LLVMFunctionCode.LazyToTruffleConverter {
    private static final String LOOP_SUCCESSOR_FRAME_ID = "<loop successor>";
    private final LLVMParserRuntime runtime;
    private final FunctionDefinition method;
    private final Source source;
    private final LazyFunctionParser parser;
    private final DebugInfoFunctionProcessor diProcessor;
    private final DataLayout dataLayout;
    private RootCallTarget resolved;

    LazyToTruffleConverterImpl(LLVMParserRuntime runtime, FunctionDefinition method, Source source, LazyFunctionParser parser, DebugInfoFunctionProcessor diProcessor, DataLayout dataLayout) {
        this.runtime = runtime;
        this.method = method;
        this.source = source;
        this.parser = parser;
        this.diProcessor = diProcessor;
        this.resolved = null;
        this.dataLayout = dataLayout;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RootCallTarget convert() {
        CompilerAsserts.neverPartOfCompilation();
        LazyToTruffleConverterImpl lazyToTruffleConverterImpl = this;
        synchronized (lazyToTruffleConverterImpl) {
            if (this.resolved == null) {
                this.resolved = this.generateCallTarget();
            }
            return this.resolved;
        }
    }

    private RootCallTarget generateCallTarget() {
        LLVMContext context = this.runtime.getContext();
        NodeFactory nodeFactory = this.runtime.getNodeFactory();
        OptionValues options = context.getEnv().getOptions();
        String printASTOption = (String)options.get(SulongEngineOption.PRINT_AST);
        boolean printAST = false;
        if (!printASTOption.isEmpty()) {
            String[] regexes;
            for (String regex : regexes = printASTOption.split(",")) {
                if (!this.method.getName().matches(regex)) continue;
                printAST = true;
                System.out.println("\n========== " + this.method.getName() + "\n");
                break;
            }
        }
        this.parser.parse(this.diProcessor, this.source, this.runtime);
        Map<InstructionBlock, List<LLVMPhiManager.Phi>> phis = LLVMPhiManager.getPhis(this.method);
        LLVMStack.UniquesRegion uniquesRegion = new LLVMStack.UniquesRegion();
        GetStackSpaceFactory getStackSpaceFactory = GetStackSpaceFactory.createGetUniqueStackSpaceFactory(uniquesRegion);
        LLVMLivenessAnalysis.LLVMLivenessAnalysisResult liveness = LLVMLivenessAnalysis.computeLiveness(phis, this.method, this.runtime.getContext().lifetimeAnalysisStream());
        FrameDescriptor frame = new FrameDescriptor();
        LLVMSymbolReadResolver symbols = new LLVMSymbolReadResolver(this.runtime, frame, getStackSpaceFactory, this.dataLayout, (Boolean)options.get(SulongEngineOption.LL_DEBUG));
        frame.addFrameSlot((Object)"<function exception value>", null, FrameSlotKind.Object);
        frame.addFrameSlot((Object)"<stackpointer>", (Object)PointerType.VOID, FrameSlotKind.Object);
        for (FunctionParameter parameter : this.method.getParameters()) {
            symbols.findOrAddFrameSlot(frame, parameter);
        }
        HashSet<Integer> neededForDebug = this.getDebugValues();
        boolean initDebugValues = true;
        LLVMRuntimeDebugInformation info = new LLVMRuntimeDebugInformation(this.method.getBlocks().size());
        LLVMBasicBlockNode[] blockNodes = new LLVMBasicBlockNode[this.method.getBlocks().size()];
        for (InstructionBlock block : this.method.getBlocks()) {
            List<LLVMPhiManager.Phi> blockPhis = phis.get(block);
            ArrayList<LLVMLivenessAnalysis.NullerInformation> blockNullerInfos = liveness.getNullableWithinBlock()[block.getBlockIndex()];
            LLVMBitcodeInstructionVisitor visitor = new LLVMBitcodeInstructionVisitor(frame, uniquesRegion, blockPhis, this.method.getParameters().size(), symbols, context, this.runtime.getLibrary(), blockNullerInfos, neededForDebug, this.dataLayout, nodeFactory);
            if (initDebugValues) {
                for (SourceVariable variable : this.method.getSourceFunction().getVariables()) {
                    if (!variable.hasFragments()) continue;
                    visitor.initializeAggregateLocalVariable(variable);
                }
                initDebugValues = false;
            }
            for (int i = 0; i < block.getInstructionCount(); ++i) {
                visitor.setInstructionIndex(i);
                block.getInstruction(i).accept(visitor);
            }
            LLVMStatementNode[] nodes = visitor.finish();
            info.setBlockDebugInfo(block.getBlockIndex(), visitor.getDebugInfo());
            blockNodes[block.getBlockIndex()] = LLVMBasicBlockNode.createBasicBlockNode(options, nodes, visitor.getControlFlowNode(), block.getBlockIndex(), block.getName());
        }
        for (int j = 0; j < blockNodes.length; ++j) {
            FrameSlot[] nullableBeforeBlock = LazyToTruffleConverterImpl.getNullableFrameSlots(frame, liveness.getNullableBeforeBlock()[j]);
            FrameSlot[] nullableAfterBlock = LazyToTruffleConverterImpl.getNullableFrameSlots(frame, liveness.getNullableAfterBlock()[j]);
            blockNodes[j].setNullableFrameSlots(nullableBeforeBlock, nullableAfterBlock);
        }
        info.setBlocks(blockNodes);
        FrameSlot loopSuccessorSlot = null;
        if (((Boolean)context.getEnv().getOptions().get(SulongEngineOption.ENABLE_OSR)).booleanValue()) {
            LLVMControlFlowGraph cfg = new LLVMControlFlowGraph(this.method.getBlocks().toArray(FunctionDefinition.EMPTY));
            cfg.build();
            if (cfg.isReducible() && cfg.getCFGLoops().size() > 0) {
                loopSuccessorSlot = frame.addFrameSlot((Object)LOOP_SUCCESSOR_FRAME_ID, FrameSlotKind.Int);
                this.resolveLoops(blockNodes, cfg, frame, loopSuccessorSlot, info, options);
            }
        }
        LLVMSourceLocation location = this.method.getLexicalScope();
        LLVMStatementNode[] copyArgumentsToFrameArray = this.copyArgumentsToFrame(frame, symbols).toArray(LLVMStatementNode.NO_STATEMENTS);
        LLVMExpressionNode body = nodeFactory.createFunctionBlockNode(frame.findFrameSlot((Object)"<function exception value>"), blockNodes, uniquesRegion.build(), copyArgumentsToFrameArray, location, frame, loopSuccessorSlot, info);
        RootNode rootNode = nodeFactory.createFunctionStartNode(body, frame, this.method.getName(), this.method.getSourceName(), this.method.getParameters().size(), this.source, location);
        this.method.onAfterParse();
        if (printAST) {
            LazyToTruffleConverterImpl.printCompactTree((Node)rootNode);
            System.out.println();
        }
        return Truffle.getRuntime().createCallTarget(rootNode);
    }

    private HashSet<Integer> getDebugValues() {
        HashSet<Integer> neededForDebug = new HashSet<Integer>();
        for (InstructionBlock block : this.method.getBlocks()) {
            for (Instruction instruction : block.getInstructions()) {
                SymbolImpl value;
                if (instruction instanceof DbgValueInstruction) {
                    value = ((DbgValueInstruction)instruction).getValue();
                } else {
                    if (!(instruction instanceof DbgDeclareInstruction)) continue;
                    value = ((DbgDeclareInstruction)instruction).getValue();
                }
                if (!(value instanceof SSAValue)) continue;
                neededForDebug.add(((SSAValue)((Object)value)).getFrameIdentifier());
            }
        }
        return neededForDebug;
    }

    private static void printCompactTree(Node node) {
        LazyToTruffleConverterImpl.printCompactTree(new PrintWriter(System.out), null, (NodeInterface)node, null, 1);
    }

    private static void printCompactTree(PrintWriter p, NodeInterface parent, NodeInterface node, String fieldName, int level) {
        if (node == null) {
            return;
        }
        for (int i = 0; i < level; ++i) {
            p.print("  ");
        }
        if (parent == null) {
            p.println(node);
        } else {
            p.print(fieldName);
            p.print(" = ");
            p.println(node);
        }
        for (Class<?> c = node.getClass(); c != Object.class; c = c.getSuperclass()) {
            Field[] fields;
            for (Field field : fields = c.getDeclaredFields()) {
                NodeInterface[] value;
                if (Modifier.isStatic(field.getModifiers())) continue;
                if (NodeInterface.class.isAssignableFrom(field.getType())) {
                    try {
                        field.setAccessible(true);
                        value = (NodeInterface[])field.get(node);
                        if (value == null) continue;
                        LazyToTruffleConverterImpl.printCompactTree(p, node, (NodeInterface)value, field.getName(), level + 1);
                    }
                    catch (IllegalAccessException | IllegalArgumentException e) {
                        e.printStackTrace();
                    }
                    continue;
                }
                if (!NodeInterface[].class.isAssignableFrom(field.getType())) continue;
                try {
                    field.setAccessible(true);
                    value = (NodeInterface[])field.get(node);
                    if (value == null) continue;
                    for (int i = 0; i < value.length; ++i) {
                        LazyToTruffleConverterImpl.printCompactTree(p, node, value[i], field.getName() + "[" + i + "]", level + 1);
                    }
                }
                catch (IllegalAccessException | IllegalArgumentException e) {
                    e.printStackTrace();
                }
            }
        }
        p.flush();
    }

    private void resolveLoops(LLVMBasicBlockNode[] nodes, LLVMControlFlowGraph cfg, FrameDescriptor frame, FrameSlot loopSuccessorSlot, LLVMRuntimeDebugInformation info, OptionValues options) {
        LLVMBasicBlockNode[] originalBodyNodes = (LLVMBasicBlockNode[])nodes.clone();
        info.setBlocks(originalBodyNodes);
        for (LLVMControlFlowGraph.CFGLoop loop : cfg.getCFGLoops()) {
            int headerId = loop.getHeader().id;
            int[] indexMapping = new int[nodes.length];
            Arrays.fill(indexMapping, -1);
            ArrayList<LLVMBasicBlockNode> bodyNodes = new ArrayList<LLVMBasicBlockNode>();
            LLVMBasicBlockNode header = nodes[headerId];
            bodyNodes.add(header);
            indexMapping[headerId] = 0;
            int i = 1;
            for (LLVMControlFlowGraph.CFGBlock block : loop.getBody()) {
                bodyNodes.add(nodes[block.id]);
                indexMapping[block.id] = i++;
            }
            int[] loopSuccessors = loop.getSuccessorIDs();
            RepeatingNode loopBody = this.runtime.getNodeFactory().createLoopDispatchNode(frame.findFrameSlot((Object)"<function exception value>"), Collections.unmodifiableList(bodyNodes), originalBodyNodes, headerId, indexMapping, loopSuccessors, loopSuccessorSlot);
            LLVMControlFlowNode loopNode = this.runtime.getNodeFactory().createLoop(loopBody, loopSuccessors);
            nodes[headerId] = LLVMBasicBlockNode.createBasicBlockNode(options, new LLVMStatementNode[0], loopNode, headerId, "loopAt" + headerId);
            nodes[headerId].setNullableFrameSlots(header.nullableBefore, header.nullableAfter);
            for (LLVMControlFlowGraph.CFGLoop innerLoop : loop.getInnerLoops()) {
                nodes[innerLoop.getHeader().id] = null;
            }
        }
    }

    @Override
    public LLVMSourceFunctionType getSourceType() {
        this.convert();
        return this.method.getSourceFunction().getSourceType();
    }

    private static FrameSlot[] getNullableFrameSlots(FrameDescriptor frame, BitSet nullable) {
        int bitIndex = -1;
        ArrayList<FrameSlot> nullableSlots = new ArrayList<FrameSlot>();
        while ((bitIndex = nullable.nextSetBit(bitIndex + 1)) >= 0) {
            int frameIdentifier = bitIndex;
            nullableSlots.add(LLVMBitcodeInstructionVisitor.findFrameSlot(frame, frameIdentifier));
        }
        if (nullableSlots.size() > 0) {
            return nullableSlots.toArray(new FrameSlot[nullableSlots.size()]);
        }
        return null;
    }

    private static boolean functionParameterHasByValueAttribute(FunctionParameter parameter) {
        if (parameter.getParameterAttribute() != null) {
            for (Attribute a : parameter.getParameterAttribute().getAttributes()) {
                if (!(a instanceof Attribute.KnownAttribute) || ((Attribute.KnownAttribute)a).getAttr() != Attribute.Kind.BYVAL) continue;
                return true;
            }
        }
        return false;
    }

    private LLVMExpressionNode getTargetAddress(LLVMExpressionNode baseAddress, Type sourceType, ArrayDeque<Long> indices) {
        NodeFactory nf = this.runtime.getNodeFactory();
        int indicesSize = indices.size();
        Long[] indicesArr = new Long[indicesSize];
        LLVMExpressionNode[] indexNodes = new LLVMExpressionNode[indicesSize];
        int i = indicesSize - 1;
        Iterator<Long> iterator = indices.iterator();
        while (iterator.hasNext()) {
            Long idx;
            indicesArr[i] = idx = iterator.next();
            indexNodes[i] = nf.createLiteral((long)idx, PrimitiveType.I64);
            --i;
        }
        assert (i == -1);
        Object[] indexTypes = new PrimitiveType[indicesSize];
        Arrays.fill(indexTypes, PrimitiveType.I64);
        LLVMExpressionNode nestedGEPs = CommonNodeFactory.createNestedElementPointerNode(nf, this.dataLayout, indexNodes, indicesArr, (Type[])indexTypes, baseAddress, sourceType);
        return nestedGEPs;
    }

    private void copyStructArgumentsToFrame(List<LLVMStatementNode> initializers, NodeFactory nodeFactory, FrameSlot slot, int argIndex, PointerType topLevelPointerType, Type currentType, ArrayDeque<Long> indices) {
        if (currentType instanceof StructureType || currentType instanceof ArrayType) {
            AggregateType t = (AggregateType)currentType;
            for (long i = 0L; i < t.getNumberOfElements(); ++i) {
                indices.push(i);
                this.copyStructArgumentsToFrame(initializers, nodeFactory, slot, argIndex, topLevelPointerType, t.getElementType(i), indices);
                indices.pop();
            }
        } else {
            LLVMExpressionNode targetAddress = this.getTargetAddress(CommonNodeFactory.createFrameRead(topLevelPointerType, slot), topLevelPointerType.getPointeeType(), indices);
            LLVMUnpackVarargsNode argMaybeUnpack = LLVMUnpackVarargsNodeGen.create(nodeFactory.createFunctionArgNode(argIndex, topLevelPointerType));
            LLVMExpressionNode sourceAddress = this.getTargetAddress(argMaybeUnpack, topLevelPointerType.getPointeeType(), indices);
            LLVMLoadNode sourceLoadNode = CommonNodeFactory.createLoad(currentType, sourceAddress);
            LLVMStatementNode storeNode = nodeFactory.createStore(targetAddress, sourceLoadNode, currentType);
            initializers.add(storeNode);
        }
    }

    private List<LLVMStatementNode> copyArgumentsToFrame(FrameDescriptor frame, LLVMSymbolReadResolver symbols) {
        NodeFactory nodeFactory = this.runtime.getNodeFactory();
        List<FunctionParameter> parameters = this.method.getParameters();
        ArrayList<LLVMStatementNode> formalParamInits = new ArrayList<LLVMStatementNode>();
        LLVMExpressionNode stackPointerNode = nodeFactory.createFunctionArgNode(0, PrimitiveType.I64);
        formalParamInits.add(nodeFactory.createFrameWrite(PointerType.VOID, stackPointerNode, frame.findFrameSlot((Object)"<stackpointer>")));
        int argIndex = 1;
        if (this.method.getType().getReturnType() instanceof StructureType) {
            ++argIndex;
        }
        for (FunctionParameter parameter : parameters) {
            FrameSlot slot = symbols.findOrAddFrameSlot(frame, parameter);
            if (parameter.getType() instanceof PointerType && LazyToTruffleConverterImpl.functionParameterHasByValueAttribute(parameter)) {
                PointerType pointerType = (PointerType)parameter.getType();
                Type pointeeType = pointerType.getPointeeType();
                GetStackSpaceFactory allocaFactory = GetStackSpaceFactory.createAllocaFactory();
                LLVMExpressionNode allocation = allocaFactory.createGetStackSpace(nodeFactory, pointeeType);
                formalParamInits.add(nodeFactory.createFrameWrite(pointerType, allocation, slot));
                ArrayDeque<Long> indices = new ArrayDeque<Long>();
                this.copyStructArgumentsToFrame(formalParamInits, nodeFactory, slot, argIndex++, pointerType, pointeeType, indices);
                continue;
            }
            LLVMExpressionNode parameterNode = nodeFactory.createFunctionArgNode(argIndex++, parameter.getType());
            formalParamInits.add(nodeFactory.createFrameWrite(parameter.getType(), parameterNode, slot));
        }
        return formalParamInits;
    }
}

