/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.parser.listeners;

import com.oracle.truffle.llvm.parser.listeners.Constants;
import com.oracle.truffle.llvm.parser.listeners.Metadata;
import com.oracle.truffle.llvm.parser.listeners.ParameterAttributes;
import com.oracle.truffle.llvm.parser.listeners.ParserListener;
import com.oracle.truffle.llvm.parser.listeners.StringTable;
import com.oracle.truffle.llvm.parser.listeners.Types;
import com.oracle.truffle.llvm.parser.listeners.ValueSymbolTable;
import com.oracle.truffle.llvm.parser.model.IRScope;
import com.oracle.truffle.llvm.parser.model.ModelModule;
import com.oracle.truffle.llvm.parser.model.ValueSymbol;
import com.oracle.truffle.llvm.parser.model.attributes.AttributesCodeEntry;
import com.oracle.truffle.llvm.parser.model.enums.Linkage;
import com.oracle.truffle.llvm.parser.model.enums.Visibility;
import com.oracle.truffle.llvm.parser.model.functions.FunctionDeclaration;
import com.oracle.truffle.llvm.parser.model.functions.FunctionDefinition;
import com.oracle.truffle.llvm.parser.model.functions.LazyFunctionParser;
import com.oracle.truffle.llvm.parser.model.symbols.globals.GlobalAlias;
import com.oracle.truffle.llvm.parser.model.symbols.globals.GlobalVariable;
import com.oracle.truffle.llvm.parser.model.target.TargetDataLayout;
import com.oracle.truffle.llvm.parser.model.target.TargetTriple;
import com.oracle.truffle.llvm.parser.scanner.Block;
import com.oracle.truffle.llvm.parser.scanner.LLVMScanner;
import com.oracle.truffle.llvm.parser.scanner.RecordBuffer;
import com.oracle.truffle.llvm.parser.text.LLSourceBuilder;
import com.oracle.truffle.llvm.runtime.except.LLVMParserException;
import com.oracle.truffle.llvm.runtime.types.FunctionType;
import com.oracle.truffle.llvm.runtime.types.PointerType;
import com.oracle.truffle.llvm.runtime.types.Type;
import java.util.ArrayDeque;
import java.util.concurrent.atomic.AtomicInteger;

public final class Module
implements ParserListener {
    private final ModelModule module;
    private final ParameterAttributes paramAttributes;
    private final StringTable stringTable;
    private int mode = 1;
    private final Types types;
    private final IRScope scope;
    private final ArrayDeque<FunctionDefinition> functionQueue;
    private final LLSourceBuilder llSource;
    private final AtomicInteger index;
    private static final long GLOBALVAR_EXPLICICTTYPE_MASK = 2L;
    private static final long GLOBALVAR_ISCONSTANT_MASK = 1L;
    private static final int MODULE_VERSION = 1;
    private static final int MODULE_TARGET_TRIPLE = 2;
    private static final int MODULE_TARGET_DATALAYOUT = 3;
    private static final int MODULE_GLOBAL_VARIABLE = 7;
    private static final int MODULE_FUNCTION = 8;
    private static final int MODULE_ALIAS_OLD = 9;
    private static final int MODULE_ALIAS = 14;

    Module(ModelModule module, StringTable stringTable, IRScope scope, LLSourceBuilder llSource) {
        this.module = module;
        this.stringTable = stringTable;
        this.types = new Types(module);
        this.scope = scope;
        this.llSource = llSource;
        this.paramAttributes = new ParameterAttributes(this.types);
        this.functionQueue = new ArrayDeque();
        this.index = new AtomicInteger(0);
    }

    private boolean useStrTab() {
        return this.mode == 2;
    }

    private long readNameFromStrTab(RecordBuffer buffer) {
        if (this.useStrTab()) {
            int offset = buffer.readInt();
            int length = buffer.readInt();
            return (long)offset | (long)length << 32;
        }
        return 0L;
    }

    private void assignNameFromStrTab(long name, ValueSymbol target) {
        if (this.useStrTab()) {
            int offset = (int)(name & 0xFFFFFFFFFFFFFFFFL);
            int length = (int)(name >> 32);
            this.stringTable.requestName(offset, length, target);
        }
    }

    private void createFunction(RecordBuffer buffer) {
        long name = this.readNameFromStrTab(buffer);
        Type type = this.types.get(buffer.readInt());
        if (type instanceof PointerType) {
            type = ((PointerType)type).getPointeeType();
        }
        buffer.skip();
        FunctionType functionType = Types.castToFunction(type);
        boolean isPrototype = buffer.readBoolean();
        Linkage linkage = Linkage.decode(buffer.read());
        AttributesCodeEntry paramAttr = this.paramAttributes.getCodeEntry(buffer.read());
        buffer.skip();
        buffer.skip();
        Visibility visibility = Visibility.DEFAULT;
        if (buffer.remaining() > 0) {
            visibility = Visibility.decode(buffer.read());
        }
        if (isPrototype) {
            FunctionDeclaration function = new FunctionDeclaration(functionType, linkage, paramAttr, this.index.getAndIncrement());
            this.module.addFunctionDeclaration(function);
            this.scope.addSymbol(function, function.getType());
            this.assignNameFromStrTab(name, function);
        } else {
            FunctionDefinition function = new FunctionDefinition(functionType, linkage, visibility, paramAttr, this.index.getAndIncrement());
            this.module.addFunctionDefinition(function);
            this.scope.addSymbol(function, function.getType());
            this.assignNameFromStrTab(name, function);
            this.functionQueue.addLast(function);
        }
    }

    private void createGlobalVariable(RecordBuffer buffer) {
        long name = this.readNameFromStrTab(buffer);
        long typeField = buffer.read();
        long flagField = buffer.read();
        Type type = this.types.get(typeField);
        if ((flagField & 2L) != 0L) {
            type = new PointerType(type);
        }
        boolean isConstant = (flagField & 1L) != 0L;
        int initialiser = buffer.readInt();
        long linkage = buffer.read();
        int align = buffer.readInt();
        buffer.skip();
        long visibility = Visibility.DEFAULT.getEncodedValue();
        if (buffer.remaining() > 0) {
            visibility = buffer.read();
        }
        GlobalVariable global = GlobalVariable.create(isConstant, (PointerType)type, align, linkage, visibility, this.scope.getSymbols(), initialiser, this.index.getAndIncrement());
        this.assignNameFromStrTab(name, global);
        this.module.addGlobalVariable(global);
        this.scope.addSymbol(global, global.getType());
    }

    private void createGlobalAliasNew(RecordBuffer buffer) {
        long name = this.readNameFromStrTab(buffer);
        PointerType type = new PointerType(this.types.get(buffer.read()));
        buffer.skip();
        int value = buffer.readInt();
        long linkage = buffer.read();
        GlobalAlias global = GlobalAlias.create(type, linkage, Visibility.DEFAULT.ordinal(), this.scope.getSymbols(), value);
        this.assignNameFromStrTab(name, global);
        this.module.addAlias(global);
        this.scope.addSymbol(global, global.getType());
    }

    private void createGlobalAliasOld(RecordBuffer buffer) {
        long name = this.readNameFromStrTab(buffer);
        PointerType type = Types.castToPointer(this.types.get(buffer.read()));
        int value = buffer.readInt();
        long linkage = buffer.read();
        GlobalAlias global = GlobalAlias.create(type, linkage, Visibility.DEFAULT.ordinal(), this.scope.getSymbols(), value);
        this.assignNameFromStrTab(name, global);
        this.module.addAlias(global);
        this.scope.addSymbol(global, global.getType());
    }

    @Override
    public ParserListener enter(Block block) {
        switch (block) {
            case PARAMATTR: {
                return this.paramAttributes;
            }
            case PARAMATTR_GROUP: {
                return this.paramAttributes;
            }
            case CONSTANTS: {
                return new Constants(this.types, this.scope);
            }
            case FUNCTION: {
                throw new LLVMParserException("Function is not parsed lazily!");
            }
            case TYPE: {
                return this.types;
            }
            case VALUE_SYMTAB: {
                return new ValueSymbolTable(this.scope);
            }
            case METADATA: 
            case METADATA_KIND: {
                return new Metadata(this.types, this.scope);
            }
            case STRTAB: {
                return this.stringTable;
            }
        }
        return ParserListener.DEFAULT;
    }

    @Override
    public void skip(Block block, LLVMScanner.LazyScanner lazyScanner) {
        if (block == Block.FUNCTION) {
            if (this.functionQueue.isEmpty()) {
                throw new LLVMParserException("Missing Function Prototype in Bitcode File!");
            }
            FunctionDefinition definition = this.functionQueue.removeFirst();
            this.module.addFunctionParser(definition, new LazyFunctionParser(lazyScanner, this.scope, this.types, definition, this.mode, this.paramAttributes, this.llSource));
        } else {
            ParserListener.super.skip(block, lazyScanner);
        }
    }

    @Override
    public void record(RecordBuffer buffer) {
        switch (buffer.getId()) {
            case 1: {
                this.mode = buffer.readInt();
                break;
            }
            case 2: {
                this.module.addTargetInformation(new TargetTriple(buffer.readString()));
                break;
            }
            case 3: {
                TargetDataLayout layout = TargetDataLayout.fromString(buffer.readString());
                this.module.setTargetDataLayout(layout);
                break;
            }
            case 7: {
                this.createGlobalVariable(buffer);
                break;
            }
            case 8: {
                this.createFunction(buffer);
                break;
            }
            case 14: {
                this.createGlobalAliasNew(buffer);
                break;
            }
            case 9: {
                this.createGlobalAliasOld(buffer);
                break;
            }
        }
    }
}

