/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.parser.metadata.debuginfo;

import com.oracle.truffle.llvm.parser.metadata.DwarfOpcode;
import com.oracle.truffle.llvm.parser.metadata.MDExpression;
import java.util.List;

public final class ValueFragment
implements Comparable<ValueFragment> {
    private static final ValueFragment COMPLETE_VALUE = new ValueFragment(-1, -1);
    private static final int EXPRESSION_SIZE = 3;
    private static final int EXPRESSION_INDEX_OFFSET = 1;
    private static final int EXPRESSION_INDEX_LENGTH = 2;
    private final int offset;
    private final int length;

    public static boolean describesFragment(MDExpression expression) {
        return DwarfOpcode.hasOp(expression, 4096L);
    }

    public static ValueFragment create(int offset, int length) {
        return new ValueFragment(offset, length);
    }

    public static ValueFragment parse(MDExpression expression) {
        long op;
        int elementCount = expression.getElementCount();
        for (int i = 0; i < elementCount; i += DwarfOpcode.numElements(op)) {
            op = expression.getOperand(i);
            if (op != 4096L || i + 3 > elementCount) continue;
            int offset = (int)expression.getOperand(i + 1);
            int length = (int)expression.getOperand(i + 2);
            return new ValueFragment(offset, length);
        }
        return COMPLETE_VALUE;
    }

    public static int getPartIndex(ValueFragment fragment, List<ValueFragment> siblings, List<Integer> clearParts) {
        int partIndex = -1;
        for (int i = 0; i < siblings.size(); ++i) {
            ValueFragment sibling = siblings.get(i);
            if (sibling.equals(fragment)) {
                partIndex = i;
                continue;
            }
            if (COMPLETE_VALUE.equals(sibling) || !fragment.hides(sibling)) continue;
            clearParts.add(i);
        }
        return partIndex;
    }

    private ValueFragment(int offset, int length) {
        this.offset = offset;
        this.length = length;
    }

    public int getOffset() {
        return this.offset;
    }

    public int getLength() {
        return this.length;
    }

    public int getStart() {
        return this.offset;
    }

    public int getEnd() {
        return this.offset + this.length;
    }

    public boolean isComplete() {
        return COMPLETE_VALUE.equals(this);
    }

    private boolean hides(ValueFragment other) {
        return this.getStart() <= other.getStart() && other.getEnd() <= this.getEnd();
    }

    @Override
    public int compareTo(ValueFragment o) {
        if (this.offset == o.offset) {
            return Integer.compare(this.length, o.length);
        }
        return Integer.compare(this.offset, o.offset);
    }

    public int hashCode() {
        return this.offset << 16 | this.length;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        ValueFragment other = (ValueFragment)obj;
        return this.offset == other.offset && this.length == other.length;
    }
}

