/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.parser.model;

import com.oracle.truffle.llvm.parser.model.ValueSymbol;
import com.oracle.truffle.llvm.parser.model.enums.Linkage;

public abstract class GlobalSymbol
implements ValueSymbol {
    public static final String CONSTRUCTORS_VARNAME = "llvm.global_ctors";
    public static final String DESTRUCTORS_VARNAME = "llvm.global_dtors";
    private String name;
    private final Linkage linkage;
    private final int index;
    private boolean isSpecialInternalSymbol;
    public static final int ALIAS_INDEX = -1;

    public GlobalSymbol(String name, Linkage linkage, int index) {
        this.name = name;
        this.linkage = linkage;
        this.index = index;
    }

    public final Linkage getLinkage() {
        return this.linkage;
    }

    @Override
    public final String getName() {
        assert (this.name != null);
        return this.name;
    }

    public final boolean isIntrinsicGlobalVariable() {
        return this.isSpecialInternalSymbol;
    }

    @Override
    public final void setName(String name) {
        this.isSpecialInternalSymbol = CONSTRUCTORS_VARNAME.equals(name) || DESTRUCTORS_VARNAME.equals(name);
        this.name = name;
    }

    public final int getIndex() {
        assert (this.index != -1);
        return this.index;
    }

    public abstract boolean isExported();

    public abstract boolean isOverridable();

    public abstract boolean isExternal();
}

