/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.parser.model.enums;

import com.oracle.truffle.llvm.parser.model.enums.BinaryOperator;
import com.oracle.truffle.llvm.parser.model.enums.UnaryOperator;

public enum Flag {
    INT_EXACT("exact", 1),
    INT_NO_UNSIGNED_WRAP("nuw", 1),
    INT_NO_SIGNED_WRAP("nsw", 2),
    FP_NO_NANS("nnan", 2),
    FP_NO_INFINITIES("ninf", 4),
    FP_NO_SIGNED_ZEROES("nsz", 8),
    FP_ALLOW_RECIPROCAL("arcp", 16),
    FP_FAST("fast", 31);

    private final String irString;
    private final int mask;
    public static final Flag[] EMPTY_ARRAY;

    private Flag(String irString, int mask) {
        this.irString = irString;
        this.mask = mask;
    }

    public boolean test(long flags) {
        return (flags & (long)this.mask) == (long)this.mask;
    }

    public String toString() {
        return this.irString;
    }

    public String getIrString() {
        return this.irString;
    }

    public static Flag[] decode(BinaryOperator opcode, int flagbits) {
        switch (opcode) {
            case INT_ADD: 
            case INT_SUBTRACT: 
            case INT_MULTIPLY: 
            case INT_SHIFT_LEFT: {
                return Flag.create(flagbits, INT_NO_UNSIGNED_WRAP, INT_NO_SIGNED_WRAP);
            }
            case FP_ADD: 
            case FP_SUBTRACT: 
            case FP_MULTIPLY: 
            case FP_DIVIDE: 
            case FP_REMAINDER: {
                if (FP_FAST.test(flagbits)) {
                    return new Flag[]{FP_FAST};
                }
                return Flag.create(flagbits, FP_NO_NANS, FP_NO_INFINITIES, FP_NO_SIGNED_ZEROES, FP_ALLOW_RECIPROCAL);
            }
        }
        return Flag.create(flagbits, INT_EXACT);
    }

    public static Flag[] decode(UnaryOperator opcode, int flagbits) {
        return Flag.create(flagbits, new Flag[0]);
    }

    private static Flag[] create(long flagbits, Flag ... options) {
        int count = Long.bitCount(flagbits);
        if (count != 0) {
            int i = 0;
            Flag[] flags = new Flag[count];
            for (Flag option : options) {
                if (!option.test(flagbits)) continue;
                flags[i++] = option;
            }
            return flags;
        }
        return EMPTY_ARRAY;
    }

    static {
        EMPTY_ARRAY = new Flag[0];
    }
}

