/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.parser.model.symbols.constants;

import com.oracle.truffle.llvm.parser.model.SymbolImpl;
import com.oracle.truffle.llvm.parser.model.SymbolTable;
import com.oracle.truffle.llvm.parser.model.symbols.constants.AbstractConstant;
import com.oracle.truffle.llvm.parser.model.visitors.SymbolVisitor;
import com.oracle.truffle.llvm.runtime.types.Type;

public final class GetElementPointerConstant
extends AbstractConstant {
    private final boolean isInbounds;
    private SymbolImpl base;
    private final SymbolImpl[] indices;

    private GetElementPointerConstant(Type type, boolean isInbounds, int size) {
        super(type);
        this.isInbounds = isInbounds;
        this.indices = new SymbolImpl[size];
    }

    @Override
    public void accept(SymbolVisitor visitor) {
        visitor.visit(this);
    }

    public SymbolImpl getBasePointer() {
        return this.base;
    }

    public SymbolImpl[] getIndices() {
        return this.indices;
    }

    public boolean isInbounds() {
        return this.isInbounds;
    }

    @Override
    public void replace(SymbolImpl original, SymbolImpl replacement) {
        if (this.base == original) {
            this.base = replacement;
        }
        for (int i = 0; i < this.indices.length; ++i) {
            if (this.indices[i] != original) continue;
            this.indices[i] = replacement;
        }
    }

    public static GetElementPointerConstant fromSymbols(SymbolTable symbols, Type type, int pointer, int[] indices, boolean isInbounds) {
        GetElementPointerConstant constant = new GetElementPointerConstant(type, isInbounds, indices.length);
        constant.base = symbols.getForwardReferenced(pointer, constant);
        for (int i = 0; i < indices.length; ++i) {
            constant.indices[i] = symbols.getForwardReferenced(indices[i], constant);
        }
        return constant;
    }
}

