/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.parser.model.symbols.globals;

import com.oracle.truffle.llvm.parser.metadata.MDAttachment;
import com.oracle.truffle.llvm.parser.metadata.MetadataAttachmentHolder;
import com.oracle.truffle.llvm.parser.model.GlobalSymbol;
import com.oracle.truffle.llvm.parser.model.SymbolImpl;
import com.oracle.truffle.llvm.parser.model.SymbolTable;
import com.oracle.truffle.llvm.parser.model.ValueSymbol;
import com.oracle.truffle.llvm.parser.model.enums.Linkage;
import com.oracle.truffle.llvm.parser.model.enums.Visibility;
import com.oracle.truffle.llvm.runtime.debug.scope.LLVMSourceSymbol;
import com.oracle.truffle.llvm.runtime.types.PointerType;
import java.util.ArrayList;
import java.util.List;

public abstract class GlobalValueSymbol
extends GlobalSymbol
implements ValueSymbol,
MetadataAttachmentHolder {
    private final PointerType type;
    private SymbolImpl value = null;
    private final Visibility visibility;
    private List<MDAttachment> mdAttachments = null;
    private LLVMSourceSymbol sourceSymbol;

    GlobalValueSymbol(PointerType type, Linkage linkage, Visibility visibility, SymbolTable symbolTable, int value, int index) {
        super("<anon>", linkage, index);
        this.type = type;
        this.visibility = visibility;
        this.value = value > 0 ? (SymbolImpl)symbolTable.getForwardReferenced(value - 1, this) : null;
        this.sourceSymbol = null;
    }

    public boolean isInitialized() {
        return this.value != null;
    }

    public int getInitialiser() {
        return this.isInitialized() ? 1 : 0;
    }

    @Override
    public PointerType getType() {
        return this.type;
    }

    public SymbolImpl getValue() {
        return this.value;
    }

    public Visibility getVisibility() {
        return this.visibility;
    }

    public LLVMSourceSymbol getSourceSymbol() {
        return this.sourceSymbol;
    }

    public void setSourceSymbol(LLVMSourceSymbol sourceSymbol) {
        this.sourceSymbol = sourceSymbol;
    }

    public String toString() {
        return this.getName();
    }

    @Override
    public boolean hasAttachedMetadata() {
        return this.mdAttachments != null;
    }

    @Override
    public List<MDAttachment> getAttachedMetadata() {
        if (this.mdAttachments == null) {
            this.mdAttachments = new ArrayList<MDAttachment>(1);
        }
        return this.mdAttachments;
    }

    @Override
    public void replace(SymbolImpl oldValue, SymbolImpl newValue) {
        if (this.value == oldValue) {
            this.value = newValue;
        }
    }

    @Override
    public boolean isExported() {
        return !this.isIntrinsicGlobalVariable() && Linkage.isExported(this.getLinkage(), this.visibility);
    }

    @Override
    public boolean isOverridable() {
        return Linkage.isOverridable(this.getLinkage(), this.visibility);
    }

    @Override
    public boolean isExternal() {
        return this.getInitialiser() == 0 && this.isExported();
    }
}

