/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.parser.model.symbols.instructions;

import com.oracle.truffle.llvm.parser.model.SymbolImpl;
import com.oracle.truffle.llvm.parser.model.SymbolTable;
import com.oracle.truffle.llvm.parser.model.symbols.instructions.ValueInstruction;
import com.oracle.truffle.llvm.parser.model.visitors.SymbolVisitor;
import com.oracle.truffle.llvm.runtime.types.Type;

public final class InsertElementInstruction
extends ValueInstruction {
    private SymbolImpl vector;
    private SymbolImpl index;
    private SymbolImpl value;

    private InsertElementInstruction(Type type) {
        super(type);
    }

    @Override
    public void accept(SymbolVisitor visitor) {
        visitor.visit(this);
    }

    public SymbolImpl getIndex() {
        return this.index;
    }

    public SymbolImpl getValue() {
        return this.value;
    }

    public SymbolImpl getVector() {
        return this.vector;
    }

    @Override
    public void replace(SymbolImpl original, SymbolImpl replacement) {
        if (this.vector == original) {
            this.vector = replacement;
        }
        if (this.index == original) {
            this.index = replacement;
        }
        if (this.value == original) {
            this.value = replacement;
        }
    }

    public static InsertElementInstruction fromSymbols(SymbolTable symbols, Type type, int vector, int index, int value) {
        InsertElementInstruction inst = new InsertElementInstruction(type);
        inst.vector = symbols.getForwardReferenced(vector, inst);
        inst.index = symbols.getForwardReferenced(index, inst);
        inst.value = symbols.getForwardReferenced(value, inst);
        return inst;
    }
}

