/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.parser.model.symbols.instructions;

import com.oracle.truffle.llvm.parser.model.SymbolImpl;
import com.oracle.truffle.llvm.parser.model.SymbolTable;
import com.oracle.truffle.llvm.parser.model.symbols.instructions.ValueInstruction;
import com.oracle.truffle.llvm.parser.model.visitors.SymbolVisitor;
import com.oracle.truffle.llvm.runtime.types.Type;

public final class SelectInstruction
extends ValueInstruction {
    private SymbolImpl condition;
    private SymbolImpl trueValue;
    private SymbolImpl falseValue;

    private SelectInstruction(Type type) {
        super(type);
    }

    @Override
    public void accept(SymbolVisitor visitor) {
        visitor.visit(this);
    }

    public SymbolImpl getCondition() {
        return this.condition;
    }

    public SymbolImpl getFalseValue() {
        return this.falseValue;
    }

    public SymbolImpl getTrueValue() {
        return this.trueValue;
    }

    @Override
    public void replace(SymbolImpl original, SymbolImpl replacement) {
        if (this.condition == original) {
            this.condition = replacement;
        }
        if (this.falseValue == original) {
            this.falseValue = replacement;
        }
        if (this.trueValue == original) {
            this.trueValue = replacement;
        }
    }

    public static SelectInstruction fromSymbols(SymbolTable symbols, Type type, int condition, int trueValue, int falseValue) {
        SelectInstruction inst = new SelectInstruction(type);
        inst.condition = symbols.getForwardReferenced(condition, inst);
        inst.trueValue = symbols.getForwardReferenced(trueValue, inst);
        inst.falseValue = symbols.getForwardReferenced(falseValue, inst);
        return inst;
    }
}

