/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.parser.model.symbols.instructions;

import com.oracle.truffle.llvm.parser.model.SymbolImpl;
import com.oracle.truffle.llvm.parser.model.SymbolTable;
import com.oracle.truffle.llvm.parser.model.symbols.instructions.ValueInstruction;
import com.oracle.truffle.llvm.parser.model.visitors.SymbolVisitor;
import com.oracle.truffle.llvm.runtime.types.Type;

public final class ShuffleVectorInstruction
extends ValueInstruction {
    private SymbolImpl vector1;
    private SymbolImpl vector2;
    private SymbolImpl mask;

    private ShuffleVectorInstruction(Type type) {
        super(type);
    }

    @Override
    public void accept(SymbolVisitor visitor) {
        visitor.visit(this);
    }

    public SymbolImpl getMask() {
        return this.mask;
    }

    public SymbolImpl getVector1() {
        return this.vector1;
    }

    public SymbolImpl getVector2() {
        return this.vector2;
    }

    @Override
    public void replace(SymbolImpl original, SymbolImpl replacement) {
        if (this.vector1 == original) {
            this.vector1 = replacement;
        }
        if (this.vector2 == original) {
            this.vector2 = replacement;
        }
        if (this.mask == original) {
            this.mask = replacement;
        }
    }

    public static ShuffleVectorInstruction fromSymbols(SymbolTable symbols, Type type, int vector1, int vector2, int mask) {
        ShuffleVectorInstruction inst = new ShuffleVectorInstruction(type);
        inst.vector1 = symbols.getForwardReferenced(vector1, inst);
        inst.vector2 = symbols.getForwardReferenced(vector2, inst);
        inst.mask = symbols.getForwardReferenced(mask, inst);
        return inst;
    }
}

