/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.parser.model.symbols.instructions;

import com.oracle.truffle.llvm.parser.model.SymbolImpl;
import com.oracle.truffle.llvm.parser.model.SymbolTable;
import com.oracle.truffle.llvm.parser.model.enums.AtomicOrdering;
import com.oracle.truffle.llvm.parser.model.enums.SynchronizationScope;
import com.oracle.truffle.llvm.parser.model.symbols.instructions.VoidInstruction;
import com.oracle.truffle.llvm.parser.model.visitors.SymbolVisitor;

public final class StoreInstruction
extends VoidInstruction {
    private final int align;
    private final AtomicOrdering atomicOrdering;
    private final boolean isVolatile;
    private final SynchronizationScope synchronizationScope;
    private SymbolImpl destination;
    private SymbolImpl source;

    private StoreInstruction(int align, boolean isVolatile, AtomicOrdering ordering, SynchronizationScope scope) {
        this.align = align;
        this.isVolatile = isVolatile;
        this.atomicOrdering = ordering;
        this.synchronizationScope = scope;
    }

    private static StoreInstruction fromSymbols(SymbolTable symbols, int destination, int source, int align, boolean isVolatile, AtomicOrdering atomicOrdering, SynchronizationScope synchronizationScope) {
        StoreInstruction inst = new StoreInstruction(align, isVolatile, atomicOrdering, synchronizationScope);
        inst.destination = symbols.getForwardReferenced(destination, inst);
        inst.source = symbols.getForwardReferenced(source, inst);
        return inst;
    }

    public static StoreInstruction fromSymbols(SymbolTable symbols, int destination, int source, int align, boolean isVolatile, long atomicOrdering, long synchronizationScope) {
        return StoreInstruction.fromSymbols(symbols, destination, source, align, isVolatile, AtomicOrdering.decode(atomicOrdering), SynchronizationScope.decode(synchronizationScope));
    }

    public static StoreInstruction fromSymbols(SymbolTable symbols, int destination, int source, int align, boolean isVolatile) {
        return StoreInstruction.fromSymbols(symbols, destination, source, align, isVolatile, AtomicOrdering.NOT_ATOMIC, SynchronizationScope.CROSS_THREAD);
    }

    @Override
    public void accept(SymbolVisitor visitor) {
        visitor.visit(this);
    }

    public int getAlign() {
        return this.align;
    }

    public AtomicOrdering getAtomicOrdering() {
        return this.atomicOrdering;
    }

    public SymbolImpl getDestination() {
        return this.destination;
    }

    public SymbolImpl getSource() {
        return this.source;
    }

    public SynchronizationScope getSynchronizationScope() {
        return this.synchronizationScope;
    }

    public boolean isVolatile() {
        return this.isVolatile;
    }

    @Override
    public void replace(SymbolImpl original, SymbolImpl replacement) {
        if (this.destination == original) {
            this.destination = replacement;
        }
        if (this.source == original) {
            this.source = replacement;
        }
    }
}

