/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.parser.scanner;

import com.oracle.truffle.llvm.runtime.except.LLVMParserException;
import com.oracle.truffle.llvm.runtime.types.Type;
import java.util.Arrays;

public final class RecordBuffer {
    private static final int INITIAL_BUFFER_SIZE = 8;
    private long[] opBuffer = new long[8];
    private int size = 0;
    private int index = 1;

    void addOpNoCheck(long op) {
        assert (this.size < this.opBuffer.length);
        this.opBuffer[this.size++] = op;
    }

    void addOp(long op) {
        this.ensureFits(1L);
        this.addOpNoCheck(op);
    }

    void ensureFits(long numOfAdditionalOps) {
        if ((long)this.size >= (long)this.opBuffer.length - numOfAdditionalOps) {
            int newLength = this.opBuffer.length;
            while ((long)this.size >= (long)newLength - numOfAdditionalOps) {
                newLength *= 2;
            }
            this.opBuffer = Arrays.copyOf(this.opBuffer, newLength);
        }
    }

    long[] getOps() {
        return Arrays.copyOfRange(this.opBuffer, 1, this.size);
    }

    void invalidate() {
        this.size = 0;
        this.index = 1;
    }

    public long getAt(int pos) {
        return this.opBuffer[pos + 1];
    }

    public int getId() {
        if (this.size <= 0) {
            throw new LLVMParserException("Record Id not set!");
        }
        long id = this.opBuffer[0];
        if (id != (long)((int)id)) {
            throw new LLVMParserException("invalid record id " + id);
        }
        return (int)id;
    }

    public int size() {
        return this.size - 1;
    }

    public long read() {
        assert (this.index < this.size);
        return this.opBuffer[this.index++];
    }

    public void skip() {
        ++this.index;
    }

    public int readInt() {
        long read = this.read();
        return RecordBuffer.toUnsignedIntExact(read);
    }

    private static int toUnsignedIntExact(long read) {
        if (Type.fitsIntoUnsignedInt(read)) {
            return Type.toUnsignedInt(read);
        }
        throw new ArithmeticException("unsigned integer overflow");
    }

    public boolean readBoolean() {
        return this.read() != 0L;
    }

    public int remaining() {
        return this.size - this.index;
    }

    public void checkEnd(String message) {
        if (this.remaining() > 0) {
            throw new LLVMParserException(message);
        }
    }

    public static String describe(long id, long[] args) {
        StringBuilder builder = new StringBuilder();
        builder.append("<id=").append(id).append(" - ");
        for (int i = 0; i < args.length; ++i) {
            builder.append("op").append(i).append('=').append(args[i]);
            if (i == args.length - 1) continue;
            builder.append(", ");
        }
        builder.append('>');
        return builder.toString();
    }

    public long readSignedValue() {
        long v = this.read();
        if ((v & 1L) == 1L) {
            return (v >>>= 1) == 0L ? Long.MIN_VALUE : -v;
        }
        return v >>> 1;
    }

    public String readString() {
        int length = this.remaining();
        StringBuilder string = new StringBuilder(length);
        for (int i = 0; i < length; ++i) {
            string.append((char)this.opBuffer[this.index + i]);
        }
        this.index += length;
        return string.toString();
    }

    public String readUnicodeString() {
        byte[] bytes = new byte[this.remaining()];
        for (int i = 0; i < bytes.length; ++i) {
            bytes[i] = (byte)(this.opBuffer[this.index + i] & 0xFFL);
        }
        this.index += bytes.length;
        return new String(bytes);
    }

    public long[] dumpArray() {
        return this.getOps();
    }
}

