/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.parser.text;

import com.oracle.truffle.api.source.Source;
import com.oracle.truffle.llvm.parser.LLVMParserRuntime;
import com.oracle.truffle.llvm.parser.metadata.debuginfo.SourceFunction;
import com.oracle.truffle.llvm.parser.model.blocks.InstructionBlock;
import com.oracle.truffle.llvm.parser.model.functions.FunctionDefinition;
import com.oracle.truffle.llvm.parser.model.functions.FunctionParameter;
import com.oracle.truffle.llvm.parser.model.symbols.instructions.BranchInstruction;
import com.oracle.truffle.llvm.parser.model.symbols.instructions.ConditionalBranchInstruction;
import com.oracle.truffle.llvm.parser.model.symbols.instructions.DbgDeclareInstruction;
import com.oracle.truffle.llvm.parser.model.symbols.instructions.DbgValueInstruction;
import com.oracle.truffle.llvm.parser.model.symbols.instructions.DebugTrapInstruction;
import com.oracle.truffle.llvm.parser.model.symbols.instructions.FenceInstruction;
import com.oracle.truffle.llvm.parser.model.symbols.instructions.IndirectBranchInstruction;
import com.oracle.truffle.llvm.parser.model.symbols.instructions.Instruction;
import com.oracle.truffle.llvm.parser.model.symbols.instructions.ReadModifyWriteInstruction;
import com.oracle.truffle.llvm.parser.model.symbols.instructions.ResumeInstruction;
import com.oracle.truffle.llvm.parser.model.symbols.instructions.ReturnInstruction;
import com.oracle.truffle.llvm.parser.model.symbols.instructions.StoreInstruction;
import com.oracle.truffle.llvm.parser.model.symbols.instructions.SwitchInstruction;
import com.oracle.truffle.llvm.parser.model.symbols.instructions.SwitchOldInstruction;
import com.oracle.truffle.llvm.parser.model.symbols.instructions.UnreachableInstruction;
import com.oracle.truffle.llvm.parser.model.symbols.instructions.ValueInstruction;
import com.oracle.truffle.llvm.parser.model.symbols.instructions.VoidCallInstruction;
import com.oracle.truffle.llvm.parser.model.symbols.instructions.VoidInvokeInstruction;
import com.oracle.truffle.llvm.parser.model.visitors.FunctionVisitor;
import com.oracle.truffle.llvm.parser.model.visitors.ValueInstructionVisitor;
import com.oracle.truffle.llvm.parser.text.LLSourceMap;
import com.oracle.truffle.llvm.runtime.debug.scope.LLVMSourceLocation;
import com.oracle.truffle.llvm.runtime.options.TargetStream;
import com.oracle.truffle.llvm.runtime.types.symbols.LLVMIdentifier;
import java.util.ArrayDeque;
import java.util.Set;
import java.util.stream.Collectors;

final class LLInstructionMapper {
    LLInstructionMapper() {
    }

    private static void fillInNames(FunctionDefinition function) {
        int symbolIndex = 0;
        for (FunctionParameter parameter : function.getParameters()) {
            if (!"<anon>".equals(parameter.getName())) continue;
            parameter.setName(String.valueOf(symbolIndex++));
        }
        Set explicitBlockNames = function.getBlocks().stream().map(InstructionBlock::getName).filter(blockName -> !LLVMIdentifier.isUnknown(blockName)).collect(Collectors.toSet());
        for (InstructionBlock block : function.getBlocks()) {
            if (LLVMIdentifier.isUnknown(block.getName())) {
                do {
                    block.setName(LLVMIdentifier.toImplicitBlockName(symbolIndex++));
                } while (explicitBlockNames.contains(block.getName()));
            }
            for (int i = 0; i < block.getInstructionCount(); ++i) {
                ValueInstruction value;
                Instruction instruction = block.getInstruction(i);
                if (!(instruction instanceof ValueInstruction) || !LLVMIdentifier.isUnknown((value = (ValueInstruction)instruction).getName())) continue;
                value.setName(String.valueOf(symbolIndex++));
            }
        }
    }

    static void setSourceLocations(LLSourceMap sourceMap, FunctionDefinition functionDefinition, LLVMParserRuntime runtime) {
        LLSourceMap.Function function = sourceMap.getFunction(functionDefinition.getName());
        if (function == null) {
            TargetStream stream = runtime.getContext().llDebugVerboseStream();
            if (stream != null) {
                stream.println("Cannot find .ll source for function " + functionDefinition.getName());
            }
            return;
        }
        LLVMSourceLocation location = function.toSourceLocation(sourceMap, runtime);
        SourceFunction sourceFunction = functionDefinition.getSourceFunction();
        sourceFunction = new SourceFunction(location, sourceFunction.getSourceType());
        functionDefinition.setSourceFunction(sourceFunction);
        LLInstructionMapper.fillInNames(functionDefinition);
        functionDefinition.accept(new Mapper(sourceMap.getLLSource(), location, function.getInstructionList()));
        sourceMap.clearFunction(function);
    }

    private static final class Mapper
    extends ValueInstructionVisitor
    implements FunctionVisitor {
        private final Source llSource;
        private final LLVMSourceLocation parentLocation;
        private final ArrayDeque<LLSourceMap.Instruction> llInstructions;

        private Mapper(Source llSource, LLVMSourceLocation parentLocation, ArrayDeque<LLSourceMap.Instruction> llInstructions) {
            this.llSource = llSource;
            this.parentLocation = parentLocation;
            this.llInstructions = llInstructions;
        }

        LLVMSourceLocation toLocation(LLSourceMap.Instruction instruction) {
            return instruction.toSourceLocation(this.llSource, this.parentLocation);
        }

        private void assignInstructionLocation(Instruction inst, String ... opCodes) {
            LLSourceMap.Instruction expected = this.llInstructions.peekFirst();
            while (expected != null) {
                for (String opCode : opCodes) {
                    if (!opCode.equals(expected.getDescriptor())) continue;
                    inst.setSourceLocation(this.toLocation(expected));
                    this.llInstructions.pollFirst();
                    return;
                }
                if (expected.getDescriptor().startsWith("%")) {
                    return;
                }
                this.llInstructions.pollFirst();
                expected = this.llInstructions.peekFirst();
            }
        }

        @Override
        public void visitValueInstruction(ValueInstruction value) {
            this.assignInstructionLocation(value, LLVMIdentifier.toLocalIdentifier(value.getName()));
        }

        @Override
        public void visit(BranchInstruction inst) {
            this.assignInstructionLocation(inst, "br");
        }

        @Override
        public void visit(ConditionalBranchInstruction inst) {
            this.assignInstructionLocation(inst, "br");
        }

        @Override
        public void visit(IndirectBranchInstruction inst) {
            this.assignInstructionLocation(inst, "indirectbr");
        }

        @Override
        public void visit(ReturnInstruction inst) {
            this.assignInstructionLocation(inst, "ret");
        }

        @Override
        public void visit(StoreInstruction inst) {
            this.assignInstructionLocation(inst, "store");
        }

        @Override
        public void visit(SwitchInstruction inst) {
            this.assignInstructionLocation(inst, "switch");
        }

        @Override
        public void visit(SwitchOldInstruction inst) {
            this.assignInstructionLocation(inst, "switch");
        }

        @Override
        public void visit(UnreachableInstruction inst) {
            this.assignInstructionLocation(inst, "unreachable");
        }

        @Override
        public void visit(VoidCallInstruction inst) {
            this.assignInstructionLocation(inst, "tail", "musttail", "notail", "call");
        }

        @Override
        public void visit(VoidInvokeInstruction inst) {
            this.assignInstructionLocation(inst, "invoke");
        }

        @Override
        public void visit(ResumeInstruction inst) {
            this.assignInstructionLocation(inst, "resume");
        }

        @Override
        public void visit(FenceInstruction inst) {
            this.assignInstructionLocation(inst, "fence");
        }

        @Override
        public void visit(DbgDeclareInstruction inst) {
            this.assignInstructionLocation(inst, "tail", "call");
        }

        @Override
        public void visit(DbgValueInstruction inst) {
            this.assignInstructionLocation(inst, "tail", "call");
        }

        @Override
        public void visit(ReadModifyWriteInstruction inst) {
            this.assignInstructionLocation(inst, "atomicrmw");
        }

        @Override
        public void visit(DebugTrapInstruction inst) {
            this.assignInstructionLocation(inst, "tail", "call");
        }

        @Override
        public void visit(InstructionBlock block) {
            block.accept(this);
        }
    }
}

