/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime;

import com.oracle.truffle.api.TruffleFile;
import com.oracle.truffle.llvm.runtime.LLVMContext;
import com.oracle.truffle.llvm.runtime.LibraryLocator;
import com.oracle.truffle.llvm.runtime.except.LLVMLinkerException;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;

public final class DefaultLibraryLocator
extends LibraryLocator {
    public static final DefaultLibraryLocator INSTANCE = new DefaultLibraryLocator();

    private DefaultLibraryLocator() {
    }

    @Override
    public TruffleFile locateLibrary(LLVMContext context, String lib, Object reason) {
        Path libPath = Paths.get(lib, new String[0]);
        if (libPath.isAbsolute()) {
            return DefaultLibraryLocator.locateAbsolute(context, lib, libPath);
        }
        return DefaultLibraryLocator.locateGlobal(context, lib);
    }

    public static TruffleFile locateGlobal(LLVMContext context, String lib) {
        List<Path> libraryPaths = context.getLibraryPaths();
        DefaultLibraryLocator.traceSearchPath(context, libraryPaths);
        for (Path p : libraryPaths) {
            Path absPath = Paths.get(p.toString(), lib);
            DefaultLibraryLocator.traceTry(context, absPath);
            TruffleFile file = context.getEnv().getInternalTruffleFile(absPath.toUri());
            if (!file.exists(new LinkOption[0])) continue;
            return file;
        }
        return null;
    }

    public static TruffleFile locateAbsolute(LLVMContext context, String lib, Path libPath) {
        assert (libPath.isAbsolute());
        DefaultLibraryLocator.traceTry(context, libPath);
        TruffleFile file = context.getEnv().getInternalTruffleFile(libPath.toUri());
        if (file.exists(new LinkOption[0])) {
            return file;
        }
        throw new LLVMLinkerException(String.format("Library \"%s\" does not exist.", lib));
    }
}

