/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleFile;
import java.io.IOException;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Objects;

public final class ExternalLibrary {
    private final String name;
    private final Path path;
    private final TruffleFile file;
    private static final String BC_EXT = ".bc";
    @CompilerDirectives.CompilationFinal
    private boolean isNative;
    private final boolean isInternal;

    public static ExternalLibrary externalFromName(String name, boolean isNative) {
        return ExternalLibrary.createFromName(name, isNative, false);
    }

    public static ExternalLibrary internalFromName(String name, boolean isNative) {
        return ExternalLibrary.createFromName(name, isNative, true);
    }

    public static ExternalLibrary internalFromPath(Path path, boolean isNative) {
        return ExternalLibrary.createFromPath(path, isNative, true);
    }

    public static ExternalLibrary createFromName(String name, boolean isNative, boolean isInternal) {
        return new ExternalLibrary(name, null, isNative, isInternal, null);
    }

    public static ExternalLibrary createFromPath(Path path, boolean isNative, boolean isInternal) {
        return new ExternalLibrary(ExternalLibrary.extractName(path), path, isNative, isInternal, null);
    }

    public static ExternalLibrary createFromFile(TruffleFile file, boolean isNative, boolean isInternal) {
        Path path = Paths.get(file.getPath(), new String[0]);
        return new ExternalLibrary(ExternalLibrary.extractName(path), path, isNative, isInternal, ExternalLibrary.getCanonicalFile(file));
    }

    private static TruffleFile getCanonicalFile(TruffleFile file) {
        try {
            return file.getCanonicalFile(new LinkOption[0]);
        }
        catch (IOException e) {
            return file;
        }
    }

    private static String extractName(Path path) {
        Path filename = path.getFileName();
        if (filename == null) {
            throw new IllegalArgumentException("Path " + path + " is empty");
        }
        String nameWithExt = filename.toString();
        if (nameWithExt.endsWith(BC_EXT)) {
            return nameWithExt.substring(0, nameWithExt.length() - BC_EXT.length());
        }
        return nameWithExt;
    }

    private ExternalLibrary(String name, Path path, boolean isNative, boolean isInternal, TruffleFile file) {
        this.name = name;
        this.path = path;
        this.isNative = isNative;
        this.isInternal = isInternal;
        this.file = file;
    }

    public boolean hasFile() {
        return this.file != null;
    }

    public TruffleFile getFile() {
        return this.file;
    }

    public Path getPath() {
        return this.path;
    }

    public boolean isNative() {
        return this.isNative;
    }

    public boolean isInternal() {
        return this.isInternal;
    }

    public void makeBitcodeLibrary() {
        this.isNative = false;
    }

    public String getName() {
        return this.name;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof ExternalLibrary) {
            ExternalLibrary other = (ExternalLibrary)obj;
            if (this.file != null) {
                return this.file.equals((Object)other.file);
            }
            return this.name.equals(other.name) && Objects.equals(this.path, other.path);
        }
        return false;
    }

    public int hashCode() {
        return this.name.hashCode() ^ Objects.hashCode(this.path);
    }

    public String toString() {
        return this.path == null ? this.name : this.name + " (" + this.path + ")";
    }
}

