/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime;

import com.oracle.truffle.api.CallTarget;
import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.RootCallTarget;
import com.oracle.truffle.api.Truffle;
import com.oracle.truffle.api.TruffleFile;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.FrameDescriptor;
import com.oracle.truffle.api.frame.FrameSlot;
import com.oracle.truffle.api.frame.FrameUtil;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.ControlFlowException;
import com.oracle.truffle.api.nodes.DirectCallNode;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.api.source.Source;
import com.oracle.truffle.api.utilities.AssumedValue;
import com.oracle.truffle.llvm.api.Toolchain;
import com.oracle.truffle.llvm.runtime.ContextExtension;
import com.oracle.truffle.llvm.runtime.DefaultLibraryLocator;
import com.oracle.truffle.llvm.runtime.ExternalLibrary;
import com.oracle.truffle.llvm.runtime.LLVMArgumentBuffer;
import com.oracle.truffle.llvm.runtime.LLVMContextFactory;
import com.oracle.truffle.llvm.runtime.LLVMFunction;
import com.oracle.truffle.llvm.runtime.LLVMFunctionDescriptor;
import com.oracle.truffle.llvm.runtime.LLVMLanguage;
import com.oracle.truffle.llvm.runtime.LLVMLocalScope;
import com.oracle.truffle.llvm.runtime.LLVMScope;
import com.oracle.truffle.llvm.runtime.LLVMSymbol;
import com.oracle.truffle.llvm.runtime.LLVMThread;
import com.oracle.truffle.llvm.runtime.LibraryLocator;
import com.oracle.truffle.llvm.runtime.NodeFactory;
import com.oracle.truffle.llvm.runtime.PlatformCapability;
import com.oracle.truffle.llvm.runtime.datalayout.DataLayout;
import com.oracle.truffle.llvm.runtime.debug.LLVMSourceContext;
import com.oracle.truffle.llvm.runtime.debug.type.LLVMSourceType;
import com.oracle.truffle.llvm.runtime.except.LLVMLinkerException;
import com.oracle.truffle.llvm.runtime.global.LLVMGlobal;
import com.oracle.truffle.llvm.runtime.global.LLVMGlobalContainer;
import com.oracle.truffle.llvm.runtime.instruments.trace.LLVMTracerInstrument;
import com.oracle.truffle.llvm.runtime.interop.access.LLVMInteropType;
import com.oracle.truffle.llvm.runtime.memory.LLVMMemory;
import com.oracle.truffle.llvm.runtime.memory.LLVMMemoryOpNode;
import com.oracle.truffle.llvm.runtime.memory.LLVMStack;
import com.oracle.truffle.llvm.runtime.memory.LLVMThreadingStack;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMStatementNode;
import com.oracle.truffle.llvm.runtime.options.SulongEngineOption;
import com.oracle.truffle.llvm.runtime.options.TargetStream;
import com.oracle.truffle.llvm.runtime.pointer.LLVMManagedPointer;
import com.oracle.truffle.llvm.runtime.pointer.LLVMNativePointer;
import com.oracle.truffle.llvm.runtime.pointer.LLVMPointer;
import com.oracle.truffle.llvm.runtime.pthread.LLVMPThreadContext;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public final class LLVMContext {
    public static final String SULONG_INIT_CONTEXT = "__sulong_init_context";
    public static final String SULONG_DISPOSE_CONTEXT = "__sulong_dispose_context";
    private final List<Path> libraryPaths = new ArrayList<Path>();
    private final Object libraryPathsLock = new Object();
    private final Toolchain toolchain;
    @CompilerDirectives.CompilationFinal
    private Path internalLibraryPath;
    @CompilerDirectives.CompilationFinal
    private TruffleFile internalLibraryPathFile;
    private final List<ExternalLibrary> externalLibraries = new ArrayList<ExternalLibrary>();
    private final Object externalLibrariesLock = new Object();
    private final List<String> internalLibraryNames;
    private final ConcurrentHashMap<LLVMPointer, List<LLVMSymbol>> symbolsReverseMap = new ConcurrentHashMap();
    private final ArrayList<LLVMPointer> globalsNonPointerStore = new ArrayList();
    private final ArrayList<LLVMPointer> globalsReadOnlyStore = new ArrayList();
    private final Object globalsStoreLock = new Object();
    private final List<LLVMThread> runningThreads = new ArrayList<LLVMThread>();
    @CompilerDirectives.CompilationFinal
    private LLVMThreadingStack threadingStack;
    private Object[] mainArguments;
    private final ArrayList<LLVMNativePointer> caughtExceptionStack = new ArrayList();
    private ConcurrentHashMap<String, Integer> nativeCallStatistics;
    private final LLVMMemory.HandleContainer handleContainer;
    private final LLVMMemory.HandleContainer derefHandleContainer;
    private final LLVMSourceContext sourceContext;
    @CompilerDirectives.CompilationFinal
    private List<ContextExtension> contextExtensions;
    @CompilerDirectives.CompilationFinal
    private TruffleLanguage.Env env;
    private final LLVMScope globalScope;
    private final ArrayList<LLVMLocalScope> localScopes;
    private final DynamicLinkChain dynamicLinkChain;
    private final DynamicLinkChain dynamicLinkChainForScopes;
    private final List<RootCallTarget> destructorFunctions;
    private final LLVMFunctionPointerRegistry functionPointerRegistry;
    private final LLVMInteropType.InteropTypeRegistry interopTypeRegistry;
    private final Map<Thread, Object> tls = new ConcurrentHashMap<Thread, Object>();
    @CompilerDirectives.CompilationFinal(dimensions=2)
    private AssumedValue<LLVMPointer>[][] symbolStorage;
    private final LLVMNativePointer sigDfl;
    private final LLVMNativePointer sigIgn;
    private final LLVMNativePointer sigErr;
    private final LLVMPThreadContext pThreadContext;
    private LLVMFunction sulongInitContext;
    private LLVMFunction sulongDisposeContext;
    private boolean initialized;
    private boolean cleanupNecessary;
    private boolean initializeContextCalled;
    private DataLayout libsulongDatalayout;
    private Boolean datalayoutInitialised;
    private final LLVMLanguage language;
    private LLVMTracerInstrument tracer;
    private CallTarget freeGlobalBlocks;
    @CompilerDirectives.CompilationFinal
    private TargetStream loaderTraceStream;
    @CompilerDirectives.CompilationFinal
    private boolean loaderTraceStreamInitialized = false;
    @CompilerDirectives.CompilationFinal
    private TargetStream syscallTraceStream;
    @CompilerDirectives.CompilationFinal
    private boolean syscallTraceStreamInitialized = false;
    @CompilerDirectives.CompilationFinal
    private TargetStream nativeCallStatsStream;
    @CompilerDirectives.CompilationFinal
    private boolean nativeCallStatsStreamInitialized = false;
    @CompilerDirectives.CompilationFinal
    private TargetStream lifetimeAnalysisStream;
    @CompilerDirectives.CompilationFinal
    private boolean lifetimeAnalysisStreamInitialized = false;
    @CompilerDirectives.CompilationFinal
    private TargetStream llDebugVerboseStream;
    @CompilerDirectives.CompilationFinal
    private boolean llDebugVerboseStreamInitialized = false;

    LLVMContext(LLVMLanguage language, TruffleLanguage.Env env, Toolchain toolchain) {
        this.language = language;
        this.libsulongDatalayout = null;
        this.datalayoutInitialised = false;
        this.env = env;
        this.initialized = false;
        this.cleanupNecessary = false;
        this.destructorFunctions = new ArrayList<RootCallTarget>();
        this.nativeCallStatistics = SulongEngineOption.optionEnabled((String)env.getOptions().get(SulongEngineOption.NATIVE_CALL_STATS)) ? new ConcurrentHashMap() : null;
        this.sigDfl = LLVMNativePointer.create(0L);
        this.sigIgn = LLVMNativePointer.create(1L);
        this.sigErr = LLVMNativePointer.create(-1L);
        LLVMMemory memory = language.getLLVMMemory();
        this.handleContainer = memory.createHandleContainer(false, language.getNoCommonHandleAssumption());
        this.derefHandleContainer = memory.createHandleContainer(true, language.getNoDerefHandleAssumption());
        this.functionPointerRegistry = new LLVMFunctionPointerRegistry();
        this.interopTypeRegistry = new LLVMInteropType.InteropTypeRegistry();
        this.sourceContext = new LLVMSourceContext();
        this.toolchain = toolchain;
        this.internalLibraryNames = Collections.unmodifiableList(Arrays.asList(language.getCapability(PlatformCapability.class).getSulongDefaultLibraries()));
        assert (!this.internalLibraryNames.isEmpty()) : "No internal libraries?";
        this.globalScope = new LLVMScope();
        this.localScopes = new ArrayList();
        this.dynamicLinkChain = new DynamicLinkChain();
        this.dynamicLinkChainForScopes = new DynamicLinkChain();
        this.mainArguments = LLVMContext.getMainArguments(env);
        this.addLibraryPaths(SulongEngineOption.getPolyglotOptionSearchPaths(env));
        this.pThreadContext = new LLVMPThreadContext(this);
        this.symbolStorage = new AssumedValue[10][];
    }

    boolean patchContext(TruffleLanguage.Env newEnv) {
        if (this.initializeContextCalled) {
            return false;
        }
        this.env = newEnv;
        this.nativeCallStatistics = SulongEngineOption.optionEnabled((String)this.env.getOptions().get(SulongEngineOption.NATIVE_CALL_STATS)) ? new ConcurrentHashMap() : null;
        this.mainArguments = LLVMContext.getMainArguments(newEnv);
        return true;
    }

    private static Object[] getMainArguments(TruffleLanguage.Env environment) {
        Object mainArgs = environment.getConfig().get("Sulong Main Args");
        return mainArgs == null ? environment.getApplicationArguments() : (Object[])mainArgs;
    }

    public void setSulongInitContext(LLVMFunction function) {
        this.sulongInitContext = function;
    }

    public void setSulongDisposeContext(LLVMFunction function) {
        this.sulongDisposeContext = function;
    }

    void initialize(List<ContextExtension> contextExtens) {
        this.initializeContextCalled = true;
        assert (this.threadingStack == null);
        this.contextExtensions = contextExtens;
        String traceOption = (String)this.env.getOptions().get(SulongEngineOption.TRACE_IR);
        if (SulongEngineOption.optionEnabled(traceOption)) {
            if (!((Boolean)this.env.getOptions().get(SulongEngineOption.LL_DEBUG)).booleanValue()) {
                throw new IllegalStateException("'--llvm.traceIR' requires '--llvm.llDebug=true'");
            }
            this.tracer = new LLVMTracerInstrument(this.env, traceOption);
        }
        this.threadingStack = new LLVMThreadingStack(Thread.currentThread(), LLVMContext.parseStackSize((String)this.env.getOptions().get(SulongEngineOption.STACK_SIZE)));
        for (ContextExtension ext : this.getContextExtensions()) {
            ext.initialize();
        }
        String languageHome = this.language.getLLVMLanguageHome();
        if (languageHome != null) {
            PlatformCapability sysContextExt = this.language.getCapability(PlatformCapability.class);
            this.internalLibraryPath = Paths.get(languageHome, new String[0]).resolve(sysContextExt.getSulongLibrariesPath());
            this.internalLibraryPathFile = this.env.getInternalTruffleFile(this.internalLibraryPath.toUri());
            this.addLibraryPath(this.internalLibraryPath.toString());
        }
        try {
            CallTarget libpolyglotMock = this.env.parseInternal(Source.newBuilder((String)"llvm", (TruffleFile)this.env.getInternalTruffleFile(this.internalLibraryPath.resolve(this.language.getCapability(PlatformCapability.class).getPolyglotMockLibrary()).toUri())).internal(true).build(), new String[0]);
            libpolyglotMock.call(new Object[0]);
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    private List<ContextExtension> getContextExtensions() {
        this.verifyContextExtensionsInitialized();
        return this.contextExtensions;
    }

    public <T extends ContextExtension> T getContextExtension(Class<T> type) {
        T result = this.getContextExtensionOrNull(type);
        if (result != null) {
            return result;
        }
        throw new IllegalStateException("No context extension for: " + type);
    }

    public <T extends ContextExtension> T getContextExtensionOrNull(Class<T> type) {
        CompilerAsserts.neverPartOfCompilation();
        this.verifyContextExtensionsInitialized();
        for (ContextExtension ce : this.contextExtensions) {
            if (ce.extensionClass() != type) continue;
            return (T)((ContextExtension)type.cast(ce));
        }
        return null;
    }

    private void verifyContextExtensionsInitialized() {
        CompilerAsserts.neverPartOfCompilation();
        if (this.contextExtensions == null) {
            throw new IllegalStateException("LLVMContext is not yet initialized");
        }
    }

    public Path getInternalLibraryPath() {
        assert (this.isInitialized());
        return this.internalLibraryPath;
    }

    private static long parseStackSize(String v) {
        String valueString = v.trim();
        long scale = 1L;
        switch (valueString.charAt(valueString.length() - 1)) {
            case 'K': 
            case 'k': {
                scale = 1024L;
                break;
            }
            case 'M': 
            case 'm': {
                scale = 0x100000L;
                break;
            }
            case 'G': 
            case 'g': {
                scale = 0x40000000L;
                break;
            }
            case 'T': 
            case 't': {
                scale = 0x10000000000L;
            }
        }
        if (scale != 1L) {
            valueString = valueString.substring(0, valueString.length() - 1);
        }
        return Long.parseLong(valueString) * scale;
    }

    public boolean isInitialized() {
        return this.threadingStack != null;
    }

    public LLVMStatementNode createInitializeContextNode(FrameDescriptor rootFrame) {
        if (this.sulongInitContext == null) {
            throw new IllegalStateException("Context cannot be initialized:__sulong_init_context was not found");
        }
        return LLVMContextFactory.InitializeContextNodeGen.create(this.createFunctionDescriptor(this.sulongInitContext), rootFrame);
    }

    public Toolchain getToolchain() {
        return this.toolchain;
    }

    @CompilerDirectives.TruffleBoundary
    private LLVMManagedPointer getApplicationArguments() {
        String[] result;
        if (this.mainArguments == null) {
            result = new String[]{""};
        } else {
            result = new String[this.mainArguments.length + 1];
            result[0] = "";
            for (int i = 1; i < result.length; ++i) {
                result[i] = this.mainArguments[i - 1].toString();
            }
        }
        return LLVMContext.toTruffleObjects(result);
    }

    @CompilerDirectives.TruffleBoundary
    private static LLVMManagedPointer getEnvironmentVariables() {
        String[] result = (String[])System.getenv().entrySet().stream().map(e -> (String)e.getKey() + "=" + (String)e.getValue()).toArray(String[]::new);
        return LLVMContext.toTruffleObjects(result);
    }

    @CompilerDirectives.TruffleBoundary
    private static LLVMManagedPointer getRandomValues() {
        byte[] result = new byte[16];
        LLVMContext.secureRandom().nextBytes(result);
        return LLVMContext.toManagedPointer(new LLVMArgumentBuffer(result));
    }

    private static SecureRandom secureRandom() {
        return new SecureRandom();
    }

    public static LLVMManagedPointer toTruffleObjects(String[] values) {
        LLVMArgumentBuffer[] result = new LLVMArgumentBuffer[values.length];
        for (int i = 0; i < values.length; ++i) {
            result[i] = new LLVMArgumentBuffer(values[i]);
        }
        return LLVMContext.toManagedPointer(new LLVMArgumentBuffer.LLVMArgumentArray(result));
    }

    private static LLVMManagedPointer toManagedPointer(Object value) {
        return LLVMManagedPointer.create(value);
    }

    public void addLibsulongDataLayout(DataLayout datalayout) {
        if (this.datalayoutInitialised.booleanValue()) {
            throw new NullPointerException("The default datalayout cannot be overrwitten");
        }
        this.libsulongDatalayout = datalayout;
        this.datalayoutInitialised = true;
    }

    public DataLayout getLibsulongDataLayout() {
        return this.libsulongDatalayout;
    }

    void finalizeContext() {
        block11: {
            this.pThreadContext.joinAllThreads();
            if (this.cleanupNecessary) {
                try {
                    int index;
                    if (this.sulongDisposeContext == null) {
                        throw new IllegalStateException("Context cannot be disposed: __sulong_dispose_context was not found");
                    }
                    AssumedValue<LLVMPointer>[] functions = this.findSymbolTable(this.sulongDisposeContext.getBitcodeID(false));
                    LLVMPointer pointer = (LLVMPointer)functions[index = this.sulongDisposeContext.getSymbolIndex(false)].get();
                    if (LLVMManagedPointer.isInstance(pointer)) {
                        LLVMFunctionDescriptor functionDescriptor = (LLVMFunctionDescriptor)LLVMManagedPointer.cast(pointer).getObject();
                        RootCallTarget disposeContext = functionDescriptor.getFunctionCode().getLLVMIRFunctionSlowPath();
                        try (LLVMStack.StackPointer stackPointer = this.threadingStack.getStack().newFrame();){
                            disposeContext.call(new Object[]{stackPointer});
                            break block11;
                        }
                    }
                    throw new IllegalStateException("Context cannot be disposed: __sulong_dispose_context is not a function or enclosed inside a LLVMManagedPointer");
                }
                catch (ControlFlowException controlFlowException) {
                    // empty catch block
                }
            }
        }
    }

    @CompilerDirectives.TruffleBoundary(allowInlining=true)
    private static LLVMPointer getElement(ArrayList<LLVMPointer> list, int idx) {
        return list.get(idx);
    }

    private void initFreeGlobalBlocks(final NodeFactory nodeFactory) {
        if (this.freeGlobalBlocks == null) {
            this.freeGlobalBlocks = Truffle.getRuntime().createCallTarget(new RootNode(this.language){
                @Node.Child
                LLVMMemoryOpNode freeRo;
                @Node.Child
                LLVMMemoryOpNode freeRw;
                {
                    super(language);
                    this.freeRo = nodeFactory.createFreeGlobalsBlock(true);
                    this.freeRw = nodeFactory.createFreeGlobalsBlock(false);
                }

                public Object execute(VirtualFrame frame) {
                    LLVMPointer store;
                    int i;
                    for (i = 0; i < LLVMContext.this.globalsReadOnlyStore.size(); ++i) {
                        store = LLVMContext.getElement(LLVMContext.this.globalsReadOnlyStore, i);
                        if (store == null) continue;
                        this.freeRo.execute(store);
                    }
                    for (i = 0; i < LLVMContext.this.globalsNonPointerStore.size(); ++i) {
                        store = LLVMContext.getElement(LLVMContext.this.globalsNonPointerStore, i);
                        if (store == null) continue;
                        this.freeRw.execute(store);
                    }
                    return null;
                }
            });
        }
    }

    void dispose(LLVMMemory memory) {
        this.printNativeCallStatistics();
        if (this.isInitialized()) {
            this.threadingStack.freeMainStack(memory);
        }
        if (this.freeGlobalBlocks != null) {
            this.freeGlobalBlocks.call(new Object[0]);
        }
        for (LLVMPointer pointer : this.symbolsReverseMap.keySet()) {
            Object object;
            if (!LLVMManagedPointer.isInstance(pointer) || !((object = LLVMManagedPointer.cast(pointer).getObject()) instanceof LLVMGlobalContainer)) continue;
            ((LLVMGlobalContainer)object).dispose();
        }
        if (this.tracer != null) {
            this.tracer.dispose();
        }
        if (this.loaderTraceStream != null) {
            this.loaderTraceStream.dispose();
        }
        if (this.syscallTraceStream != null) {
            this.syscallTraceStream.dispose();
        }
        if (this.nativeCallStatsStream != null) {
            assert (this.nativeCallStatistics != null);
            this.nativeCallStatsStream.dispose();
        }
        if (this.lifetimeAnalysisStream != null) {
            this.lifetimeAnalysisStream.dispose();
        }
    }

    public List<String> preprocessDependencies(ExternalLibrary library, List<String> libraries) {
        return this.language.getCapability(PlatformCapability.class).preprocessDependencies(this, library, libraries);
    }

    public ExternalLibrary addInternalLibrary(String lib, Object reason) {
        CompilerAsserts.neverPartOfCompilation();
        ExternalLibrary newLib = this.createExternalLibrary(lib, reason, InternalLibraryLocator.INSTANCE);
        assert (newLib.isInternal()) : "Internal library not detected as internal: " + lib;
        return this.getOrAddExternalLibrary(newLib);
    }

    public ExternalLibrary addExternalLibraryDefaultLocator(String lib, Object reason) {
        return this.addExternalLibrary(lib, reason, DefaultLibraryLocator.INSTANCE);
    }

    public ExternalLibrary addExternalLibrary(String lib, Object reason, LibraryLocator locator) {
        CompilerAsserts.neverPartOfCompilation();
        ExternalLibrary newLib = this.createExternalLibrary(lib, reason, locator);
        if (this.isDefaultLibrary(newLib)) {
            return null;
        }
        ExternalLibrary existingLib = this.getOrAddExternalLibrary(newLib);
        if (existingLib == newLib) {
            return newLib;
        }
        LibraryLocator.traceAlreadyLoaded(this, existingLib);
        return null;
    }

    public ExternalLibrary findExternalLibrary(String lib, Object reason, LibraryLocator locator) {
        ExternalLibrary newLib = this.createExternalLibrary(lib, reason, locator);
        return this.getExternalLibrary(newLib);
    }

    private ExternalLibrary createExternalLibrary(String lib, Object reason, LibraryLocator locator) {
        boolean isNative = true;
        TruffleFile tf = locator.locate(this, lib, reason);
        if (tf == null) {
            Path path = Paths.get(lib, new String[0]);
            LibraryLocator.traceDelegateNative(this, path);
            return ExternalLibrary.createFromPath(path, isNative, this.isInternalLibraryPath(path));
        }
        return ExternalLibrary.createFromFile(tf, isNative, this.isInternalLibraryFile(tf));
    }

    public boolean ensureExternalLibraryAdded(ExternalLibrary newLib) {
        CompilerAsserts.neverPartOfCompilation();
        if (this.isDefaultLibrary(newLib)) {
            return false;
        }
        ExternalLibrary existingLib = this.getOrAddExternalLibrary(newLib);
        if (existingLib == newLib) {
            return true;
        }
        LibraryLocator.traceAlreadyLoaded(this, existingLib);
        return false;
    }

    public boolean isInternalLibrary(ExternalLibrary lib) {
        if (lib.getFile() != null) {
            return this.isInternalLibraryFile(lib.getFile());
        }
        if (lib.getPath() != null) {
            return this.isInternalLibraryPath(lib.getPath());
        }
        return this.isDefaultLibrary(lib);
    }

    private boolean isDefaultLibrary(ExternalLibrary lib) {
        return this.internalLibraryNames.contains(lib.getName());
    }

    private boolean isInternalLibraryPath(Path path) {
        return path.normalize().startsWith(this.internalLibraryPath);
    }

    private boolean isInternalLibraryFile(TruffleFile file) {
        return file.normalize().startsWith(this.internalLibraryPathFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ExternalLibrary getExternalLibrary(ExternalLibrary externalLib) {
        Object object = this.externalLibrariesLock;
        synchronized (object) {
            int index = this.externalLibraries.indexOf(externalLib);
            if (index >= 0) {
                ExternalLibrary ret = this.externalLibraries.get(index);
                assert (ret.equals(externalLib));
                return ret;
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ExternalLibrary getOrAddExternalLibrary(ExternalLibrary externalLib) {
        Object object = this.externalLibrariesLock;
        synchronized (object) {
            int index = this.externalLibraries.indexOf(externalLib);
            if (index >= 0) {
                ExternalLibrary ret = this.externalLibraries.get(index);
                assert (ret.equals(externalLib));
                return ret;
            }
            this.externalLibraries.add(externalLib);
            return externalLib;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ExternalLibrary> getExternalLibraries(Predicate<ExternalLibrary> filter) {
        Object object = this.externalLibrariesLock;
        synchronized (object) {
            return this.externalLibraries.stream().filter(f -> filter.test((ExternalLibrary)f)).collect(Collectors.toList());
        }
    }

    public void addLibraryPaths(List<String> paths) {
        for (String p : paths) {
            this.addLibraryPath(p);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addLibraryPath(String p) {
        Path path = Paths.get(p, new String[0]);
        TruffleFile file = this.getEnv().getInternalTruffleFile(path.toString());
        if (file.isDirectory(new LinkOption[0])) {
            Object object = this.libraryPathsLock;
            synchronized (object) {
                if (!this.libraryPaths.contains(path)) {
                    this.libraryPaths.add(path);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List<Path> getLibraryPaths() {
        Object object = this.libraryPathsLock;
        synchronized (object) {
            return this.libraryPaths;
        }
    }

    public LLVMLanguage getLanguage() {
        return this.language;
    }

    public TruffleLanguage.Env getEnv() {
        return this.env;
    }

    public LLVMScope getGlobalScope() {
        return this.globalScope;
    }

    public void addLocalScope(LLVMLocalScope scope) {
        this.localScopes.add(scope);
    }

    public AssumedValue<LLVMPointer>[] findSymbolTable(int id) {
        return this.symbolStorage[id];
    }

    public boolean symbolTableExists(int id) {
        return id < this.symbolStorage.length && this.symbolStorage[id] != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CompilerDirectives.TruffleBoundary
    public void registerSymbolTable(int index, AssumedValue<LLVMPointer>[] target) {
        LLVMContext lLVMContext = this;
        synchronized (lLVMContext) {
            if (index < this.symbolStorage.length && this.symbolStorage[index] == null) {
                this.symbolStorage[index] = target;
            } else if (index >= this.symbolStorage.length) {
                int newLength = index + 1 + (index + 1) / 2;
                AssumedValue[][] temp = new AssumedValue[newLength][];
                System.arraycopy(this.symbolStorage, 0, temp, 0, this.symbolStorage.length);
                this.symbolStorage = temp;
                this.symbolStorage[index] = target;
            } else {
                throw new IllegalStateException("Registering a new symbol table for an existing id. ");
            }
        }
    }

    @CompilerDirectives.TruffleBoundary
    public Object getThreadLocalStorage() {
        Object value = this.tls.get(Thread.currentThread());
        if (value != null) {
            return value;
        }
        return LLVMNativePointer.createNull();
    }

    @CompilerDirectives.TruffleBoundary
    public void setThreadLocalStorage(Object value) {
        this.tls.put(Thread.currentThread(), value);
    }

    @CompilerDirectives.TruffleBoundary
    public LLVMFunctionDescriptor getFunctionDescriptor(LLVMNativePointer handle) {
        return this.functionPointerRegistry.getDescriptor(handle);
    }

    @CompilerDirectives.TruffleBoundary
    public LLVMFunctionDescriptor createFunctionDescriptor(LLVMFunction functionDetail) {
        return this.functionPointerRegistry.create(functionDetail);
    }

    @CompilerDirectives.TruffleBoundary
    public void registerFunctionPointer(LLVMNativePointer address, LLVMFunctionDescriptor descriptor) {
        this.functionPointerRegistry.register(address, descriptor);
    }

    public LLVMNativePointer getSigDfl() {
        return this.sigDfl;
    }

    public LLVMNativePointer getSigIgn() {
        return this.sigIgn;
    }

    public LLVMNativePointer getSigErr() {
        return this.sigErr;
    }

    public LLVMMemory.HandleContainer getHandleContainer() {
        return this.handleContainer;
    }

    public LLVMMemory.HandleContainer getDerefHandleContainer() {
        return this.derefHandleContainer;
    }

    @CompilerDirectives.TruffleBoundary
    public void registerNativeCall(LLVMFunctionDescriptor descriptor) {
        if (this.nativeCallStatistics != null) {
            String name = descriptor.getLLVMFunction().getName() + " " + descriptor.getLLVMFunction().getType();
            if (this.nativeCallStatistics.containsKey(name)) {
                int count = this.nativeCallStatistics.get(name) + 1;
                this.nativeCallStatistics.put(name, count);
            } else {
                this.nativeCallStatistics.put(name, 1);
            }
        }
    }

    public List<LLVMNativePointer> getCaughtExceptionStack() {
        return this.caughtExceptionStack;
    }

    public LLVMThreadingStack getThreadingStack() {
        assert (this.threadingStack != null);
        return this.threadingStack;
    }

    public void registerDestructorFunctions(RootCallTarget destructor) {
        assert (destructor != null);
        assert (!this.destructorFunctions.contains(destructor));
        this.destructorFunctions.add(destructor);
    }

    @CompilerDirectives.TruffleBoundary
    public boolean isScopeLoaded(LLVMScope scope) {
        return this.dynamicLinkChain.containsScope(scope);
    }

    @CompilerDirectives.TruffleBoundary
    public void registerScope(LLVMScope scope) {
        this.dynamicLinkChain.addScope(scope);
    }

    @CompilerDirectives.TruffleBoundary
    public boolean isScopeLoadedForScopes(LLVMScope scope) {
        return this.dynamicLinkChainForScopes.containsScope(scope);
    }

    @CompilerDirectives.TruffleBoundary
    public void registerScopeForScopes(LLVMScope scope) {
        this.dynamicLinkChainForScopes.addScope(scope);
    }

    public synchronized void registerThread(LLVMThread thread) {
        assert (!this.runningThreads.contains(thread));
        this.runningThreads.add(thread);
    }

    public synchronized void unregisterThread(LLVMThread thread) {
        this.runningThreads.remove(thread);
        assert (!this.runningThreads.contains(thread));
    }

    @CompilerDirectives.TruffleBoundary
    public synchronized void shutdownThreads() {
        for (LLVMThread node : new ArrayList<LLVMThread>(this.runningThreads)) {
            node.stop();
        }
    }

    @CompilerDirectives.TruffleBoundary
    public synchronized void awaitThreadTermination() {
        this.shutdownThreads();
        while (!this.runningThreads.isEmpty()) {
            LLVMThread node = this.runningThreads.get(0);
            node.awaitFinish();
            assert (!this.runningThreads.contains(node));
        }
    }

    public RootCallTarget[] getDestructorFunctions() {
        return this.destructorFunctions.toArray(new RootCallTarget[this.destructorFunctions.size()]);
    }

    public synchronized List<LLVMThread> getRunningThreads() {
        return Collections.unmodifiableList(this.runningThreads);
    }

    public LLVMSourceContext getSourceContext() {
        return this.sourceContext;
    }

    @CompilerDirectives.TruffleBoundary
    public LLVMGlobal findGlobal(LLVMPointer pointer) {
        List<LLVMSymbol> symbols = this.symbolsReverseMap.get(pointer);
        if (symbols == null) {
            return null;
        }
        return symbols.get(0).asGlobalVariable();
    }

    @CompilerDirectives.TruffleBoundary
    public List<LLVMSymbol> findSymbols(LLVMPointer pointer) {
        return this.symbolsReverseMap.get(pointer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CompilerDirectives.TruffleBoundary
    public void registerReadOnlyGlobals(LLVMPointer nonPointerStore, NodeFactory nodeFactory) {
        Object object = this.globalsStoreLock;
        synchronized (object) {
            this.initFreeGlobalBlocks(nodeFactory);
            this.globalsReadOnlyStore.add(nonPointerStore);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CompilerDirectives.TruffleBoundary
    public void registerGlobals(LLVMPointer nonPointerStore, NodeFactory nodeFactory) {
        Object object = this.globalsStoreLock;
        synchronized (object) {
            this.initFreeGlobalBlocks(nodeFactory);
            this.globalsNonPointerStore.add(nonPointerStore);
        }
    }

    @CompilerDirectives.TruffleBoundary
    public void registerSymbolReverseMap(List<LLVMSymbol> symbols, LLVMPointer pointer) {
        this.symbolsReverseMap.put(pointer, symbols);
    }

    @CompilerDirectives.TruffleBoundary
    public void registerSymbol(LLVMSymbol symbol, LLVMPointer pointer) {
        this.symbolsReverseMap.get(pointer).add(symbol);
    }

    @CompilerDirectives.TruffleBoundary
    public List<LLVMSymbol> removeSymbolReverseMap(LLVMPointer pointer) {
        return this.symbolsReverseMap.remove(pointer);
    }

    public void setCleanupNecessary(boolean value) {
        this.cleanupNecessary = value;
    }

    @CompilerDirectives.TruffleBoundary
    public LLVMInteropType getInteropType(LLVMSourceType sourceType) {
        return this.interopTypeRegistry.get(sourceType);
    }

    private void printNativeCallStatistics() {
        if (this.nativeCallStatistics != null) {
            LinkedHashMap sorted = this.nativeCallStatistics.entrySet().stream().sorted(Map.Entry.comparingByValue()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (e1, e2) -> e1, LinkedHashMap::new));
            TargetStream stream = this.nativeCallStatsStream();
            for (String s : sorted.keySet()) {
                stream.printf("Function %s \t count: %d\n", s, sorted.get(s));
            }
        }
    }

    public LLVMPThreadContext getpThreadContext() {
        return this.pThreadContext;
    }

    public TargetStream loaderTraceStream() {
        if (!this.loaderTraceStreamInitialized) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            String opt = (String)this.env.getOptions().get(SulongEngineOption.LD_DEBUG);
            if (SulongEngineOption.optionEnabled(opt)) {
                this.loaderTraceStream = new TargetStream(this.env, opt);
            }
            this.loaderTraceStreamInitialized = true;
        }
        return this.loaderTraceStream;
    }

    public TargetStream syscallTraceStream() {
        if (!this.syscallTraceStreamInitialized) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            String opt = (String)this.env.getOptions().get(SulongEngineOption.DEBUG_SYSCALLS);
            if (SulongEngineOption.optionEnabled(opt)) {
                this.syscallTraceStream = new TargetStream(this.env, opt);
            }
            this.syscallTraceStreamInitialized = true;
        }
        return this.syscallTraceStream;
    }

    public TargetStream nativeCallStatsStream() {
        if (!this.nativeCallStatsStreamInitialized) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            String opt = (String)this.env.getOptions().get(SulongEngineOption.NATIVE_CALL_STATS);
            if (SulongEngineOption.optionEnabled(opt)) {
                this.nativeCallStatsStream = new TargetStream(this.env, opt);
            }
            this.nativeCallStatsStreamInitialized = true;
        }
        return this.nativeCallStatsStream;
    }

    public TargetStream lifetimeAnalysisStream() {
        if (!this.lifetimeAnalysisStreamInitialized) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            String opt = (String)this.env.getOptions().get(SulongEngineOption.PRINT_LIFE_TIME_ANALYSIS_STATS);
            if (SulongEngineOption.optionEnabled(opt)) {
                this.lifetimeAnalysisStream = new TargetStream(this.env, opt);
            }
            this.lifetimeAnalysisStreamInitialized = true;
        }
        return this.lifetimeAnalysisStream;
    }

    public TargetStream llDebugVerboseStream() {
        if (!this.llDebugVerboseStreamInitialized) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            String opt = (String)this.env.getOptions().get(SulongEngineOption.LL_DEBUG_VERBOSE);
            if (SulongEngineOption.optionEnabled(opt)) {
                if (!((Boolean)this.env.getOptions().get(SulongEngineOption.LL_DEBUG)).booleanValue()) {
                    throw new IllegalStateException("'--llvm.llDebug.verbose' requires '--llvm.llDebug=true'");
                }
                this.llDebugVerboseStream = new TargetStream(this.env, opt);
            }
            this.llDebugVerboseStreamInitialized = true;
        }
        return this.llDebugVerboseStream;
    }

    private static class DynamicLinkChain {
        private final ArrayList<LLVMScope> scopes = new ArrayList();

        DynamicLinkChain() {
        }

        private void addScope(LLVMScope newScope) {
            assert (!this.scopes.contains(newScope));
            this.scopes.add(newScope);
        }

        private boolean containsScope(LLVMScope scope) {
            return this.scopes.contains(scope);
        }
    }

    private static final class InternalLibraryLocator
    extends LibraryLocator {
        public static final InternalLibraryLocator INSTANCE = new InternalLibraryLocator();

        private InternalLibraryLocator() {
        }

        @Override
        protected TruffleFile locateLibrary(LLVMContext context, String lib, Object reason) {
            if (context.internalLibraryPath == null) {
                throw new LLVMLinkerException(String.format("Cannot load \"%s\". Internal library path not set", lib));
            }
            TruffleFile absPath = context.internalLibraryPathFile.resolve(lib);
            if (absPath.exists(new LinkOption[0])) {
                return absPath;
            }
            return context.env.getInternalTruffleFile(lib);
        }
    }

    static abstract class InitializeContextNode
    extends LLVMStatementNode {
        @CompilerDirectives.CompilationFinal
        private TruffleLanguage.ContextReference<LLVMContext> ctxRef;
        private final FrameSlot stackPointer;
        @Node.Child
        DirectCallNode initContext;

        InitializeContextNode(LLVMFunctionDescriptor initContextDescriptor, FrameDescriptor rootFrame) {
            this.stackPointer = rootFrame.findFrameSlot((Object)"<stackpointer>");
            RootCallTarget initContextFunction = initContextDescriptor.getFunctionCode().getLLVMIRFunctionSlowPath();
            this.initContext = DirectCallNode.create((CallTarget)initContextFunction);
        }

        @Specialization
        public void doInit(VirtualFrame frame) {
            LLVMContext ctx;
            if (this.ctxRef == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.ctxRef = this.lookupContextReference(LLVMLanguage.class);
            }
            if (!(ctx = (LLVMContext)this.ctxRef.get()).initialized) {
                assert (!ctx.cleanupNecessary);
                ctx.initialized = true;
                ctx.cleanupNecessary = true;
                try (LLVMStack.StackPointer sp = ((LLVMStack.StackPointer)FrameUtil.getObjectSafe((Frame)frame, (FrameSlot)this.stackPointer)).newFrame();){
                    Object[] args = new Object[]{sp, ctx.getApplicationArguments(), LLVMContext.getEnvironmentVariables(), LLVMContext.getRandomValues()};
                    this.initContext.call(args);
                }
            }
        }
    }

    private final class LLVMFunctionPointerRegistry {
        private final HashMap<LLVMNativePointer, LLVMFunctionDescriptor> functionDescriptors = new HashMap();

        private LLVMFunctionPointerRegistry() {
        }

        synchronized LLVMFunctionDescriptor getDescriptor(LLVMNativePointer pointer) {
            return this.functionDescriptors.get(pointer);
        }

        synchronized void register(LLVMNativePointer pointer, LLVMFunctionDescriptor desc) {
            this.functionDescriptors.put(pointer, desc);
        }

        synchronized LLVMFunctionDescriptor create(LLVMFunction functionDetail) {
            return new LLVMFunctionDescriptor(LLVMContext.this, functionDetail);
        }
    }
}

