/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime;

import com.oracle.truffle.api.Assumption;
import com.oracle.truffle.api.CallTarget;
import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.Scope;
import com.oracle.truffle.api.Truffle;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.debug.DebuggerTags;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.instrumentation.ProvidedTags;
import com.oracle.truffle.api.instrumentation.StandardTags;
import com.oracle.truffle.api.nodes.ExecutableNode;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.Layout;
import com.oracle.truffle.api.object.ObjectType;
import com.oracle.truffle.api.object.Shape;
import com.oracle.truffle.api.source.Source;
import com.oracle.truffle.llvm.api.Toolchain;
import com.oracle.truffle.llvm.runtime.LLVMContext;
import com.oracle.truffle.llvm.runtime.LLVMFileDetector;
import com.oracle.truffle.llvm.runtime.ToolchainConfig;
import com.oracle.truffle.llvm.runtime.ToolchainImpl;
import com.oracle.truffle.llvm.runtime.config.Configuration;
import com.oracle.truffle.llvm.runtime.config.Configurations;
import com.oracle.truffle.llvm.runtime.config.LLVMCapability;
import com.oracle.truffle.llvm.runtime.debug.LLDBSupport;
import com.oracle.truffle.llvm.runtime.debug.debugexpr.nodes.DebugExprExecutableNode;
import com.oracle.truffle.llvm.runtime.debug.debugexpr.parser.DebugExprException;
import com.oracle.truffle.llvm.runtime.debug.debugexpr.parser.antlr.DebugExprParser;
import com.oracle.truffle.llvm.runtime.debug.scope.LLVMDebuggerScopeFactory;
import com.oracle.truffle.llvm.runtime.except.LLVMParserException;
import com.oracle.truffle.llvm.runtime.memory.LLVMMemory;
import com.oracle.truffle.llvm.runtime.options.SulongEngineOption;
import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.atomic.AtomicInteger;
import org.graalvm.options.OptionDescriptors;

@TruffleLanguage.Registration(id="llvm", name="LLVM", internal=false, interactive=false, defaultMimeType="application/x-llvm-ir-bitcode", byteMimeTypes={"application/x-llvm-ir-bitcode", "application/x-sharedlib", "application/x-executable", "application/x-mach-binary"}, fileTypeDetectors={LLVMFileDetector.class}, services={Toolchain.class})
@ProvidedTags(value={StandardTags.StatementTag.class, StandardTags.CallTag.class, StandardTags.RootTag.class, StandardTags.RootBodyTag.class, DebuggerTags.AlwaysHalt.class})
public class LLVMLanguage
extends TruffleLanguage<LLVMContext> {
    static final Layout GLOBAL_LAYOUT = Layout.createLayout();
    Shape emptyGlobalShape = GLOBAL_LAYOUT.createShape((ObjectType)GlobalObjectType.access$000());
    static final String LLVM_BITCODE_MIME_TYPE = "application/x-llvm-ir-bitcode";
    static final String LLVM_BITCODE_EXTENSION = "bc";
    static final String LLVM_ELF_SHARED_MIME_TYPE = "application/x-sharedlib";
    static final String LLVM_ELF_EXEC_MIME_TYPE = "application/x-executable";
    static final String LLVM_ELF_LINUX_EXTENSION = "so";
    static final String LLVM_MACHO_MIME_TYPE = "application/x-mach-binary";
    static final String MAIN_ARGS_KEY = "Sulong Main Args";
    static final String PARSE_ONLY_KEY = "Parse only";
    public static final String ID = "llvm";
    static final String NAME = "LLVM";
    private final AtomicInteger nextID = new AtomicInteger(1);
    @CompilerDirectives.CompilationFinal
    private Configuration activeConfiguration = null;
    @CompilerDirectives.CompilationFinal
    private LLVMMemory cachedLLVMMemory;
    private final LLDBSupport lldbSupport = new LLDBSupport(this);
    private final Assumption noCommonHandleAssumption = Truffle.getRuntime().createAssumption("no common handle");
    private final Assumption noDerefHandleAssumption = Truffle.getRuntime().createAssumption("no deref handle");

    public LLVMLanguage() {
        this.noCommonHandleAssumption.isValid();
    }

    protected void initializeContext(LLVMContext context) {
        context.initialize(this.activeConfiguration.createContextExtensions(context.getEnv()));
    }

    public static LLVMContext getContext() {
        CompilerAsserts.neverPartOfCompilation((String)"Use faster context lookup methods for the fast-path.");
        return (LLVMContext)LLVMLanguage.getCurrentContext(LLVMLanguage.class);
    }

    public static LLVMLanguage getLanguage() {
        return (LLVMLanguage)LLVMLanguage.getCurrentLanguage(LLVMLanguage.class);
    }

    public static LLDBSupport getLLDBSupport() {
        return LLVMLanguage.getLanguage().lldbSupport;
    }

    public <C extends LLVMCapability> C getCapability(Class<C> type) {
        CompilerAsserts.partialEvaluationConstant(type);
        if (type == LLVMMemory.class) {
            return (C)((LLVMCapability)type.cast(this.getLLVMMemory()));
        }
        C ret = this.activeConfiguration.getCapability(type);
        if (CompilerDirectives.isPartialEvaluationConstant((Object)((Object)this))) {
            CompilerAsserts.partialEvaluationConstant(ret);
        }
        return ret;
    }

    public Assumption getNoCommonHandleAssumption() {
        return this.noCommonHandleAssumption;
    }

    public Assumption getNoDerefHandleAssumption() {
        return this.noDerefHandleAssumption;
    }

    public final String getLLVMLanguageHome() {
        return this.getLanguageHome();
    }

    public Configuration getActiveConfiguration() {
        if (this.activeConfiguration != null) {
            return this.activeConfiguration;
        }
        throw new IllegalStateException("No context, please create the context before accessing the configuration.");
    }

    public LLVMMemory getLLVMMemory() {
        assert (this.cachedLLVMMemory != null);
        return this.cachedLLVMMemory;
    }

    protected LLVMContext createContext(TruffleLanguage.Env env) {
        if (this.activeConfiguration == null) {
            this.activeConfiguration = Configurations.createConfiguration(this, env.getOptions());
            this.cachedLLVMMemory = this.activeConfiguration.getCapability(LLVMMemory.class);
        }
        ToolchainImpl toolchain = new ToolchainImpl(this.activeConfiguration.getCapability(ToolchainConfig.class), this);
        env.registerService((Object)toolchain);
        LLVMContext context = new LLVMContext(this, env, toolchain);
        return context;
    }

    protected ExecutableNode parse(TruffleLanguage.InlineParsingRequest request) {
        Collection<Scope> globalScopes = this.findTopScopes((LLVMContext)LLVMLanguage.getCurrentContext(LLVMLanguage.class));
        DebugExprParser d = new DebugExprParser(request, globalScopes, (LLVMContext)LLVMLanguage.getCurrentContext(LLVMLanguage.class));
        try {
            return new DebugExprExecutableNode(d.parse());
        }
        catch (DebugExprException | LLVMParserException e) {
            final String errorMessage = e.getMessage();
            return new ExecutableNode(this){

                public Object execute(VirtualFrame frame) {
                    return errorMessage;
                }
            };
        }
    }

    protected boolean patchContext(LLVMContext context, TruffleLanguage.Env newEnv) {
        boolean compatible = Configurations.areOptionsCompatible(context.getEnv().getOptions(), newEnv.getOptions());
        if (!compatible) {
            return false;
        }
        return context.patchContext(newEnv);
    }

    protected void finalizeContext(LLVMContext context) {
        context.finalizeContext();
    }

    protected void disposeContext(LLVMContext context) {
        LLVMMemory memory = this.getLLVMMemory();
        context.dispose(memory);
    }

    public AtomicInteger getRawRunnerID() {
        return this.nextID;
    }

    protected CallTarget parse(TruffleLanguage.ParsingRequest request) {
        Source source = request.getSource();
        return this.getCapability(Loader.class).load(LLVMLanguage.getContext(), source, this.nextID);
    }

    protected Collection<Scope> findTopScopes(LLVMContext context) {
        Scope scope = Scope.newBuilder((String)"llvm-global", (Object)context.getGlobalScope()).build();
        return Collections.singleton(scope);
    }

    protected OptionDescriptors getOptionDescriptors() {
        return Configurations.getOptionDescriptors();
    }

    protected boolean isThreadAccessAllowed(Thread thread, boolean singleThreaded) {
        return true;
    }

    protected void disposeThread(LLVMContext context, Thread thread) {
        super.disposeThread((Object)context, thread);
        if (context.isInitialized()) {
            context.getThreadingStack().freeStack(this.getLLVMMemory(), thread);
        }
    }

    protected Iterable<Scope> findLocalScopes(LLVMContext context, Node node, Frame frame) {
        if (((Boolean)context.getEnv().getOptions().get(SulongEngineOption.LL_DEBUG)).booleanValue()) {
            return LLVMDebuggerScopeFactory.createIRLevelScope(node, frame, context);
        }
        return LLVMDebuggerScopeFactory.createSourceLevelScope(node, frame, context);
    }

    public static abstract class Loader
    implements LLVMCapability {
        public abstract CallTarget load(LLVMContext var1, Source var2, AtomicInteger var3);
    }

    static class GlobalObjectType
    extends ObjectType {
        private static final GlobalObjectType INSTANCE = new GlobalObjectType();

        GlobalObjectType() {
        }

        static /* synthetic */ GlobalObjectType access$000() {
            return INSTANCE;
        }
    }
}

