/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.llvm.runtime.ExternalLibrary;
import com.oracle.truffle.llvm.runtime.LLVMContext;
import com.oracle.truffle.llvm.runtime.LLVMSyscallEntry;
import com.oracle.truffle.llvm.runtime.config.LLVMCapability;
import com.oracle.truffle.llvm.runtime.memory.LLVMSyscallOperationNode;
import java.lang.reflect.Array;
import java.nio.file.Path;
import java.util.List;

public abstract class PlatformCapability<S extends Enum<S>>
implements LLVMCapability {
    @CompilerDirectives.CompilationFinal(dimensions=1)
    private final S[] valueToSysCall;

    public abstract Path getSulongLibrariesPath();

    public abstract String[] getSulongDefaultLibraries();

    public abstract LLVMSyscallOperationNode createSyscallNode(long var1);

    public abstract String getPolyglotMockLibrary();

    protected PlatformCapability(Class<S> cls) {
        this.valueToSysCall = this.initTable(cls);
    }

    private S[] initTable(Class<S> cls) {
        Enum[] constants = (Enum[])cls.getEnumConstants();
        if (constants == null) {
            return (Enum[])Array.newInstance(cls, 0);
        }
        int max = -1;
        for (Enum syscall : constants) {
            max = Math.max(max, ((LLVMSyscallEntry)((Object)syscall)).value());
        }
        Enum[] syscalls = (Enum[])Array.newInstance(cls, max + 1);
        Enum[] enumArray = constants;
        int n = enumArray.length;
        for (int i = 0; i < n; ++i) {
            Enum syscall;
            syscalls[((LLVMSyscallEntry)((Object)syscall)).value()] = syscall = enumArray[i];
        }
        return syscalls;
    }

    protected S getSyscall(long value) {
        S syscall;
        if (value >= 0L && value < (long)this.valueToSysCall.length && (syscall = this.valueToSysCall[(int)value]) != null) {
            return syscall;
        }
        throw PlatformCapability.error(value);
    }

    @CompilerDirectives.TruffleBoundary
    private static IllegalArgumentException error(long value) {
        return new IllegalArgumentException("Unknown syscall number: " + value);
    }

    public List<String> preprocessDependencies(LLVMContext context, ExternalLibrary library, List<String> dependencies) {
        return dependencies;
    }
}

