/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime;

import com.oracle.truffle.api.CallTarget;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.interop.ArityException;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.TruffleObject;
import com.oracle.truffle.api.interop.UnknownIdentifierException;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.interop.UnsupportedTypeException;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.library.ExportLibrary;
import com.oracle.truffle.api.library.ExportMessage;
import com.oracle.truffle.api.nodes.DirectCallNode;
import com.oracle.truffle.api.nodes.IndirectCallNode;
import com.oracle.truffle.api.utilities.AssumedValue;
import com.oracle.truffle.llvm.runtime.LLVMContext;
import com.oracle.truffle.llvm.runtime.LLVMFunction;
import com.oracle.truffle.llvm.runtime.LLVMFunctionDescriptor;
import com.oracle.truffle.llvm.runtime.LLVMLanguage;
import com.oracle.truffle.llvm.runtime.LLVMScope;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMNode;
import com.oracle.truffle.llvm.runtime.pointer.LLVMManagedPointer;
import com.oracle.truffle.llvm.runtime.pointer.LLVMPointer;

@ExportLibrary(value=InteropLibrary.class)
public final class SulongLibrary
implements TruffleObject {
    private final String name;
    private final LLVMScope scope;
    private final CallTarget main;
    private final LLVMContext context;

    public SulongLibrary(String name, LLVMScope scope, CallTarget main, LLVMContext context) {
        this.name = name;
        this.scope = scope;
        this.main = main;
        this.context = context;
    }

    private LLVMFunctionDescriptor lookupFunctionDescriptor(String symbolName) {
        LLVMFunction function = this.scope.getFunction(symbolName);
        if (function == null) {
            return null;
        }
        int index = function.getSymbolIndex(false);
        AssumedValue<LLVMPointer>[] symbols = this.context.findSymbolTable(function.getBitcodeID(false));
        LLVMPointer pointer = (LLVMPointer)symbols[index].get();
        LLVMFunctionDescriptor functionDescriptor = (LLVMFunctionDescriptor)LLVMManagedPointer.cast(pointer).getObject();
        return functionDescriptor;
    }

    public String getName() {
        return this.name;
    }

    @ExportMessage
    Object readMember(String member, @Cached.Shared(value="lookup") @Cached LookupNode lookup) throws UnknownIdentifierException {
        LLVMFunctionDescriptor ret = lookup.execute(this, member);
        if (ret == null) {
            CompilerDirectives.transferToInterpreter();
            throw UnknownIdentifierException.create((String)member);
        }
        return ret;
    }

    @ExportMessage
    Object invokeMember(String member, Object[] arguments, @Cached.Shared(value="lookup") @Cached LookupNode lookup, @CachedLibrary(limit="1") InteropLibrary interop) throws ArityException, UnknownIdentifierException, UnsupportedTypeException, UnsupportedMessageException {
        LLVMFunctionDescriptor fn = lookup.execute(this, member);
        if (fn == null) {
            CompilerDirectives.transferToInterpreter();
            throw UnknownIdentifierException.create((String)member);
        }
        return interop.execute((Object)fn, arguments);
    }

    @ExportMessage
    boolean hasMembers() {
        return true;
    }

    @ExportMessage
    Object getMembers(boolean includeInternal) {
        return this.scope.getKeys();
    }

    @ExportMessage.Repeat(value={@ExportMessage(name="isMemberReadable"), @ExportMessage(name="isMemberInvocable")})
    boolean memberExists(String member, @Cached.Shared(value="lookup") @Cached LookupNode lookup) {
        return lookup.execute(this, member) != null;
    }

    @ExportMessage
    boolean isExecutable() {
        return this.main != null;
    }

    @ExportMessage
    boolean hasLanguage() {
        return true;
    }

    @ExportMessage
    Class<? extends TruffleLanguage<?>> getLanguage() {
        return LLVMLanguage.class;
    }

    @ExportMessage
    @CompilerDirectives.TruffleBoundary
    String toDisplayString(boolean allowSideEffects) {
        return "LLVMLibrary:" + this.getName();
    }

    @ExportMessage
    static abstract class Execute {
        Execute() {
        }

        @Specialization(guards={"library == cachedLibrary"})
        static Object doCached(SulongLibrary library, Object[] args, @Cached(value="library") SulongLibrary cachedLibrary, @Cached(value="createMainCall(cachedLibrary)") DirectCallNode call) {
            return call.call(args);
        }

        static DirectCallNode createMainCall(SulongLibrary library) {
            return DirectCallNode.create((CallTarget)library.main);
        }

        @Specialization(replaces={"doCached"})
        static Object doGeneric(SulongLibrary library, Object[] args, @Cached(value="create()") IndirectCallNode call) {
            return call.call(library.main, args);
        }
    }

    @GenerateUncached
    static abstract class LookupNode
    extends LLVMNode {
        LookupNode() {
        }

        abstract LLVMFunctionDescriptor execute(SulongLibrary var1, String var2);

        @Specialization(guards={"library == cachedLibrary", "name.equals(cachedName)"})
        LLVMFunctionDescriptor doCached(SulongLibrary library, String name, @Cached(value="library") SulongLibrary cachedLibrary, @Cached(value="name") String cachedName, @Cached(value="lookupFunctionDescriptor(cachedLibrary, cachedName)") LLVMFunctionDescriptor cachedDescriptor) {
            return cachedDescriptor;
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization(replaces={"doCached"})
        static LLVMFunctionDescriptor doGeneric(SulongLibrary library, String name) {
            return LookupNode.lookupFunctionDescriptor(library, name);
        }

        protected static LLVMFunctionDescriptor lookupFunctionDescriptor(SulongLibrary library, String name) {
            return library.lookupFunctionDescriptor(name);
        }
    }
}

