/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.datalayout;

import com.oracle.truffle.llvm.runtime.datalayout.DataLayoutParser;
import com.oracle.truffle.llvm.runtime.datalayout.DataLayoutType;
import com.oracle.truffle.llvm.runtime.types.FunctionType;
import com.oracle.truffle.llvm.runtime.types.PointerType;
import com.oracle.truffle.llvm.runtime.types.PrimitiveType;
import com.oracle.truffle.llvm.runtime.types.Type;
import com.oracle.truffle.llvm.runtime.types.VariableBitWidthType;
import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.List;

public final class DataLayout {
    private final List<DataLayoutParser.DataTypeSpecification> dataLayout;
    private final IdentityHashMap<Type, Long> sizeCache = new IdentityHashMap();
    private final IdentityHashMap<Type, Integer> alignmentCache = new IdentityHashMap();

    public DataLayout() {
        this.dataLayout = new ArrayList<DataLayoutParser.DataTypeSpecification>();
    }

    public DataLayout(String layout) {
        this.dataLayout = DataLayoutParser.parseDataLayout(layout);
    }

    public long getSize(Type type) throws Type.TypeOverflowException {
        int align;
        Long cachedSize = this.sizeCache.get(type);
        if (cachedSize != null) {
            return cachedSize;
        }
        long size = type.getBitSize();
        long rem = Long.remainderUnsigned(size, align = this.getBitAlignment(type));
        if (rem != 0L) {
            size = Type.addUnsignedExact(size, Type.subUnsignedExact(align, rem));
        }
        size = Math.max(1L, Long.divideUnsigned(size, 8L));
        this.sizeCache.put(type, size);
        return size;
    }

    public int getBitAlignment(Type baseType) {
        Integer cachedAlignment = this.alignmentCache.get(baseType);
        if (cachedAlignment != null) {
            return cachedAlignment;
        }
        DataLayoutParser.DataTypeSpecification spec = this.getDataTypeSpecification(baseType);
        if (spec == null) {
            throw new IllegalStateException("No data specification found for " + baseType + ". Data layout is " + this.dataLayout);
        }
        int alignment = spec.getAbiAlignment();
        this.alignmentCache.put(baseType, alignment);
        return alignment;
    }

    public DataLayout merge(DataLayout other) {
        DataLayout result = new DataLayout();
        for (DataLayoutParser.DataTypeSpecification otherEntry : other.dataLayout) {
            DataLayoutParser.DataTypeSpecification thisEntry;
            if (otherEntry.getType() == DataLayoutType.POINTER || otherEntry.getType() == DataLayoutType.INTEGER_WIDTHS) {
                thisEntry = this.getDataTypeSpecification(otherEntry.getType());
            } else if (otherEntry.getType() == DataLayoutType.INTEGER || otherEntry.getType() == DataLayoutType.FLOAT) {
                thisEntry = this.getDataTypeSpecification(otherEntry.getType(), otherEntry.getSize());
            } else {
                throw new IllegalStateException("Unknown data layout type: " + (Object)((Object)otherEntry.getType()));
            }
            result.dataLayout.add(otherEntry);
            if (thisEntry == null || thisEntry.equals(otherEntry)) continue;
            throw new IllegalStateException("Multiple bitcode files with incompatible layout strings are used: " + this.toString() + " vs. " + other.toString());
        }
        return result;
    }

    public String toString() {
        return this.dataLayout.toString();
    }

    private DataLayoutParser.DataTypeSpecification getDataTypeSpecification(Type baseType) {
        if (baseType instanceof PointerType || baseType instanceof FunctionType) {
            DataLayoutParser.DataTypeSpecification ptrDTSpec = this.getDataTypeSpecification(DataLayoutType.POINTER, 64);
            return ptrDTSpec == null ? this.getDataTypeSpecification(DataLayoutType.POINTER) : ptrDTSpec;
        }
        if (baseType instanceof PrimitiveType) {
            PrimitiveType primitiveType = (PrimitiveType)baseType;
            switch (primitiveType.getPrimitiveKind()) {
                case I1: 
                case I8: {
                    return this.getDataTypeSpecification(DataLayoutType.INTEGER, 8);
                }
                case I16: {
                    return this.getDataTypeSpecification(DataLayoutType.INTEGER, 16);
                }
                case I32: {
                    return this.getDataTypeSpecification(DataLayoutType.INTEGER, 32);
                }
                case I64: {
                    return this.getDataTypeSpecification(DataLayoutType.INTEGER, 64);
                }
                case HALF: {
                    return this.getDataTypeSpecification(DataLayoutType.FLOAT, 16);
                }
                case FLOAT: {
                    return this.getDataTypeSpecification(DataLayoutType.FLOAT, 32);
                }
                case DOUBLE: {
                    return this.getDataTypeSpecification(DataLayoutType.FLOAT, 64);
                }
                case X86_FP80: {
                    return this.getDataTypeSpecification(DataLayoutType.FLOAT, 80);
                }
            }
        } else if (baseType instanceof VariableBitWidthType) {
            int bits = ((VariableBitWidthType)baseType).getBitSizeInt();
            DataLayoutParser.DataTypeSpecification largest = null;
            DataLayoutParser.DataTypeSpecification smallestLarger = null;
            for (DataLayoutParser.DataTypeSpecification spec : this.dataLayout) {
                if (spec.getType() != DataLayoutType.INTEGER) continue;
                if (largest == null || largest.getSize() < spec.getSize()) {
                    largest = spec;
                }
                if (spec.getSize() < bits || smallestLarger != null && smallestLarger.getSize() <= spec.getSize()) continue;
                smallestLarger = spec;
            }
            if (smallestLarger != null) {
                return smallestLarger;
            }
            return largest;
        }
        return null;
    }

    private DataLayoutParser.DataTypeSpecification getDataTypeSpecification(DataLayoutType dataLayoutType) {
        for (DataLayoutParser.DataTypeSpecification spec : this.dataLayout) {
            if (!spec.getType().equals((Object)dataLayoutType)) continue;
            return spec;
        }
        return null;
    }

    private DataLayoutParser.DataTypeSpecification getDataTypeSpecification(DataLayoutType dataLayoutType, int size) {
        for (DataLayoutParser.DataTypeSpecification spec : this.dataLayout) {
            if (!spec.getType().equals((Object)dataLayoutType) || size != spec.getSize()) continue;
            return spec;
        }
        return null;
    }
}

