/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.debug.debugexpr.nodes;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.library.LibraryFactory;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.llvm.runtime.debug.debugexpr.nodes.DebugExprArrayElementNode;
import com.oracle.truffle.llvm.runtime.debug.debugexpr.parser.DebugExprType;
import com.oracle.truffle.llvm.runtime.debug.scope.LLVMSourceLocation;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMExpressionNode;
import java.util.concurrent.locks.Lock;

@GeneratedBy(value=DebugExprArrayElementNode.class)
public final class DebugExprArrayElementNodeGen
extends DebugExprArrayElementNode {
    private static final LibraryFactory<InteropLibrary> INTEROP_LIBRARY_ = LibraryFactory.resolve(InteropLibrary.class);
    private LLVMSourceLocation sourceLocation;
    private boolean statement;
    @Node.Child
    private LLVMExpressionNode base_;
    @Node.Child
    private LLVMExpressionNode index_;
    @CompilerDirectives.CompilationFinal
    private volatile int state_;
    @Node.Child
    private InteropLibrary intIndex_library_;
    @Node.Child
    private InteropLibrary generic_library_;

    private DebugExprArrayElementNodeGen(DebugExprType type, LLVMExpressionNode base, LLVMExpressionNode index) {
        super(type);
        this.base_ = base;
        this.index_ = index;
    }

    @Override
    public LLVMSourceLocation getSourceLocation() {
        return this.sourceLocation;
    }

    @Override
    public void setSourceLocation(LLVMSourceLocation sourceLocation) {
        this.sourceLocation = sourceLocation;
    }

    @Override
    protected boolean isStatement() {
        return this.statement;
    }

    @Override
    protected void setStatement(boolean statement) {
        this.statement = statement;
    }

    @Override
    public Object executeGeneric(VirtualFrame frameValue) {
        int state = this.state_;
        Object baseValue_ = this.base_.executeGeneric(frameValue);
        if ((state & 2) == 0 && state != 0) {
            return this.executeGeneric_int0(frameValue, state, baseValue_);
        }
        return this.executeGeneric_generic1(frameValue, state, baseValue_);
    }

    private Object executeGeneric_int0(VirtualFrame frameValue, int state, Object baseValue_) {
        int indexValue_;
        try {
            indexValue_ = this.index_.executeI32(frameValue);
        }
        catch (UnexpectedResultException ex) {
            return this.executeAndSpecialize(baseValue_, ex.getResult());
        }
        assert ((state & 1) != 0);
        return this.doIntIndex(baseValue_, indexValue_, this.intIndex_library_);
    }

    private Object executeGeneric_generic1(VirtualFrame frameValue, int state, Object baseValue_) {
        Object indexValue_ = this.index_.executeGeneric(frameValue);
        if (state != 0) {
            if ((state & 1) != 0 && indexValue_ instanceof Integer) {
                int indexValue__ = (Integer)indexValue_;
                return this.doIntIndex(baseValue_, indexValue__, this.intIndex_library_);
            }
            if ((state & 2) != 0) {
                return this.doGeneric(baseValue_, indexValue_, this.generic_library_);
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return this.executeAndSpecialize(baseValue_, indexValue_);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object executeAndSpecialize(Object baseValue, Object indexValue) {
        Lock lock = this.getLock();
        boolean hasLock = true;
        lock.lock();
        int state = this.state_;
        try {
            if (indexValue instanceof Integer) {
                int indexValue_ = (Integer)indexValue;
                this.intIndex_library_ = (InteropLibrary)super.insert((Node)((InteropLibrary)INTEROP_LIBRARY_.createDispatched(3)));
                this.state_ = state |= 1;
                lock.unlock();
                hasLock = false;
                Object object = this.doIntIndex(baseValue, indexValue_, this.intIndex_library_);
                return object;
            }
            this.generic_library_ = (InteropLibrary)super.insert((Node)((InteropLibrary)INTEROP_LIBRARY_.createDispatched(3)));
            this.state_ = state |= 2;
            lock.unlock();
            hasLock = false;
            Object object = this.doGeneric(baseValue, indexValue, this.generic_library_);
            return object;
        }
        finally {
            if (hasLock) {
                lock.unlock();
            }
        }
    }

    public NodeCost getCost() {
        int state = this.state_;
        if (state == 0) {
            return NodeCost.UNINITIALIZED;
        }
        if ((state & state - 1) == 0) {
            return NodeCost.MONOMORPHIC;
        }
        return NodeCost.POLYMORPHIC;
    }

    public static DebugExprArrayElementNode create(DebugExprType type, LLVMExpressionNode base, LLVMExpressionNode index) {
        return new DebugExprArrayElementNodeGen(type, base, index);
    }
}

