/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.debug.debugexpr.nodes;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.llvm.runtime.debug.debugexpr.nodes.DebugExprTernaryNode;
import com.oracle.truffle.llvm.runtime.debug.scope.LLVMSourceLocation;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMExpressionNode;

@GeneratedBy(value=DebugExprTernaryNode.class)
public final class DebugExprTernaryNodeGen
extends DebugExprTernaryNode {
    private LLVMSourceLocation sourceLocation;
    private boolean statement;
    @Node.Child
    private LLVMExpressionNode condition_;
    @CompilerDirectives.CompilationFinal
    private int state_;

    private DebugExprTernaryNodeGen(LLVMExpressionNode thenNode, LLVMExpressionNode elseNode, LLVMExpressionNode condition) {
        super(thenNode, elseNode);
        this.condition_ = condition;
    }

    @Override
    public LLVMSourceLocation getSourceLocation() {
        return this.sourceLocation;
    }

    @Override
    public void setSourceLocation(LLVMSourceLocation sourceLocation) {
        this.sourceLocation = sourceLocation;
    }

    @Override
    protected boolean isStatement() {
        return this.statement;
    }

    @Override
    protected void setStatement(boolean statement) {
        this.statement = statement;
    }

    @Override
    public Object executeWithTarget(VirtualFrame frameValue, Object conditionValue) {
        int state = this.state_;
        if ((state & 1) != 0 && conditionValue instanceof Boolean) {
            boolean conditionValue_ = (Boolean)conditionValue;
            return this.doTernary(frameValue, conditionValue_);
        }
        if ((state & 2) != 0 && conditionValue instanceof Integer) {
            int conditionValue_ = (Integer)conditionValue;
            return this.doTernary(frameValue, conditionValue_);
        }
        if ((state & 4) != 0 && conditionValue instanceof Long) {
            long conditionValue_ = (Long)conditionValue;
            return this.doTernary(frameValue, conditionValue_);
        }
        if ((state & 8) != 0 && DebugExprTernaryNodeGen.fallbackGuard_(state, conditionValue)) {
            return this.doError(conditionValue);
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return this.executeAndSpecialize(frameValue, conditionValue);
    }

    @Override
    public Object executeGeneric(VirtualFrame frameValue) {
        int state = this.state_;
        if ((state & 0xE) == 0 && state != 0) {
            return this.executeGeneric_boolean0(frameValue, state);
        }
        if ((state & 0xD) == 0 && state != 0) {
            return this.executeGeneric_int1(frameValue, state);
        }
        if ((state & 0xB) == 0 && state != 0) {
            return this.executeGeneric_long2(frameValue, state);
        }
        return this.executeGeneric_generic3(frameValue, state);
    }

    private Object executeGeneric_boolean0(VirtualFrame frameValue, int state) {
        boolean conditionValue_;
        try {
            conditionValue_ = this.condition_.executeI1(frameValue);
        }
        catch (UnexpectedResultException ex) {
            return this.executeAndSpecialize(frameValue, ex.getResult());
        }
        assert ((state & 1) != 0);
        return this.doTernary(frameValue, conditionValue_);
    }

    private Object executeGeneric_int1(VirtualFrame frameValue, int state) {
        int conditionValue_;
        try {
            conditionValue_ = this.condition_.executeI32(frameValue);
        }
        catch (UnexpectedResultException ex) {
            return this.executeAndSpecialize(frameValue, ex.getResult());
        }
        assert ((state & 2) != 0);
        return this.doTernary(frameValue, conditionValue_);
    }

    private Object executeGeneric_long2(VirtualFrame frameValue, int state) {
        long conditionValue_;
        try {
            conditionValue_ = this.condition_.executeI64(frameValue);
        }
        catch (UnexpectedResultException ex) {
            return this.executeAndSpecialize(frameValue, ex.getResult());
        }
        assert ((state & 4) != 0);
        return this.doTernary(frameValue, conditionValue_);
    }

    private Object executeGeneric_generic3(VirtualFrame frameValue, int state) {
        Object conditionValue_ = this.condition_.executeGeneric(frameValue);
        if ((state & 1) != 0 && conditionValue_ instanceof Boolean) {
            boolean conditionValue__ = (Boolean)conditionValue_;
            return this.doTernary(frameValue, conditionValue__);
        }
        if ((state & 2) != 0 && conditionValue_ instanceof Integer) {
            int conditionValue__ = (Integer)conditionValue_;
            return this.doTernary(frameValue, conditionValue__);
        }
        if ((state & 4) != 0 && conditionValue_ instanceof Long) {
            long conditionValue__ = (Long)conditionValue_;
            return this.doTernary(frameValue, conditionValue__);
        }
        if ((state & 8) != 0 && DebugExprTernaryNodeGen.fallbackGuard_(state, conditionValue_)) {
            return this.doError(conditionValue_);
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return this.executeAndSpecialize(frameValue, conditionValue_);
    }

    private Object executeAndSpecialize(VirtualFrame frameValue, Object conditionValue) {
        int state = this.state_;
        if (conditionValue instanceof Boolean) {
            boolean conditionValue_ = (Boolean)conditionValue;
            this.state_ = state |= 1;
            return this.doTernary(frameValue, conditionValue_);
        }
        if (conditionValue instanceof Integer) {
            int conditionValue_ = (Integer)conditionValue;
            this.state_ = state |= 2;
            return this.doTernary(frameValue, conditionValue_);
        }
        if (conditionValue instanceof Long) {
            long conditionValue_ = (Long)conditionValue;
            this.state_ = state |= 4;
            return this.doTernary(frameValue, conditionValue_);
        }
        this.state_ = state |= 8;
        return this.doError(conditionValue);
    }

    public NodeCost getCost() {
        int state = this.state_;
        if (state == 0) {
            return NodeCost.UNINITIALIZED;
        }
        if ((state & state - 1) == 0) {
            return NodeCost.MONOMORPHIC;
        }
        return NodeCost.POLYMORPHIC;
    }

    private static boolean fallbackGuard_(int state, Object conditionValue) {
        if ((state & 1) == 0 && conditionValue instanceof Boolean) {
            return false;
        }
        if ((state & 2) == 0 && conditionValue instanceof Integer) {
            return false;
        }
        return (state & 4) != 0 || !(conditionValue instanceof Long);
    }

    public static DebugExprTernaryNode create(LLVMExpressionNode thenNode, LLVMExpressionNode elseNode, LLVMExpressionNode condition) {
        return new DebugExprTernaryNodeGen(thenNode, elseNode, condition);
    }
}

