/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.interop;

import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.llvm.runtime.interop.LLVMGetInteropParamNode;
import com.oracle.truffle.llvm.runtime.interop.LLVMGetInteropStructParamNodeGen;
import com.oracle.truffle.llvm.runtime.interop.access.LLVMInteropReadNode;
import com.oracle.truffle.llvm.runtime.interop.access.LLVMInteropType;
import com.oracle.truffle.llvm.runtime.interop.convert.ForeignToLLVM;

public abstract class LLVMGetInteropStructParamNode
extends LLVMGetInteropParamNode {
    private final LLVMInteropType.Struct targetType;
    private final int argumentIndex;
    private final int memberOffset;
    private final ForeignToLLVM.ForeignToLLVMType memberType;
    @Node.Child
    LLVMInteropReadNode readNode;

    public static LLVMGetInteropStructParamNode create(LLVMInteropType.Struct targetType, int argumentIndex, int memberOffset, ForeignToLLVM.ForeignToLLVMType targetMemberType) {
        return LLVMGetInteropStructParamNodeGen.create(targetType, argumentIndex, memberOffset, targetMemberType);
    }

    LLVMGetInteropStructParamNode(LLVMInteropType.Struct targetType, int argumentIndex, int memberOffset, ForeignToLLVM.ForeignToLLVMType targetMemberType) {
        this.targetType = targetType;
        this.argumentIndex = argumentIndex;
        this.memberOffset = memberOffset;
        this.memberType = targetMemberType;
        this.readNode = LLVMInteropReadNode.create();
    }

    @Specialization
    Object getParam(Object[] arguments) {
        assert (this.argumentIndex < arguments.length);
        return this.readNode.execute(this.targetType, arguments[this.argumentIndex], this.memberOffset, this.memberType);
    }
}

