/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.interop;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.TruffleObject;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.library.ExportLibrary;
import com.oracle.truffle.api.library.ExportMessage;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.llvm.runtime.interop.LLVMInternalTruffleObject;
import com.oracle.truffle.llvm.runtime.interop.access.LLVMInteropType;
import com.oracle.truffle.llvm.runtime.library.internal.LLVMAsForeignLibrary;
import com.oracle.truffle.llvm.runtime.library.internal.LLVMManagedReadLibrary;
import com.oracle.truffle.llvm.runtime.library.internal.LLVMManagedWriteLibrary;
import com.oracle.truffle.llvm.runtime.pointer.LLVMPointer;
import com.oracle.truffle.llvm.spi.NativeTypeLibrary;

@CompilerDirectives.ValueType
@ExportLibrary.Repeat(value={@ExportLibrary(value=InteropLibrary.class, delegateTo="foreign"), @ExportLibrary(value=LLVMManagedReadLibrary.class), @ExportLibrary(value=LLVMManagedWriteLibrary.class), @ExportLibrary(value=NativeTypeLibrary.class), @ExportLibrary(value=LLVMAsForeignLibrary.class)})
public final class LLVMTypedForeignObject
extends LLVMInternalTruffleObject {
    final TypedForeignWrapper foreign;

    public static LLVMTypedForeignObject create(Object foreign, LLVMInteropType.Structured type) {
        return new LLVMTypedForeignObject(foreign, type);
    }

    private LLVMTypedForeignObject(Object foreign, LLVMInteropType.Structured type) {
        this.foreign = new TypedForeignWrapper(foreign, type);
    }

    public Object getForeign() {
        return this.foreign.delegate;
    }

    public LLVMInteropType.Structured getType() {
        return this.foreign.type;
    }

    public boolean equals(Object obj) {
        if (obj instanceof LLVMTypedForeignObject) {
            LLVMTypedForeignObject other = (LLVMTypedForeignObject)obj;
            return this.foreign.delegate.equals(other.foreign.delegate);
        }
        return this.foreign.delegate == obj;
    }

    public int hashCode() {
        return this.foreign.delegate.hashCode();
    }

    @ExportMessage
    boolean hasNativeType(@CachedLibrary(value="this.foreign.delegate") NativeTypeLibrary nativeTypes) {
        return this.foreign.hasNativeType(nativeTypes);
    }

    @ExportMessage.Repeat(value={@ExportMessage(name="isReadable"), @ExportMessage(name="isWritable")})
    boolean isAccessible() {
        return true;
    }

    @ExportMessage
    byte readI8(long offset, @CachedLibrary(value="this.foreign") LLVMManagedReadLibrary readLibrary) {
        return readLibrary.readI8(this.foreign, offset);
    }

    @ExportMessage
    short readI16(long offset, @CachedLibrary(value="this.foreign") LLVMManagedReadLibrary readLibrary) {
        return readLibrary.readI16(this.foreign, offset);
    }

    @ExportMessage
    int readI32(long offset, @CachedLibrary(value="this.foreign") LLVMManagedReadLibrary readLibrary) {
        return readLibrary.readI32(this.foreign, offset);
    }

    @ExportMessage
    float readFloat(long offset, @CachedLibrary(value="this.foreign") LLVMManagedReadLibrary readLibrary) {
        return readLibrary.readFloat(this.foreign, offset);
    }

    @ExportMessage
    double readDouble(long offset, @CachedLibrary(value="this.foreign") LLVMManagedReadLibrary readLibrary) {
        return readLibrary.readDouble(this.foreign, offset);
    }

    @ExportMessage
    LLVMPointer readPointer(long offset, @CachedLibrary(value="this.foreign") LLVMManagedReadLibrary readLibrary) {
        return readLibrary.readPointer(this.foreign, offset);
    }

    @ExportMessage
    long readI64(long offset, @CachedLibrary(value="this.foreign") LLVMManagedReadLibrary readLibrary) throws UnexpectedResultException {
        return readLibrary.readI64(this.foreign, offset);
    }

    @ExportMessage
    Object readGenericI64(long offset, @CachedLibrary(value="this.foreign") LLVMManagedReadLibrary readLibrary) {
        return readLibrary.readGenericI64(this.foreign, offset);
    }

    @ExportMessage
    void writeI8(long offset, byte value, @CachedLibrary(value="this.foreign") LLVMManagedWriteLibrary writeLibrary) {
        writeLibrary.writeI8(this.foreign, offset, value);
    }

    @ExportMessage
    void writeI16(long offset, short value, @CachedLibrary(value="this.foreign") LLVMManagedWriteLibrary writeLibrary) {
        writeLibrary.writeI16(this.foreign, offset, value);
    }

    @ExportMessage
    void writeI32(long offset, int value, @CachedLibrary(value="this.foreign") LLVMManagedWriteLibrary writeLibrary) {
        writeLibrary.writeI32(this.foreign, offset, value);
    }

    @ExportMessage
    void writeI64(long offset, long value, @CachedLibrary(value="this.foreign") LLVMManagedWriteLibrary writeLibrary) {
        writeLibrary.writeI64(this.foreign, offset, value);
    }

    @ExportMessage
    void writeFloat(long offset, float value, @CachedLibrary(value="this.foreign") LLVMManagedWriteLibrary writeLibrary) {
        writeLibrary.writeFloat(this.foreign, offset, value);
    }

    @ExportMessage
    public void writeGenericI64(long offset, Object value, @CachedLibrary(value="this.foreign") LLVMManagedWriteLibrary writeLibrary) {
        writeLibrary.writeGenericI64(this.foreign, offset, value);
    }

    @ExportMessage
    public void writeDouble(long offset, double value, @CachedLibrary(value="this.foreign") LLVMManagedWriteLibrary writeLibrary) {
        writeLibrary.writeDouble(this.foreign, offset, value);
    }

    @ExportMessage
    public void writePointer(long offset, LLVMPointer value, @CachedLibrary(value="this.foreign") LLVMManagedWriteLibrary writeLibrary) {
        writeLibrary.writePointer(this.foreign, offset, value);
    }

    @ExportMessage
    public boolean isForeign() {
        return true;
    }

    @ExportMessage
    public Object asForeign() {
        return this.foreign.delegate;
    }

    @ExportLibrary.Repeat(value={@ExportLibrary(value=NativeTypeLibrary.class), @ExportLibrary(value=LLVMAsForeignLibrary.class), @ExportLibrary(value=InteropLibrary.class, delegateTo="delegate")})
    public static class TypedForeignWrapper
    implements TruffleObject {
        final Object delegate;
        final LLVMInteropType.Structured type;

        public TypedForeignWrapper(Object delegate, LLVMInteropType.Structured type) {
            this.delegate = delegate;
            this.type = type;
        }

        @ExportMessage
        public boolean hasNativeType(@CachedLibrary(value="this.delegate") NativeTypeLibrary nativeTypes) {
            return this.type != null || nativeTypes.hasNativeType(this.delegate);
        }

        @ExportMessage
        public Object getNativeType(@CachedLibrary(value="this.delegate") NativeTypeLibrary nativeTypes) {
            if (nativeTypes.hasNativeType(this.delegate)) {
                return nativeTypes.getNativeType(this.delegate);
            }
            return this.type;
        }

        @ExportMessage
        public boolean isForeign() {
            return true;
        }

        @ExportMessage
        public Object asForeign() {
            return this.delegate;
        }
    }

    @ExportMessage
    static class GetNativeType {
        GetNativeType() {
        }

        @Specialization(guards={"typeLibrary.hasNativeType(object.foreign.delegate)"})
        static Object getType(LLVMTypedForeignObject object, @CachedLibrary(value="object.foreign.delegate") NativeTypeLibrary typeLibrary) {
            return typeLibrary.getNativeType(object.foreign.delegate);
        }

        @Specialization(guards={"!typeLibrary.hasNativeType(object.foreign.delegate)"})
        static LLVMInteropType.Structured doFallback(LLVMTypedForeignObject object, @CachedLibrary(value="object.foreign.delegate") NativeTypeLibrary typeLibrary) {
            return object.getType();
        }
    }
}

