/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.interop.access;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.InvalidArrayIndexException;
import com.oracle.truffle.api.interop.UnknownIdentifierException;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.llvm.runtime.except.LLVMPolyglotException;
import com.oracle.truffle.llvm.runtime.interop.access.LLVMInteropAccessNodeGen;
import com.oracle.truffle.llvm.runtime.interop.access.LLVMInteropType;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMNode;

@GenerateUncached
abstract class LLVMInteropAccessNode
extends LLVMNode {
    LLVMInteropAccessNode() {
    }

    protected abstract AccessLocation execute(LLVMInteropType.Structured var1, Object var2, long var3);

    public static LLVMInteropAccessNode create() {
        return LLVMInteropAccessNodeGen.create();
    }

    @Specialization
    AccessLocation doArray(LLVMInteropType.Array type, Object foreign, long offset, @Cached MakeAccessLocation makeAccessLocation) {
        long index = Long.divideUnsigned(offset, type.elementSize);
        long restOffset = Long.remainderUnsigned(offset, type.elementSize);
        return makeAccessLocation.execute(foreign, index, type.elementType, restOffset);
    }

    @Specialization(guards={"checkMember(type, cachedMember, offset)"})
    AccessLocation doStructMember(LLVMInteropType.Struct type, Object foreign, long offset, @Cached(value="findMember(type, offset)") LLVMInteropType.StructMember cachedMember, @Cached(value="create()") MakeAccessLocation makeAccessLocation) {
        return makeAccessLocation.execute(foreign, cachedMember.name, cachedMember.type, offset - cachedMember.startOffset);
    }

    @Specialization(replaces={"doStructMember"})
    AccessLocation doStruct(LLVMInteropType.Struct type, Object foreign, long offset, @Cached MakeAccessLocation makeAccessLocation) {
        LLVMInteropType.StructMember member = LLVMInteropAccessNode.findMember(type, offset);
        return makeAccessLocation.execute(foreign, member.name, member.type, offset - member.startOffset);
    }

    static boolean checkMember(LLVMInteropType.Struct struct, LLVMInteropType.StructMember member, long offset) {
        return struct == member.struct && member.contains(offset);
    }

    static LLVMInteropType.StructMember findMember(LLVMInteropType.Struct struct, long offset) {
        for (LLVMInteropType.StructMember m : struct.members) {
            if (!m.contains(offset)) continue;
            return m;
        }
        CompilerDirectives.transferToInterpreter();
        throw new IllegalStateException("invalid struct access");
    }

    @GenerateUncached
    static abstract class MakeAccessLocation
    extends LLVMNode {
        MakeAccessLocation() {
        }

        protected abstract AccessLocation execute(Object var1, Object var2, LLVMInteropType var3, long var4);

        @Specialization
        AccessLocation doValue(Object foreign, Object identifier, LLVMInteropType.Value type, long restOffset) {
            if (restOffset != 0L) {
                CompilerDirectives.transferToInterpreter();
                throw new IllegalStateException("cannot read from non-structured type with offset " + restOffset);
            }
            return new AccessLocation(foreign, identifier, type);
        }

        @Specialization(limit="3")
        AccessLocation doRecursiveObject(Object foreign, String identifier, LLVMInteropType.Structured type, long restOffset, @CachedLibrary(value="foreign") InteropLibrary interop, @Cached(value="create()") LLVMInteropAccessNode recursive) {
            Object inner;
            try {
                inner = interop.readMember(foreign, identifier);
            }
            catch (UnknownIdentifierException ex) {
                CompilerDirectives.transferToInterpreter();
                throw new LLVMPolyglotException((Node)this, "Member '%s' not found", identifier);
            }
            catch (UnsupportedMessageException ex) {
                CompilerDirectives.transferToInterpreter();
                throw new LLVMPolyglotException((Node)this, "Can not read member '%s'", identifier);
            }
            return recursive.execute(type, inner, restOffset);
        }

        @Specialization(limit="3")
        AccessLocation doRecursiveArray(Object foreign, long index, LLVMInteropType.Structured type, long restOffset, @CachedLibrary(value="foreign") InteropLibrary interop, @Cached(value="create()") LLVMInteropAccessNode recursive) {
            Object inner;
            try {
                inner = interop.readArrayElement(foreign, index);
            }
            catch (InvalidArrayIndexException ex) {
                CompilerDirectives.transferToInterpreter();
                throw new LLVMPolyglotException((Node)this, "Invalid array index %d", index);
            }
            catch (UnsupportedMessageException ex) {
                CompilerDirectives.transferToInterpreter();
                throw new LLVMPolyglotException((Node)this, "Cannot acess array element %d", index);
            }
            return recursive.execute(type, inner, restOffset);
        }
    }

    @CompilerDirectives.ValueType
    protected static class AccessLocation {
        final Object base;
        final Object identifier;
        final LLVMInteropType.Value type;

        AccessLocation(Object base, Object identifier, LLVMInteropType.Value type) {
            this.base = base;
            this.identifier = identifier;
            this.type = type;
        }
    }
}

