/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.interop.access;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.TruffleObject;
import com.oracle.truffle.api.library.ExportLibrary;
import com.oracle.truffle.api.library.ExportMessage;
import com.oracle.truffle.llvm.runtime.LLVMLanguage;
import com.oracle.truffle.llvm.runtime.debug.type.LLVMSourceArrayLikeType;
import com.oracle.truffle.llvm.runtime.debug.type.LLVMSourceBasicType;
import com.oracle.truffle.llvm.runtime.debug.type.LLVMSourceFunctionType;
import com.oracle.truffle.llvm.runtime.debug.type.LLVMSourceMemberType;
import com.oracle.truffle.llvm.runtime.debug.type.LLVMSourcePointerType;
import com.oracle.truffle.llvm.runtime.debug.type.LLVMSourceStructLikeType;
import com.oracle.truffle.llvm.runtime.debug.type.LLVMSourceType;
import com.oracle.truffle.llvm.runtime.interop.convert.ForeignToLLVM;
import com.oracle.truffle.llvm.runtime.pointer.LLVMPointer;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.graalvm.collections.EconomicMap;
import org.graalvm.collections.EconomicSet;
import org.graalvm.collections.Equivalence;

@ExportLibrary(value=InteropLibrary.class)
public abstract class LLVMInteropType
implements TruffleObject {
    public static final Value UNKNOWN = Value.access$000(null, 0L);
    private final long size;

    private LLVMInteropType(long size) {
        this.size = size;
    }

    public long getSize() {
        return this.size;
    }

    public Array toArray(long length) {
        return new Array(this, this.size, length);
    }

    @ExportMessage
    boolean isMetaObject() {
        return true;
    }

    @ExportMessage.Repeat(value={@ExportMessage(name="getMetaSimpleName"), @ExportMessage(name="getMetaQualifiedName")})
    @CompilerDirectives.TruffleBoundary
    Object getMetaSimpleName() {
        return this.toString();
    }

    @ExportMessage
    boolean isMetaInstance(Object instance) {
        if (LLVMPointer.isInstance(instance)) {
            return LLVMPointer.cast(instance).getExportType() == this;
        }
        return false;
    }

    @CompilerDirectives.TruffleBoundary
    public final String toString() {
        return this.toString((EconomicSet<LLVMInteropType>)EconomicSet.create((Equivalence)Equivalence.IDENTITY_WITH_SYSTEM_HASHCODE));
    }

    @ExportMessage
    final boolean hasLanguage() {
        return true;
    }

    @ExportMessage
    final Class<? extends TruffleLanguage<?>> getLanguage() {
        return LLVMLanguage.class;
    }

    @ExportMessage
    @CompilerDirectives.TruffleBoundary
    final String toDisplayString(boolean allowSideEffects) {
        return this.toString();
    }

    protected abstract String toString(EconomicSet<LLVMInteropType> var1);

    public static final class InteropTypeRegistry {
        private final EconomicMap<LLVMSourceType, LLVMInteropType> typeCache = EconomicMap.create((Equivalence)Equivalence.IDENTITY_WITH_SYSTEM_HASHCODE);

        public synchronized LLVMInteropType get(LLVMSourceType type) {
            if (type == null) {
                return UNKNOWN;
            }
            LLVMSourceType actual = type.getActualType();
            if (this.typeCache.containsKey((Object)actual)) {
                return (LLVMInteropType)this.typeCache.get((Object)actual);
            }
            LLVMInteropType ret = this.convert(actual);
            this.typeCache.put((Object)actual, (Object)ret);
            return ret;
        }

        private LLVMInteropType convert(LLVMSourceType type) {
            if (type instanceof LLVMSourcePointerType) {
                return this.convertPointer((LLVMSourcePointerType)type);
            }
            if (type instanceof LLVMSourceBasicType) {
                return InteropTypeRegistry.convertBasic((LLVMSourceBasicType)type);
            }
            return this.convertStructured(type);
        }

        private Structured getStructured(LLVMSourceType type) {
            LLVMSourceType actual = type.getActualType();
            if (this.typeCache.containsKey((Object)actual)) {
                LLVMInteropType ret = (LLVMInteropType)this.typeCache.get((Object)actual);
                if (ret instanceof Structured) {
                    return (Structured)ret;
                }
                return null;
            }
            return this.convertStructured(actual);
        }

        private Structured convertStructured(LLVMSourceType type) {
            if (type instanceof LLVMSourceArrayLikeType) {
                return this.convertArray((LLVMSourceArrayLikeType)type);
            }
            if (type instanceof LLVMSourceStructLikeType) {
                return this.convertStruct((LLVMSourceStructLikeType)type);
            }
            if (type instanceof LLVMSourceFunctionType) {
                return this.convertFunction((LLVMSourceFunctionType)type);
            }
            return null;
        }

        private Array convertArray(LLVMSourceArrayLikeType type) {
            LLVMSourceType base = type.getBaseType();
            return new Array(new Register(type, base), base.getSize() / 8L, type.getLength());
        }

        private Struct convertStruct(LLVMSourceStructLikeType type) {
            Struct ret = new Struct(type.getName(), new StructMember[type.getDynamicElementCount()], type.getSize() / 8L);
            this.typeCache.put((Object)type, (Object)ret);
            for (int i = 0; i < ret.members.length; ++i) {
                LLVMSourceMemberType member = type.getDynamicElement(i);
                LLVMSourceType memberType = member.getElementType();
                long startOffset = member.getOffset() / 8L;
                long endOffset = startOffset + (memberType.getSize() + 7L) / 8L;
                ret.members[i] = new StructMember(ret, member.getName(), startOffset, endOffset, this.get(memberType));
            }
            return ret;
        }

        private Function convertFunction(LLVMSourceFunctionType functionType) {
            List<LLVMSourceType> parameterTypes = functionType.getParameterTypes();
            LLVMInteropType[] interopParameterTypes = new LLVMInteropType[parameterTypes.size()];
            Function interopFunctionType = new Function(new Register(functionType, functionType.getReturnType()), interopParameterTypes);
            this.typeCache.put((Object)functionType, (Object)interopFunctionType);
            for (int i = 0; i < interopParameterTypes.length; ++i) {
                interopParameterTypes[i] = this.get(parameterTypes.get(i));
            }
            return interopFunctionType;
        }

        private static Value convertBasic(LLVMSourceBasicType type) {
            switch (type.getKind()) {
                case ADDRESS: {
                    return ValueKind.POINTER.type;
                }
                case BOOLEAN: {
                    return ValueKind.I1.type;
                }
                case FLOATING: {
                    switch ((int)type.getSize()) {
                        case 32: {
                            return ValueKind.FLOAT.type;
                        }
                        case 64: {
                            return ValueKind.DOUBLE.type;
                        }
                    }
                    break;
                }
                case SIGNED: 
                case SIGNED_CHAR: 
                case UNSIGNED: 
                case UNSIGNED_CHAR: {
                    switch ((int)type.getSize()) {
                        case 1: {
                            return ValueKind.I1.type;
                        }
                        case 8: {
                            return ValueKind.I8.type;
                        }
                        case 16: {
                            return ValueKind.I16.type;
                        }
                        case 32: {
                            return ValueKind.I32.type;
                        }
                        case 64: {
                            return ValueKind.I64.type;
                        }
                    }
                }
            }
            return UNKNOWN;
        }

        private Value convertPointer(LLVMSourcePointerType type) {
            return Value.pointer(this.getStructured(type.getBaseType()), type.getSize() / 8L);
        }

        private final class Register {
            private final LLVMSourceType source;
            private final LLVMSourceType target;

            private Register(LLVMSourceType source, LLVMSourceType target) {
                this.source = source;
                this.target = target;
            }

            LLVMInteropType get(LLVMInteropType self) {
                assert (!InteropTypeRegistry.this.typeCache.containsKey((Object)this.source));
                InteropTypeRegistry.this.typeCache.put((Object)this.source, (Object)self);
                return InteropTypeRegistry.this.get(this.target);
            }
        }
    }

    public static final class Function
    extends Structured {
        final LLVMInteropType returnType;
        @CompilerDirectives.CompilationFinal(dimensions=1)
        final LLVMInteropType[] parameterTypes;

        Function(InteropTypeRegistry.Register returnType, LLVMInteropType[] parameterTypes) {
            super(0L);
            this.returnType = returnType.get(this);
            this.parameterTypes = parameterTypes;
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        protected String toString(EconomicSet<LLVMInteropType> visited) {
            if (visited.contains((Object)this)) {
                return "<recursive function type>";
            }
            visited.add((Object)this);
            return String.format("%s(%s)", this.returnType == null ? "void" : this.returnType.toString(visited), Arrays.stream(this.parameterTypes).map(t -> t == null ? "<null>" : t.toString(visited)).collect(Collectors.joining(", ")));
        }

        public LLVMInteropType getReturnType() {
            return this.returnType;
        }

        public LLVMInteropType getParameter(int i) {
            return this.parameterTypes[i];
        }

        public int getNumberOfParameters() {
            return this.parameterTypes.length;
        }
    }

    public static final class StructMember {
        final Struct struct;
        final String name;
        final long startOffset;
        final long endOffset;
        final LLVMInteropType type;

        StructMember(Struct struct, String name, long startOffset, long endOffset, LLVMInteropType type) {
            this.struct = struct;
            this.name = name;
            this.startOffset = startOffset;
            this.endOffset = endOffset;
            this.type = type;
        }

        boolean contains(long offset) {
            return this.startOffset <= offset && this.startOffset == this.endOffset | offset < this.endOffset;
        }

        public String getName() {
            return this.name;
        }

        public LLVMInteropType getType() {
            return this.type;
        }

        public Struct getStruct() {
            return this.struct;
        }

        public long getStartOffset() {
            return this.startOffset;
        }
    }

    public static final class Struct
    extends Structured {
        private final String name;
        @CompilerDirectives.CompilationFinal(dimensions=1)
        final StructMember[] members;

        Struct(String name, StructMember[] members, long size) {
            super(size);
            this.name = name;
            this.members = members;
        }

        public StructMember getMember(int i) {
            return this.members[i];
        }

        @CompilerDirectives.TruffleBoundary
        public StructMember findMember(String memberName) {
            for (StructMember member : this.members) {
                if (!member.getName().equals(memberName)) continue;
                return member;
            }
            return null;
        }

        public int getMemberCount() {
            return this.members.length;
        }

        @Override
        protected String toString(EconomicSet<LLVMInteropType> visited) {
            return this.name;
        }
    }

    public static final class Array
    extends Structured {
        final LLVMInteropType elementType;
        final long elementSize;
        final long length;

        Array(InteropTypeRegistry.Register elementType, long elementSize, long length) {
            super(elementSize * length);
            this.elementType = elementType.get(this);
            this.elementSize = elementSize;
            this.length = length;
        }

        private Array(LLVMInteropType elementType, long elementSize, long length) {
            super(elementSize * length);
            this.elementType = elementType;
            this.elementSize = elementSize;
            this.length = length;
        }

        public LLVMInteropType getElementType() {
            return this.elementType;
        }

        public long getElementSize() {
            return this.elementSize;
        }

        public long getLength() {
            return this.length;
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        protected String toString(EconomicSet<LLVMInteropType> visited) {
            if (visited.contains((Object)this)) {
                return "<recursive array type>";
            }
            visited.add((Object)this);
            return String.format("%s[%d]", this.elementType.toString(visited), this.length);
        }
    }

    public static abstract class Structured
    extends LLVMInteropType {
        Structured(long size) {
            super(size);
        }
    }

    public static final class Value
    extends LLVMInteropType {
        final ValueKind kind;
        final Structured baseType;

        private static Value primitive(ValueKind kind, long size) {
            return new Value(kind, null, size);
        }

        public static Value pointer(Structured baseType, long size) {
            return new Value(ValueKind.POINTER, baseType, size);
        }

        private Value(ValueKind kind, Structured baseType, long size) {
            super(size);
            this.kind = kind;
            this.baseType = baseType;
        }

        public ValueKind getKind() {
            return this.kind;
        }

        public Structured getBaseType() {
            return this.baseType;
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        protected String toString(EconomicSet<LLVMInteropType> visited) {
            if (visited.contains((Object)this)) {
                return String.format("<recursive %s>", this.kind.name());
            }
            visited.add((Object)this);
            if (this.baseType == null) {
                return this.kind.name();
            }
            return this.baseType.toString(visited) + "*";
        }
    }

    public static enum ValueKind {
        I1(ForeignToLLVM.ForeignToLLVMType.I1),
        I8(ForeignToLLVM.ForeignToLLVMType.I8),
        I16(ForeignToLLVM.ForeignToLLVMType.I16),
        I32(ForeignToLLVM.ForeignToLLVMType.I32),
        I64(ForeignToLLVM.ForeignToLLVMType.I64),
        FLOAT(ForeignToLLVM.ForeignToLLVMType.FLOAT),
        DOUBLE(ForeignToLLVM.ForeignToLLVMType.DOUBLE),
        POINTER(ForeignToLLVM.ForeignToLLVMType.POINTER);

        public final Value type;
        public final ForeignToLLVM.ForeignToLLVMType foreignToLLVMType;

        private ValueKind(ForeignToLLVM.ForeignToLLVMType foreignToLLVMType) {
            this.foreignToLLVMType = foreignToLLVMType;
            this.type = Value.primitive(this, foreignToLLVMType.getSizeInBytes());
        }
    }
}

