/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.interop.convert;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.interop.UnsupportedTypeException;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.llvm.runtime.interop.LLVMInternalTruffleObject;
import com.oracle.truffle.llvm.runtime.interop.convert.ForeignToLLVM;
import com.oracle.truffle.llvm.runtime.library.internal.LLVMAsForeignLibrary;
import com.oracle.truffle.llvm.runtime.pointer.LLVMManagedPointer;
import com.oracle.truffle.llvm.runtime.pointer.LLVMPointer;

public abstract class ToAnyLLVM
extends ForeignToLLVM {
    @Specialization
    protected int fromInt(int value) {
        return value;
    }

    @Specialization
    protected char fromChar(char value) {
        return value;
    }

    @Specialization
    protected long fromLong(long value) {
        return value;
    }

    @Specialization
    protected byte fromByte(byte value) {
        return value;
    }

    @Specialization
    protected short fromShort(short value) {
        return value;
    }

    @Specialization
    protected float fromFloat(float value) {
        return value;
    }

    @Specialization
    protected double fromDouble(double value) {
        return value;
    }

    @Specialization
    protected boolean fromBoolean(boolean value) {
        return value;
    }

    @Specialization
    protected String fromString(String obj) {
        return obj;
    }

    @Specialization
    protected LLVMPointer fromPointer(LLVMPointer pointer) {
        return pointer;
    }

    @Specialization(guards={"foreigns.isForeign(obj)"})
    protected LLVMManagedPointer fromUnknownObject(Object obj, @CachedLibrary(limit="3") LLVMAsForeignLibrary foreigns) {
        return LLVMManagedPointer.create(obj);
    }

    @Specialization
    protected LLVMManagedPointer fromInternal(LLVMInternalTruffleObject object) {
        return LLVMManagedPointer.create(object);
    }

    @CompilerDirectives.TruffleBoundary
    static Object slowPathPrimitiveConvert(Object value) throws UnsupportedTypeException {
        if (value instanceof Number) {
            return value;
        }
        if (value instanceof Boolean) {
            return value;
        }
        if (value instanceof Character) {
            return value;
        }
        if (value instanceof String) {
            return value;
        }
        if (LLVMPointer.isInstance(value)) {
            return value;
        }
        if (value instanceof LLVMInternalTruffleObject) {
            return LLVMManagedPointer.create(value);
        }
        if (((LLVMAsForeignLibrary)LLVMAsForeignLibrary.getFactory().getUncached()).isForeign(value)) {
            return LLVMManagedPointer.create(value);
        }
        throw UnsupportedTypeException.create((Object[])new Object[]{value});
    }
}

