/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.interop.convert;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.library.LibraryFactory;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.llvm.runtime.interop.LLVMInternalTruffleObject;
import com.oracle.truffle.llvm.runtime.interop.access.LLVMInteropType;
import com.oracle.truffle.llvm.runtime.interop.convert.ForeignToLLVM;
import com.oracle.truffle.llvm.runtime.interop.convert.ToPointer;
import com.oracle.truffle.llvm.runtime.library.internal.LLVMAsForeignLibrary;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMTypes;
import com.oracle.truffle.llvm.runtime.pointer.LLVMManagedPointer;
import com.oracle.truffle.llvm.runtime.pointer.LLVMPointer;
import com.oracle.truffle.llvm.spi.NativeTypeLibrary;
import java.util.concurrent.locks.Lock;

@GeneratedBy(value=ToPointer.class)
public final class ToPointerNodeGen
extends ToPointer {
    private static final LibraryFactory<LLVMAsForeignLibrary> L_L_V_M_AS_FOREIGN_LIBRARY_ = LibraryFactory.resolve(LLVMAsForeignLibrary.class);
    private static final LibraryFactory<NativeTypeLibrary> NATIVE_TYPE_LIBRARY_ = LibraryFactory.resolve(NativeTypeLibrary.class);
    @Node.Child
    private ToPointer.Dummy child0_;
    @Node.Child
    private ToPointer.InteropTypeNode child1_;
    @CompilerDirectives.CompilationFinal
    private volatile int state_;
    @Node.Child
    private NativeTypeLibrary fromTypedTruffleObjectNoAttachedType_nativeTypes_;
    @Node.Child
    private LLVMAsForeignLibrary fromTypedTruffleObjectNoAttachedType_foreigns_;
    @Node.Child
    private NativeTypeLibrary fromNonTypedTruffleObject_nativeTypes_;
    @Node.Child
    private LLVMAsForeignLibrary fromNonTypedTruffleObject_foreigns_;

    private ToPointerNodeGen(ToPointer.Dummy child0, ToPointer.InteropTypeNode child1) {
        this.child0_ = child0;
        this.child1_ = child1;
    }

    @Override
    public Object executeWithForeignToLLVMType(Object child0Value, LLVMInteropType.Structured child1Value, ForeignToLLVM.ForeignToLLVMType ftlType) {
        int state = this.state_;
        if (state != 0) {
            if ((state & 1) != 0 && child0Value instanceof Integer) {
                int child0Value_ = (Integer)child0Value;
                return this.fromInt(child0Value_, child1Value);
            }
            if ((state & 2) != 0 && child0Value instanceof Character) {
                char child0Value_ = ((Character)child0Value).charValue();
                return this.fromChar(child0Value_, child1Value);
            }
            if ((state & 4) != 0 && child0Value instanceof Long) {
                long child0Value_ = (Long)child0Value;
                return this.fromLong(child0Value_, child1Value);
            }
            if ((state & 8) != 0 && child0Value instanceof Byte) {
                byte child0Value_ = (Byte)child0Value;
                return this.fromByte(child0Value_, child1Value);
            }
            if ((state & 0x10) != 0 && child0Value instanceof Short) {
                short child0Value_ = (Short)child0Value;
                return this.fromShort(child0Value_, child1Value);
            }
            if ((state & 0x20) != 0 && child0Value instanceof Float) {
                float child0Value_ = ((Float)child0Value).floatValue();
                return this.fromFloat(child0Value_, child1Value);
            }
            if ((state & 0x40) != 0 && child0Value instanceof Double) {
                double child0Value_ = (Double)child0Value;
                return this.fromDouble(child0Value_, child1Value);
            }
            if ((state & 0x80) != 0 && child0Value instanceof Boolean) {
                boolean child0Value_ = (Boolean)child0Value;
                return this.fromBoolean(child0Value_, child1Value);
            }
            if ((state & 0x100) != 0 && child0Value instanceof String) {
                String child0Value_ = (String)child0Value;
                return this.fromString(child0Value_, child1Value);
            }
            if ((state & 0x200) != 0 && LLVMTypes.isPointer(child0Value)) {
                LLVMPointer child0Value_ = LLVMTypes.asPointer(child0Value);
                return this.fromPointer(child0Value_, child1Value);
            }
            if ((state & 0xC00) != 0) {
                if ((state & 0x400) != 0 && this.fromTypedTruffleObjectNoAttachedType_foreigns_.isForeign(child0Value) && this.fromTypedTruffleObjectNoAttachedType_nativeTypes_.hasNativeType(child0Value)) {
                    return this.fromTypedTruffleObjectNoAttachedType(child0Value, child1Value, this.fromTypedTruffleObjectNoAttachedType_nativeTypes_, this.fromTypedTruffleObjectNoAttachedType_foreigns_);
                }
                if ((state & 0x800) != 0 && this.fromNonTypedTruffleObject_foreigns_.isForeign(child0Value) && !this.fromNonTypedTruffleObject_nativeTypes_.hasNativeType(child0Value)) {
                    return this.fromNonTypedTruffleObject(child0Value, child1Value, this.fromNonTypedTruffleObject_nativeTypes_, this.fromNonTypedTruffleObject_foreigns_);
                }
            }
            if ((state & 0x1000) != 0 && child0Value instanceof LLVMInternalTruffleObject) {
                LLVMInternalTruffleObject child0Value_ = (LLVMInternalTruffleObject)child0Value;
                return this.fromInternal(child0Value_, child1Value);
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return this.executeAndSpecialize(child0Value, child1Value);
    }

    @Override
    public Object executeWithType(Object child0Value, LLVMInteropType.Structured child1Value) {
        int state = this.state_;
        if (state != 0) {
            if ((state & 1) != 0 && child0Value instanceof Integer) {
                int child0Value_ = (Integer)child0Value;
                return this.fromInt(child0Value_, child1Value);
            }
            if ((state & 2) != 0 && child0Value instanceof Character) {
                char child0Value_ = ((Character)child0Value).charValue();
                return this.fromChar(child0Value_, child1Value);
            }
            if ((state & 4) != 0 && child0Value instanceof Long) {
                long child0Value_ = (Long)child0Value;
                return this.fromLong(child0Value_, child1Value);
            }
            if ((state & 8) != 0 && child0Value instanceof Byte) {
                byte child0Value_ = (Byte)child0Value;
                return this.fromByte(child0Value_, child1Value);
            }
            if ((state & 0x10) != 0 && child0Value instanceof Short) {
                short child0Value_ = (Short)child0Value;
                return this.fromShort(child0Value_, child1Value);
            }
            if ((state & 0x20) != 0 && child0Value instanceof Float) {
                float child0Value_ = ((Float)child0Value).floatValue();
                return this.fromFloat(child0Value_, child1Value);
            }
            if ((state & 0x40) != 0 && child0Value instanceof Double) {
                double child0Value_ = (Double)child0Value;
                return this.fromDouble(child0Value_, child1Value);
            }
            if ((state & 0x80) != 0 && child0Value instanceof Boolean) {
                boolean child0Value_ = (Boolean)child0Value;
                return this.fromBoolean(child0Value_, child1Value);
            }
            if ((state & 0x100) != 0 && child0Value instanceof String) {
                String child0Value_ = (String)child0Value;
                return this.fromString(child0Value_, child1Value);
            }
            if ((state & 0x200) != 0 && LLVMTypes.isPointer(child0Value)) {
                LLVMPointer child0Value_ = LLVMTypes.asPointer(child0Value);
                return this.fromPointer(child0Value_, child1Value);
            }
            if ((state & 0xC00) != 0) {
                if ((state & 0x400) != 0 && this.fromTypedTruffleObjectNoAttachedType_foreigns_.isForeign(child0Value) && this.fromTypedTruffleObjectNoAttachedType_nativeTypes_.hasNativeType(child0Value)) {
                    return this.fromTypedTruffleObjectNoAttachedType(child0Value, child1Value, this.fromTypedTruffleObjectNoAttachedType_nativeTypes_, this.fromTypedTruffleObjectNoAttachedType_foreigns_);
                }
                if ((state & 0x800) != 0 && this.fromNonTypedTruffleObject_foreigns_.isForeign(child0Value) && !this.fromNonTypedTruffleObject_nativeTypes_.hasNativeType(child0Value)) {
                    return this.fromNonTypedTruffleObject(child0Value, child1Value, this.fromNonTypedTruffleObject_nativeTypes_, this.fromNonTypedTruffleObject_foreigns_);
                }
            }
            if ((state & 0x1000) != 0 && child0Value instanceof LLVMInternalTruffleObject) {
                LLVMInternalTruffleObject child0Value_ = (LLVMInternalTruffleObject)child0Value;
                return this.fromInternal(child0Value_, child1Value);
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return this.executeAndSpecialize(child0Value, child1Value);
    }

    @Override
    public Object executeWithTarget(Object child0Value) {
        int state = this.state_;
        LLVMInteropType.Structured child1Value_ = this.child1_.execute();
        if (state != 0) {
            if ((state & 1) != 0 && child0Value instanceof Integer) {
                int child0Value_ = (Integer)child0Value;
                return this.fromInt(child0Value_, child1Value_);
            }
            if ((state & 2) != 0 && child0Value instanceof Character) {
                char child0Value_ = ((Character)child0Value).charValue();
                return this.fromChar(child0Value_, child1Value_);
            }
            if ((state & 4) != 0 && child0Value instanceof Long) {
                long child0Value_ = (Long)child0Value;
                return this.fromLong(child0Value_, child1Value_);
            }
            if ((state & 8) != 0 && child0Value instanceof Byte) {
                byte child0Value_ = (Byte)child0Value;
                return this.fromByte(child0Value_, child1Value_);
            }
            if ((state & 0x10) != 0 && child0Value instanceof Short) {
                short child0Value_ = (Short)child0Value;
                return this.fromShort(child0Value_, child1Value_);
            }
            if ((state & 0x20) != 0 && child0Value instanceof Float) {
                float child0Value_ = ((Float)child0Value).floatValue();
                return this.fromFloat(child0Value_, child1Value_);
            }
            if ((state & 0x40) != 0 && child0Value instanceof Double) {
                double child0Value_ = (Double)child0Value;
                return this.fromDouble(child0Value_, child1Value_);
            }
            if ((state & 0x80) != 0 && child0Value instanceof Boolean) {
                boolean child0Value_ = (Boolean)child0Value;
                return this.fromBoolean(child0Value_, child1Value_);
            }
            if ((state & 0x100) != 0 && child0Value instanceof String) {
                String child0Value_ = (String)child0Value;
                return this.fromString(child0Value_, child1Value_);
            }
            if ((state & 0x200) != 0 && LLVMTypes.isPointer(child0Value)) {
                LLVMPointer child0Value_ = LLVMTypes.asPointer(child0Value);
                return this.fromPointer(child0Value_, child1Value_);
            }
            if ((state & 0xC00) != 0) {
                if ((state & 0x400) != 0 && this.fromTypedTruffleObjectNoAttachedType_foreigns_.isForeign(child0Value) && this.fromTypedTruffleObjectNoAttachedType_nativeTypes_.hasNativeType(child0Value)) {
                    return this.fromTypedTruffleObjectNoAttachedType(child0Value, child1Value_, this.fromTypedTruffleObjectNoAttachedType_nativeTypes_, this.fromTypedTruffleObjectNoAttachedType_foreigns_);
                }
                if ((state & 0x800) != 0 && this.fromNonTypedTruffleObject_foreigns_.isForeign(child0Value) && !this.fromNonTypedTruffleObject_nativeTypes_.hasNativeType(child0Value)) {
                    return this.fromNonTypedTruffleObject(child0Value, child1Value_, this.fromNonTypedTruffleObject_nativeTypes_, this.fromNonTypedTruffleObject_foreigns_);
                }
            }
            if ((state & 0x1000) != 0 && child0Value instanceof LLVMInternalTruffleObject) {
                LLVMInternalTruffleObject child0Value_ = (LLVMInternalTruffleObject)child0Value;
                return this.fromInternal(child0Value_, child1Value_);
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return this.executeAndSpecialize(child0Value, child1Value_);
    }

    private Object executeAndSpecialize(Object child0Value, LLVMInteropType.Structured child1Value) {
        Lock lock = this.getLock();
        boolean hasLock = true;
        lock.lock();
        int state = this.state_;
        try {
            NativeTypeLibrary fromNonTypedTruffleObject_nativeTypes__;
            NativeTypeLibrary fromTypedTruffleObjectNoAttachedType_nativeTypes__;
            if (child0Value instanceof Integer) {
                int child0Value_ = (Integer)child0Value;
                this.state_ = state |= 1;
                lock.unlock();
                hasLock = false;
                LLVMManagedPointer lLVMManagedPointer = this.fromInt(child0Value_, child1Value);
                return lLVMManagedPointer;
            }
            if (child0Value instanceof Character) {
                char child0Value_ = ((Character)child0Value).charValue();
                this.state_ = state |= 2;
                lock.unlock();
                hasLock = false;
                LLVMManagedPointer lLVMManagedPointer = this.fromChar(child0Value_, child1Value);
                return lLVMManagedPointer;
            }
            if (child0Value instanceof Long) {
                long child0Value_ = (Long)child0Value;
                this.state_ = state |= 4;
                lock.unlock();
                hasLock = false;
                LLVMManagedPointer lLVMManagedPointer = this.fromLong(child0Value_, child1Value);
                return lLVMManagedPointer;
            }
            if (child0Value instanceof Byte) {
                byte child0Value_ = (Byte)child0Value;
                this.state_ = state |= 8;
                lock.unlock();
                hasLock = false;
                LLVMManagedPointer lLVMManagedPointer = this.fromByte(child0Value_, child1Value);
                return lLVMManagedPointer;
            }
            if (child0Value instanceof Short) {
                short child0Value_ = (Short)child0Value;
                this.state_ = state |= 0x10;
                lock.unlock();
                hasLock = false;
                LLVMManagedPointer lLVMManagedPointer = this.fromShort(child0Value_, child1Value);
                return lLVMManagedPointer;
            }
            if (child0Value instanceof Float) {
                float child0Value_ = ((Float)child0Value).floatValue();
                this.state_ = state |= 0x20;
                lock.unlock();
                hasLock = false;
                LLVMManagedPointer lLVMManagedPointer = this.fromFloat(child0Value_, child1Value);
                return lLVMManagedPointer;
            }
            if (child0Value instanceof Double) {
                double child0Value_ = (Double)child0Value;
                this.state_ = state |= 0x40;
                lock.unlock();
                hasLock = false;
                LLVMManagedPointer lLVMManagedPointer = this.fromDouble(child0Value_, child1Value);
                return lLVMManagedPointer;
            }
            if (child0Value instanceof Boolean) {
                boolean child0Value_ = (Boolean)child0Value;
                this.state_ = state |= 0x80;
                lock.unlock();
                hasLock = false;
                LLVMManagedPointer lLVMManagedPointer = this.fromBoolean(child0Value_, child1Value);
                return lLVMManagedPointer;
            }
            if (child0Value instanceof String) {
                String child0Value_ = (String)child0Value;
                this.state_ = state |= 0x100;
                lock.unlock();
                hasLock = false;
                String string = this.fromString(child0Value_, child1Value);
                return string;
            }
            if (LLVMTypes.isPointer(child0Value)) {
                LLVMPointer child0Value_ = LLVMTypes.asPointer(child0Value);
                this.state_ = state |= 0x200;
                lock.unlock();
                hasLock = false;
                LLVMPointer lLVMPointer = this.fromPointer(child0Value_, child1Value);
                return lLVMPointer;
            }
            LLVMAsForeignLibrary fromTypedTruffleObjectNoAttachedType_foreigns__ = (LLVMAsForeignLibrary)super.insert((Node)((LLVMAsForeignLibrary)L_L_V_M_AS_FOREIGN_LIBRARY_.createDispatched(3)));
            if (fromTypedTruffleObjectNoAttachedType_foreigns__.isForeign(child0Value) && (fromTypedTruffleObjectNoAttachedType_nativeTypes__ = (NativeTypeLibrary)super.insert((Node)((NativeTypeLibrary)NATIVE_TYPE_LIBRARY_.createDispatched(3)))).hasNativeType(child0Value)) {
                this.fromTypedTruffleObjectNoAttachedType_nativeTypes_ = (NativeTypeLibrary)super.insert((Node)fromTypedTruffleObjectNoAttachedType_nativeTypes__);
                this.fromTypedTruffleObjectNoAttachedType_foreigns_ = (LLVMAsForeignLibrary)super.insert((Node)fromTypedTruffleObjectNoAttachedType_foreigns__);
                this.state_ = state |= 0x400;
                lock.unlock();
                hasLock = false;
                LLVMManagedPointer lLVMManagedPointer = this.fromTypedTruffleObjectNoAttachedType(child0Value, child1Value, fromTypedTruffleObjectNoAttachedType_nativeTypes__, fromTypedTruffleObjectNoAttachedType_foreigns__);
                return lLVMManagedPointer;
            }
            LLVMAsForeignLibrary fromNonTypedTruffleObject_foreigns__ = (LLVMAsForeignLibrary)super.insert((Node)((LLVMAsForeignLibrary)L_L_V_M_AS_FOREIGN_LIBRARY_.createDispatched(3)));
            if (fromNonTypedTruffleObject_foreigns__.isForeign(child0Value) && !(fromNonTypedTruffleObject_nativeTypes__ = (NativeTypeLibrary)super.insert((Node)((NativeTypeLibrary)NATIVE_TYPE_LIBRARY_.createDispatched(3)))).hasNativeType(child0Value)) {
                this.fromNonTypedTruffleObject_nativeTypes_ = (NativeTypeLibrary)super.insert((Node)fromNonTypedTruffleObject_nativeTypes__);
                this.fromNonTypedTruffleObject_foreigns_ = (LLVMAsForeignLibrary)super.insert((Node)fromNonTypedTruffleObject_foreigns__);
                this.state_ = state |= 0x800;
                lock.unlock();
                hasLock = false;
                LLVMManagedPointer lLVMManagedPointer = this.fromNonTypedTruffleObject(child0Value, child1Value, fromNonTypedTruffleObject_nativeTypes__, fromNonTypedTruffleObject_foreigns__);
                return lLVMManagedPointer;
            }
            if (child0Value instanceof LLVMInternalTruffleObject) {
                LLVMInternalTruffleObject child0Value_ = (LLVMInternalTruffleObject)child0Value;
                this.state_ = state |= 0x1000;
                lock.unlock();
                hasLock = false;
                LLVMManagedPointer lLVMManagedPointer = this.fromInternal(child0Value_, child1Value);
                return lLVMManagedPointer;
            }
            throw new UnsupportedSpecializationException((Node)this, new Node[]{this.child0_, this.child1_}, new Object[]{child0Value, child1Value});
        }
        finally {
            if (hasLock) {
                lock.unlock();
            }
        }
    }

    public NodeCost getCost() {
        int state = this.state_;
        if (state == 0) {
            return NodeCost.UNINITIALIZED;
        }
        if ((state & state - 1) == 0) {
            return NodeCost.MONOMORPHIC;
        }
        return NodeCost.POLYMORPHIC;
    }

    public static ToPointer create(ToPointer.Dummy child0, ToPointer.InteropTypeNode child1) {
        return new ToPointerNodeGen(child0, child1);
    }
}

